
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <stdarg.h>

#define spawnl(path, arg, args...) spawnfunc(execv, path , arg , ## args )
#define spawnlp(file, arg, args...) spawnfunc(execvp, file , arg , ## args )
#define spawnle(path, arg, args...) spawnfunc(exect, path , arg , ## args )


pid_t SPAWN_CHILD_PID=0;

#define pid SPAWN_CHILD_PID

int spawnfunc(int (*func)(const char *path, char *const argv[]),const char *file, char *arg, ...) {
  int status;
  struct sigaction ignore, saveintr, savequit, savealrm;
  sigset_t chldmask, savemask;
  va_list va;

  if (file==NULL) return 1;

  ignore.sa_handler=SIG_IGN; /* ignore SIGINT and SIGQUIT */
  sigemptyset(&ignore.sa_mask);
  ignore.sa_flags=0;
  if (sigaction(SIGINT, &ignore, &saveintr)<0) return -1;
  if (sigaction(SIGQUIT,&ignore, &savequit)<0) return -1;
  if (sigaction(SIGALRM,&ignore, &savealrm)<0) return -1; 

  sigemptyset(&chldmask);  /* now block SIGCHLD */
  sigaddset(&chldmask, SIGCHLD);
  if (sigprocmask(SIG_BLOCK, &chldmask, &savemask)<0) return -1;

  if ( (pid = fork()) < 0 ) { pid=0; status=-1; } /* probably out of processes */
  else if (pid==0) { /* child */
    /* restore previous signal actions & reset signal mask */
    signal(SIGINT, SIG_DFL); /* &saveintr, NULL); */
    signal(SIGQUIT, SIG_DFL); /* &savequit, NULL); */
    signal(SIGALRM, SIG_DFL);  
    sigprocmask(SIG_SETMASK, &savemask, NULL);

    /*
       assumptions:
         the arglist is const, and won't be modified while I'm calling execvp()
	 the args are seperated by the same offsets that a char *[] would be
    */
    
    /* actual spawn */

  
    va_start(va,arg);  /* some machines won't pass ... without this */
    func(file,&arg);  /* this should never return */
    va_end(va);
    _exit(127);
  } else { /* parent */
    if (sigaction(SIGALRM,&savealrm, NULL)<0) return -1; 
    while(waitpid(pid, &status, 0) < 0)
      if (errno != EINTR) {
	status=-1; /* error other than EINTR from waitpid */
	break;
      }
    pid=0;
  }

  /* restore previous signal actions & reset signal mask */
  if (sigaction(SIGINT, &saveintr, NULL)<0) return -1;
  if (sigaction(SIGQUIT,&savequit, NULL)<0) return -1;
  if (sigprocmask(SIG_SETMASK, &savemask, NULL)<0) return -1;
  
  
  return status;
}
    
#undef pid
