/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* ---- miscutil.c ---- */
char *bbs_itoa(int i);
int fexist(char *fname);
int putch(int c);
void t_puts(char *tstr);
void clrscr(void  );
void writelog(char *st);
void who(void  );
void sigquit(int i);
void sigstop(int i);
void sigcont(int i);
void killconnection(int message);
char readc(void  );
void writec(char c);
char waitfor(char *okaych);
char opton(int option);
void writes(char *s);
void sputs(char *st);
void sputs_wr(char *st);
void sputs_mime(char *st);
int readl(char *ptr, register int maxlen, register int echo, char *fill);
int readlww(char *ptr, register int maxlen, int wrap_bs);
void sgets(char *st, int max);
void sgetpw(char *st);
void dump(char *filename);
void dumpsvr(char *filename);
void more(char *filename, int scrlen);
unsigned long int power(int base, int n);
int ynprompt(char *st, int def);
void strmid(char *dup, char *src, int beg, int n);
void substoint(unsigned long int *subsi, char *subs);
void inttosubs(char *subs, unsigned long int *subsi);
int accesscheck(int basenum);
int subcheck(int basenum);
void readbases(void  );
void drawuser(void  );
void changepw(void  );
void changesubs(void  );
int finduser(char *name);
void listusers(void  );
void updatelast(int usr, char *buf);
void changeplan(char *name);
void readplan(char *defname);
void waitkey(void  );
void saveopts(void  );
int stringptrcomp(void *p1, void *p2);
int parseandrun(functable_t *functable, llist aliases, char *string,  
                char *errorstring);
void addtoenv(char *name, char *value);
int getfromenv(char *name, char *value);
/* ---- msgbase.c ---- */
void addmsg(mrec msg);
int readmsg(int mnum);
int getmsgnum(void  );
void setlastmsg(int b, int m);
int getlastmsg(int b);
void changebase(int b);
void readnext(void  );
void readprev(void  );
void entermsg(char *outfile);
void selectbase(void  );
void jump2msg(void  );
mrec getmsg(int mnum);
mrec getmsghdr(int mnum);
void deletemsg(int mnum, int sysoponly);
void findmsg(void  );
void listmsgs(void  );
int domessages(void  );
void countnew(void);
/* ---- yalk.c ---- */
void dopage(char *tstr);
void doaction(char *tmsg);
void dowrite(char *tmsg);
void domsg(char *tmsg);
void dotalk(void  );
int t_help(char *st, int argc, char **argv);
int t_manageenv(char *st, int argc, char **argv);
int t_who(char *st, int argc, char **argv);
int t_channels(char *st, int argc, char **argv);
int t_join(char *st, int argc, char **argv);
int t_leave(char *st, int argc, char **argv);
int t_show(char *st, int argc, char **argv);
int t_hide(char *st, int argc, char **argv);
int t_quit(char *st, int argc, char **argv);
int t_page(char *st, int argc, char **argv);
int t_msg(char *st, int argc, char **argv);
int t_managelist(char *st, int argc, char **argv);
int t_info(char *st, int argc, char **argv);
int t_clear(char *st, int argc, char **argv);
int t_yeck(char *st, int argc, char **argv);
int t_elite(char *st, int argc, char **argv);
int envptrcomp(void *p1, void *p2);
/* ---- gfiles.c ---- */
void getgfileindex(char *path);
void getgfile(char *path);
int dogfil(char *p);
/* ---- strlwr.c ---- */
char *strlwr(char *st);
/* ---- tochars.c ---- */
char lower(char i);
char upper(char i);
/* ---- bbs.c ---- */
int rc_server(char *st, int argc, char **argv);
void readrc(char *filename);
int doconfig(void  );
int newuser(void  );
int login(void  );
void su(void  );
void dobbs(void  );
void yabbsmain(int argc, char **argv);
void yahoomain(int argc, char **argv);
/* ---- network.c ---- */
void csendp(char *msg);
char *creadp(void);
int c_yabbshi(char **argv);
int c_bad(char **argv);
int c_talk(char **argv);
int c_page(char **argv);
int c_who(char **argv);
int c_msg(char **argv);
int c_msghdr(char **argv);
int c_msgnum(char **argv);
int c_delmsgret(char **argv);
int c_basetitle(char **argv);
int c_useropts(char **argv);
int c_login(char **argv);
int c_lastmsg(char **argv);
int c_newuser(char **argv);
int c_founduser(char **argv);
int c_userexist(char **argv);
int c_txtfile(char **argv);
int c_planfile(char **argv);
int c_gfileindex(char **argv);
int c_gfile(char **argv);
int handlemsg(void);
void connectserver(char *server);
/* these functions go in the OS specific driver */
void clearscreen(void);     /* clear the screen                         */
void clearline(void);       /* clear to the end of the current line     */
void hion(void);            /* turn on highlighting                     */
void hioff(void);           /* turn off highlighting                    */
void up(void);              /* move the cursor up one row               */
char readc(void);           /* read a character from the keyboard       */
char readc_pause(void);     /* read a character from the keyboard       */ 
void writec(char c);        /* write a character to the screen          */
void terminit(void);        /* initialize the terminal                  */
void getterm(void);         /* ask about terminal type                  */
void termclose(void);       /* close the terminal                       */
void echooff(void);         /* turn off keyboard echo                   */
void echoon(void);          /* turn keyboard echo back on               */
