/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * msdos.c - part of the yabbs bulletin board package by alex wetmore
 *           see bbs.c for information on the system and copying.
 */

#include <socket.h>
#include <gppconio.h>
#include "bbsdefs.h"

#ifndef STDIN
#define STDIN 0
#endif

int attr;

/*
 * Clear the screen
 */
void clearscreen(void) {
    clrscr();
    gotoxy(1, 1);
}

/*
 * clear to the end of the current line
 */
void clearline(void) {
    clreol();
}

/*
 * turn on highlighting
 */
void hion(void) { 
    highvideo();
}

/*
 * turn off highlighting
 */
void hioff(void) { 
    normvideo();
}

/*
 * move the cursor up one row
 */
void up(void) {     
    if (wherey() != 1) gotoxy(wherex(), wherey() - 1);
}

/*
 * read one character from the user but don't process server messages
 */
char readc_pause(void) {
    unsigned char ch;
    int readkey = FALSE;

    while (!readkey) {
        line = 1;
        ch = getch();
        if ((ch == 4)) {
            if (ynprompt("\n\nDo you want to logout? [yN] ", FALSE)) {
                killconnection(K_USER);
            } else {
                readkey = FALSE;
            }
        } else if (((ch >= 32) && (ch <= 127)) || (ch == 21) ||
                   (ch == 10) || (ch == 13) || (ch == '\t') || (ch == 8)) {
            return ch;
        } else {
            readkey = FALSE;
        }
    }
    /* should never be reached */
    assert(FALSE);
    return 0;
}

/*
 * read one character from the user
 */
char readc(void) {
    unsigned char ch;
    int readkey = FALSE, readstdin = FALSE, readbbs_s;
    fd_set fds;

    while (!readkey) {
        readbbs_s = FALSE;

        FD_ZERO(&fds);
        FD_SET(STDIN, &fds);
        FD_SET(bbs_s, &fds);

        while (select(bbs_s+1, &fds, NULL, NULL, NULL) == -1);
        if (FD_ISSET(bbs_s, &fds)) readbbs_s = TRUE;
        if (FD_ISSET(STDIN, &fds)) readstdin = TRUE;
    
        if (readbbs_s) {
            bbs_handlemsg();                /* read and deal with packet    */
        }
        if (readstdin) {
            line = 1;
            ch = getch();
            if ((ch == 4)) {
                if (ynprompt("\n\nDo you want to logout? [yN] ", FALSE)) {
                    killconnection(K_USER);
                } else {
                    readkey = FALSE;
                }
            } else if (((ch >= 32) && (ch <= 127)) || (ch == 21) ||
                       (ch == 10) || (ch == 13) || (ch == '\t') || (ch == 8)) {
                return ch;
            } else {
                readkey = FALSE;
            }
        }
    }
    /* should never be reached */
    assert(FALSE);
    return 0;
}

/*
 * write one character to the user
 */
void writec(char c) {
    if (((c >= 32) && (c < 127)) || 
        (c == 10) || 
        (c == 13) ||
        (c == 8) ||
        (c == 7)) {
        if (c == 13) {
            gotoxy(1, wherey());
        } else if (c == 10) {
            if (wherey() == 25) {
                movetext(1, 2, 80, 25, 1, 1);
                gotoxy(1, wherey());
                clreol();
            } else {
                gotoxy(1, wherey() + 1);
            }
        } else cprintf("%c", c);
    }
}

/*
 * initialize the terminal.  this would open a window on a windowing system,
 * etc.  called before anything is printed to the screen.
 */
void terminit(void) {
    gppconio_init();
}

/*
 * get the terminal type and other information.  
 */
void getterm(void) {
}

/*
 * gets called when the terminal is no longer needed.
 */
void termclose(void) {
}

/*
 * disable echo on the tty device
 */
void echooff(void) {
}

/*
 * enable echo on the tty device
 */
void echoon(void) {
}

char *yabbssystype(void) {
    static char *systype = "msdos (386, WATCP)";
    return systype;
}

char *cli_hiddenyabbsrcname(void) {
    static char *yabbsrc = "yabbs.rc";
    return yabbsrc;
}

char *cli_yabbsrcname(void) {
    static char *yabbsrc = "yabbs.rc";
    return yabbsrc;
}
