/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include "llist.h"

llist addtolist(llist l, void *ptr) {
    llist p;

    if (l != NULL) {
        l->next = addtolist(l->next, ptr);
        return l;
    } else {
        p = (llist) malloc(sizeof(struct llist_st));
        if (p == NULL) {
            perror("llist: addtolist");
            exit(1);
        }
        p->next = NULL;
        p->ptr = ptr;
        return p;
    }
}

llist deletefromlist(llist l, void *ptr, int (*compf)(void *p1, void *p2)) {
    llist p;

    if (l == NULL) return l;

    if (compf(l->ptr, ptr)) {
        p = l->next;
        free(l->ptr);
        free(l);    
        return p;
    } else {
        l->next = deletefromlist(l->next, ptr, compf);
        return l;
    }
}

int inlist(llist l, void *ptr, int (*compf)(void *p1, void *p2)) {
    llist p;

    p = l;
    while (p != NULL) {
        if (compf(p->ptr, ptr)) return 1;
        p = p->next;
    }
    return 0;
}
