/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * bbsdefs.h - part of the yabbs bulletin board package by alex wetmore
 *             see bbs.c for information on the system and copying.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <strings.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/time.h>
#ifdef AIX
#include <sys/select.h>
#endif
#include <errno.h>
#include <assert.h>
#include "termcap.h"
#include "yabbs.h"
#include "bbs_st.h"
#include "menus.h"
#include "yabbslib/yabbslib.h"
#include "plevel.h"
#include "llist.h"

#define ASSERT assert

#define YABBS
#ifndef TRUE
#define TRUE 1                              /* you might have these     */
#define FALSE 0
#endif
#define curtime time((time_t *) 0)

#ifndef EXTERN
#define EXTERN extern
#endif 

EXTERN  urec    userinfo;                   /* current user information */
EXTERN  int     bbs_s;                      /* socket for server        */
EXTERN  int     msgnum,                     /* number of messages       */
                usernum,                    /* number of users          */
                pid;                        /* our process id           */
EXTERN  brec    base[MBASES];               /* message base information */
EXTERN  int     b, m;                       /* current message base,
                                               current message          */
EXTERN  int     redraw,                     /* if true then redraw the
                                               input line               */
                line;                       /* current line on screen   */
EXTERN  char    replytitle[33];             /* title of last msg read   */
EXTERN  char    replyto[9];                 /* from field from last msg */
EXTERN  char    rlstart[80];                /* start of a new readline  */
EXTERN  char    rlwrap;                     /* TRUE if readline wrapped */
EXTERN  char    lstype, lstext[33];         /* last search type, last
                                               text searched for        */
EXTERN  int     sputs_process;              /* sputs hilights with []   */
EXTERN  mrec    gmsg;                       /* global message structure */
EXTERN  grec    gfil[1000];                 /* global gfile structure   */
EXTERN  int     gnum;                       /* size of gfil             */
EXTERN  int     errorcode;                  /* global error code (like  */
                                            /*  error)                  */
EXTERN  int     yeck, elite;                /* cool modes for yalk      */
EXTERN  int     hnum;                       /* header num, for msghdrs  */
EXTERN  char    curchan[15];                /* current channel          */
EXTERN  llist   channels;                   /* channels we are on       */
EXTERN  llist   ignores;                    /* people we want to ignore */
EXTERN  llist   nocaps;                     /* people we want to nocaps */
EXTERN  llist   notify;                     /* login/out tracking list  */
EXTERN  int     intalk;                     /* yes, we are in talkmode  */
EXTERN  int     numchan;                    /* number of chans we're in */
/* list ptr points to type env_t                                        */
EXTERN  llist   aliases;                    /* talk aliases             */
/* list ptr points to type env_t                                        */
EXTERN  llist   env;                        /* environment              */
EXTERN  llist   locked;                     /* list of locked env vars  */
EXTERN  int     inrc;                       /* TRU when reading yabbsrc */

#define isignored(name) inlist(ignores, name, stringptrcomp)
#define isnocaps(name) inlist(nocaps, name, stringptrcomp)

#include "bbsfuncs.h"                       /* function prototypes      */
