/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define YABBSNAME "Yabbs/net"                   /* name of package          */

#ifndef __DATE__                                /* make up a date if there  */
#define __DATE__ "braindead system!"            /*  isn't one               */
#endif
/* misc. constants (don't play around unless you know what you are doing!)  */
#define HDRLEN 84                               /* length of message hdr    */
#define MBASES 27                               /* number of message bases  */
#define BASEOF '@'                              /* offset to base abvrevs   */
#define MAXMSGLINES 99                          /* maximum message lines    */
#define MAXMSGBYTES 8096                        /* maximum message bytes    */
#define UMASK 432                               /* default umask for yabbs  */

/* user options (should each use a different bit of a 32-bit integer)       */
#define O_XPERT 1                               /* expert option number     */
#define O_SYSOP 1073741824                      /* (2^31) is a sysop        */

/* fseek and lseek definations (for the machines that don't have them)      */
#ifndef SEEK_SET
#define SEEK_SET 0                              /* mach is braindead        */
#define SEEK_CUR 1                              /* it should have these in  */
#define SEEK_END 2                              /* stdio.h                  */
#endif

/* user structure                                                           */
struct userrec {
    char            name[9], pass[9];           /* user name and password   */
    unsigned long   sub;                        /* sub status               */
    unsigned long   access;                     /* access status            */
    unsigned        lastmsg[32];                /* last message info        */
    unsigned        scrlen;                     /* length of screen         */
    unsigned long   options;                    /* options.                 */
};

/* message structure                                                        */
struct msgrec {
    char            to[9], from[9];             /* from, to fields          */
    char            title[32];                  /* title of message         */
    char            reserved;                   /* extra byte               */
    char            time[32];                   /* date and time info       */
    char            deleted;                    /* deletion flag (y = true) */
    char            msg[MAXMSGBYTES];           /* actual message (16k max) */
};

/* index to a message data file                                             */
struct idxrec {
    unsigned long   offset;                     /* offset in message data   */
    unsigned long   length;                     /* length of message        */
};

/* message base index structure                                             */
struct baserec {
    char        title[33];                      /* title of base            */
    char        dfile[255];                     /* data file name           */
    int         max;                            /* max number of messages   */
};

/* gfile menu structure                                                     */
struct gfilrec {
    char        type;                           /* type of file             */
    char        name[255];                      /* name of gfile            */
    char        path[255];                      /* path to send to server   */
};

/* easy ways to refer to all of the above                                   */
typedef struct userrec urec;
typedef struct msgrec  mrec;
typedef struct idxrec  irec;
typedef struct baserec brec;
typedef struct gfilrec grec;
