/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define MAXUSERS 2048                           /* max number of users in   */
                                                /* user file                */

/* various sysop configurable paths                                         */
#define F_PATH "/usr/yabbs/data"                /* the path to yabbs data   */
#define F_ZCAT "/usr/bin/zcat"                  /* zcat program             */

/* #define this to a string if you don't want new users to be created.  the */
/* client will print the string when new user creatation is attempted.      */
#undef NONEWUSER

/* defaults for new users                                                   */
/* default subs is a bit pattern for each of the subs with @ being the LSB  */
/* and Z being bit 26.  If you wanted to make the default bases @,A,B,&C    */
/* you would do this:                                                       */
/* 1111 0000 0000 0000 0000 0000 000X XXXX binary => 15 decimal (X=0)       */
/* the user editor will spit these numbers out for you when you change      */
/* users message bases (so just go setup a user how you want your defaults  */
/* to be and copy the number).                                              */
/* ---- -ZYX WVUT SRQP ONML KJIH GFED CBA@                                  */
/* 0000 0011 1111 1111 1111 1111 1111 1111                                  */
/* default options are the bit patterns to specify for the options          */
#define D_SUBS 0x8ffffff                       /* default subs             */
#define D_SCRLEN 24                             /* default screen length    */
/* options are listed in include/bbs_struct.h                               */
#define D_OPT 0                                 /* default options          */

#define SAVEUSROPS 255                  /* update user file after n server  */
                                        /* calls.                           */
#define INACTIVITYTIMEOUT 1800          /* maximum inactivity time for a    */
                                        /* client                           */
#define MAXTALKCOMMANDS 15              /* maximum talk commands per maxtme */
                                        /* before flood protection kicks in */
#define MAXTALKTIME 5                   /* time to detect talk commands in  */
#define GOPHERSVR "gopher.phred.org"    /* name of gopher server for gfiles */
#define GOPHERPRT 70                    /* name of gopher port for gfiles   */
