/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* misc. constants (don't play around unless you know what you are doing!)  */
#define HDRLEN 84                               /* length of message hdr    */
#define YABBSPORT 4225                          /* standard port for server */

/* user options (should each use a different bit of a 32-bit integer)       */
#define O_XPERT 1                               /* expert option number     */
#define O_SYSOP 1073741824                      /* (2^31) is a sysop        */

/* files to get from the server                                             */
#define F_WELCOME "welcome.txt"                 /* welcome file             */
#define F_LASTU "lastuser.txt"                  /* last user file           */
#define F_NEWS "news.txt"                       /* news file                */
#define F_NEWUSER "newuser.txt"                 /* dumped to new users      */

/* message return codes                                                     */
#define M_OK 0                                  /* message is okay          */
#define M_OOB -1                                /* message out of bounds    */
#define M_PRIVATE -2                            /* message is private       */
#define M_DELETED -3                            /* message is deleted       */
#define M_ERR -4                                /* other error              */

/* types of message lines                                                   */
#define ML_TO 0                                 /* who the message is to    */
#define ML_FROM 1                               /* who the message is from  */
#define ML_TITLE 2                              /* message title            */
#define ML_TIME 3                               /* message date             */
#define ML_DELETED 4                            /* 'Y' if deleted           */
#define ML_LINE 5                               /* line of message          */ 

/* types of message lines                                                   */
#define TL_PUBLIC 0                             /* public message in talk   */
#define TL_PRIVATE 1                            /* private message in talk  */
#define TL_ACTION 2                             /* action in talk           */
#define TL_HIDE 3                               /* hide talk channel        */
#define TL_SHOW 4                               /* unhide talk channel      */
#define TL_JOIN 5                               /* join a talk channel      */ 
#define TL_LEAVE 6                              /* leave a talk channel     */

/* types of shutdown commands                                               */
#define SD_ENABLE "0"                           /* warn and enable logins   */
#define SD_DISABLE "1"                          /* warn and disable logins  */
#define SD_NOW "2"                              /* shutdown now             */

/* paths for temp files                                                     */
#define F_ZTMP "/tmp/yabbs-z."                  /* temporary files for zcat */
#define F_GTMP "/tmp/yabbs-g."                  /* temporary files for zcat */
#define F_EDTMP "/tmp/yabbs-e."                 /* path to editor temp file */
#define F_MTMP "/tmp/yabbs-m."                  /* path to editor temp file */

/* strings                                                                  */
#define S_NULLBASE "null base"                  /* name for un-used bases   */

/* debugging types                                                          */
#define DBG_SEND 1                              /* see packets sent         */
#define DBG_RECV 2                              /* see packets recieved     */

/* macros                                                                   */
#define nullbase(baseid) (strcmp(base[baseid].title, S_NULLBASE) == 0)

/* max string lengths                                                       */
#define MAXUSERNAMELEN 8
#define MAXCHANNAMELEN 12

/* user structure                                                           */
typedef struct userrec_st {
    char            name[9], pass[9];           /* user name and password   */
    unsigned long   sub;                        /* sub status               */
    unsigned long   access;                     /* access status            */
    unsigned        lastmsg[32];                /* last message info        */
    unsigned        scrlen;                     /* length of screen         */
    unsigned long   options;                    /* options.                 */
} userrec;

/* message structure                                                        */
typedef struct msgrec_st {
    char            to[9], from[9];             /* from, to fields          */
    char            title[32];                  /* title of message         */
    char            time[32];                   /* date and time info       */
    char            deleted;                    /* deletion flag (y = true) */
} msgrec;

/* message base index structure                                             */
typedef struct baserec_st {
    char            *title;                     /* title of base            */
    int             private;                    /* if true then private     */
} baserec;

/* ---- functions that the client software is expected to provide           */
void    cli_fatalerror(char *msg);
void    cli_error(char *msg);
void    cli_talkline(char *channel, char *name, char *string, int type);
void    cli_page(char *name);
void    cli_msgline(char *line, int type, void *data);
void    cli_msghdrline(int num, char *to, char *from, char *del, char *subject,
    void *data);
void    cli_textline(char *line, void *data);
void    cli_planline(char *line, void *data);
void    cli_gfileline(char *line, void *data);
void    cli_wholine(char *name, char *onfrom, char *onsince, int idletime, 
    void *data);
void    cli_channelline(char *channel, char *users, void *data);
void    cli_gfileindexline(char *name, char *path, char *type, void *data);
void    cli_msgbasename(int baseid, char *basename, void *data);
void    cli_useroptions(char *name, int scrlen, unsigned long options, 
    char *subscriptions, void *data);
void    cli_founduser(char *name, void *data);
void    cli_announce(int type, char *arg0, char *arg1);
char    *cli_yabbsrcname(void);
char    *cli_hiddenyabbsrcname(void);
/* type             arg1                        arg2                        */
/* AN_LOGIN         user name                   host from                   */
/* AN_LOGOUT        user name                   host from                   */
/* AN_NEWMSG        message base                user name to                */
/* AN_CHANJOIN      channel name                who joined                  */
/* AN_CHANLEAVE     channel name                who left                    */
/* AN_CHANCREATE    channel name                creator user name           */
/* AN_CHANDESTROY   channel name                destroyer user name         */
/* AN_CHANNEWNAME   new channel name            old channel name            */

/* announcement options, in a bitfield.  by default they are all off        */
#define AN_LOGIN        0x0001
#define AN_LOGOUT       0x0002
#define AN_NEWMSG       0x0004
#define AN_CHANJOIN     0x0008
#define AN_CHANLEAVE    0x0010
#define AN_CHANCREATE   0x0020
#define AN_CHANDESTROY  0x0040
#define AN_CHANNEWNAME  0x0080

/* functions in the yabbs library                                           */
void    bbs_connect(char *server);
void    bbs_logout(void);
int     bbs_login(char *name, char *pass);
int     bbs_getmsg(int baseid, int msgnum, void *data);
int     bbs_getmsghdr(int baseid, int msgnum, void *data);
int     bbs_getmsghdrs(int baseid, int msgnum1, int msgnum2, void *data);
int     bbs_getgfileindex(char *path, void *data);
int     bbs_getgfile(char *path, void *data);
void    bbs_putplanfile(char *msg);
void    bbs_getplanfile(char *name, void *data);
void    bbs_gettextfile(char *filename, void *data);
void    bbs_who(void *data);
void    bbs_channels(void *data);
void    bbs_talkjoin(char *channel);
void    bbs_talkjoinpriv(char *channel);
void    bbs_talkleave(char *channel);
void    bbs_talkpublic(char *channel, char *text);
void    bbs_talkprivate(char *to, char *text);
void    bbs_talkaction(char *channel, char *text);
void    bbs_talkshow(char *channel);
void    bbs_talkhide(char *channel);
void    bbs_talkquit();
void    bbs_page(char *name);
int     bbs_getmsgnum(int baseid);
void    bbs_addmsg(int baseid, char *to, char *subject, char *msg);
int     bbs_deletemsg(int baseid, int msgnum);
void    bbs_getbasenames(void *data);
void    bbs_getoptions(void *data);
void    bbs_setoptions(int scrlen, unsigned long options, char *subs, 
    void *data);
int     bbs_getlastmsg(int baseid);
int     bbs_setlastmsg(int baseid, int msgnum);
void    bbs_setpassword(char *pass);
void    bbs_finduser(char *partialname, void *data);
int     bbs_newuser(char *name, char *pass);
int     bbs_userexist(char *name);
int     bbs_handlemsg(void);
void    bbs_shutdown(char *mode, char *message);
void    bbs_onfrom(char *onfrom);
void    bbs_announce(int type);
void    bbs_unannounce(int type);

/* functions in the interface specific portion of the library */
void    bbs_connect_port(char *server, int port);
void    bbsi_csendp(int n, char *key, char *command, ...);
char    *bbsi_creadp();
void    bbs_done(void);
