/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * gfiles.c   - part of the yabbs bulletin board package by alex wetmore
 *              see bbs.c for information on the system and copying.
 */

#include "bbsdefs.h"

FILE *gfile;
int gfileline;

void cli_gfileindexline(char *name, char *path, char *type, void *null) {
    char buf[255];

    gfil[gnum].type = type[0];
    strcpy(gfil[gnum].name, name);
    strcpy(gfil[gnum].path, path);
    gnum++;
    if ((gnum % 10) == 0) {
        sprintf(buf, "\rFetching directory . . . %i items", gnum);
        sputs(buf);
    }
}

void getgfileindex(char *path) {
    sputs("\nFetching directory . . .");
    gnum = 0;
    bbs_getgfileindex(path, NULL);
}

void cli_gfileline(char *line, void *null) {
    char buf[255];

    fprintf(gfile, "%s\n", line);
    if ((++gfileline % 10) == 0) {
        sprintf(buf, "\rFetching file . . . %i lines", gfileline);
        sputs(buf);
    }
}

void getgfile(char *path) {
    char buf[255];

    strcpy(buf, F_GTMP);
    strcat(buf, bbs_itoa(getpid()));
    gfile = fopen(buf, "w");
    if (gfile == NULL) {
        sputs("\ngetgfile: error opening temp file\n");
        return;
    }
    gfileline = 0;
    if (bbs_getgfile(path, NULL)) {
        fclose(gfile);
        more(buf, userinfo.scrlen);
        unlink(buf);
    } else {
        sputs("\nError accessing gfile, please tell the sysop\n");
        sputs("<slam that key>");
        readc();
    }
    fclose(gfile);
}

int dogfil(char *p) {
    int     bot, top, i, done, sel, rows;
    char    cmd[6], buf[255], path[255], cmd0;

    done = FALSE; 
    strcpy(path, p);
    getgfileindex(path);
    if (userinfo.scrlen == 0) rows = 19; else rows = userinfo.scrlen - 5;
    top = 0;
    while (!done) {
        bbs_clrscr();
        bot = top + rows;
        if (bot > gnum) bot = gnum;
        if (gnum == 0) {
            printf("\nSorry, this directory is empty.  Hit (b) to go back.\n");
        }
        for (i = top; i < bot; i++) {
            sprintf(buf, "<Bold>%4i</Bold> %s%s<nl>", i + 1, gfil[i].name,
                (gfil[i].type == '0') ? "" : "/");
            sputs_mime(buf);
        }
        sputs_mime(MNU_GFILES);
        cmd0 = readc();
        if (isdigit(cmd0)) {
            cmd[0] = cmd0;
            cmd[1] = 0;
            strcpy(buf, cmd);
            sputs(buf);
            readl(cmd, 5, TRUE, buf);
        } else {
            cmd[0] = cmd0;
            cmd[1] = 0;
        }
        if (cmd[0] == 'b') {
            sputs("back\n");
            done = TRUE;
        } else if (cmd[0] == 'u') {
            top -= rows;
            if (top < 0) top = 0;
        } else if (cmd[0] == 'd') {
            top += rows;
            if (top > gnum) top = gnum;
        } else if (cmd[0] == 'q') {
            sputs("quit\n");
            return 1;
        } else if (isdigit(cmd[0])) { 
            sel = atoi(cmd) - 1;
            switch (gfil[sel].type) {
                case '1' :              /* subdir */
                    if (dogfil(gfil[sel].path)) return 1;
                    getgfileindex(path);
                    break;
                case '0' :              /* text file */
                    getgfile(gfil[sel].path);
/*                  getgfileindex(path); */
                    break;
            }
        } 
    }
    return 0;
}
