/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * usered.c - part of the yabbs bulletin board package by alex wetmore
 *            see bbs.c for information on the system and copying.
 */

#include <stdio.h>
#include "bbs_struct.h"
#include "bbs_files.h"
#include "util_common.h"

#define M_USERED "+)next user    -)prev user    d)elete user   c)reate user   q)uit
j)ump          f)ind          y)toggle sysop x)toggle xpert v)save
n)ame          p)assword      l)scrlen       s)ubs          a)ccess\n"


unsigned long int ue_dotoggle(unsigned access) {
    int     i;
    char    subs[64], base, st[80];

    sprintf(st, "current access: %li\n", access); sputs(st);
    sprintf(st, "A=%c  a=%c\n", upper('a'), lower('A')); sputs(st);
    sputs("which subs? ");
    sgets(subs, 26);
    for (i = 0; i < strlen(subs); i++) {
        base = upper(subs[i]) - BASEOF;
        if ((base >= 0) && (base < MBASES))
            access = (access ^ power(2, base));
        sprintf(st, "toggling %c, %i\n", upper(subs[i]), base); sputs(st);
    }
    sprintf(st, "new access: %li\n", access); sputs(st);
    return access;
}

int ue_finduser(int u) {
    int     i;
    char    name[9];

    sputs("name? "); sgets(name, 8);
    for (i = u + 1; i < usernum; i++)
        if (strstr(user[i].name, name) != NULL) return i;
    sputs("user not found");
    return 0;
}

void ue_deleteuser(u) {
    int     i;

    if (usernum > 1) {
        if (ynprompt("are you sure? ", FALSE)) {
            for (i = u; i < usernum; i++)
                user[i] = user[i + 1];
            usernum--;
        }
    } else sputs("you need one user!");
}

void ue_adduser(void) {
    int u, i;

    if (usernum == MAXUSERS) {
        sputs("user base is full\n");
        return;
    }

    u = usernum++;
    sputs("name: "); sgets(user[u].name, 8);
    sputs("pass: "); sgets(user[u].pass, 8);
    user[u].sub = D_SUBS;
    user[u].access = D_SUBS;
    user[u].scrlen = D_SCRLEN;
    user[u].options = D_OPT;
    for (i = 0; i < MBASES; i++) user[u].lastmsg[i] = 0;
}

void ue_editusers(void) {
    int     oldu, u, done;
    char    cmd[64], st[80];

    done = FALSE;
    u = 0;

    while (!done) {
        drawuser(u);
        sputs(M_USERED);
        sprintf(st, "[%d/%d]> ", u, usernum - 1); sputs(st);
        cmd[0] = readc(); 
        writec(cmd[0]); sputs("\n");
        switch (cmd[0]) {
            case '+' :  if (u < (usernum - 1)) u++; break;
            case '-' :  if (u > 0) u--; break;
            case 'n' :  sputs("new name? ");
                        sgets(user[u].name, 8);
                        break;
            case 'p' :  sputs("new pass? ");
                        sgets(user[u].pass, 8);
                        break;
            case 'x' :  user[u].options = user[u].options ^ O_XPERT;
                        break;
            case 'y' :  user[u].options = user[u].options ^ O_SYSOP;
                        break;
            case 'l' :  sputs("new scrlen? ");
                        sgets(cmd, 3);
                        user[u].scrlen = atoi(cmd);
                        break;
            case 'j' :  sputs("which user? ");
                        sgets(cmd, 8);
                        u = atoi(cmd);
                        if (u < 0) u = 0;
                        if (u > usernum - 1) u = usernum - 1;
                        break;
            case 'f' :  u = ue_finduser(u); break;
            case 'S' :  cmd[0] = ynprompt("are you sure? ", FALSE);
                        if (cmd[0]) user[u].sub = 0;
                        break;
            case 'A' :  cmd[0] = ynprompt("are you sure? ", FALSE);
                        if (cmd[0]) user[u].access = 0;
                        break;
            case 'v' :  writeusers(); break;
            case 's' :  user[u].sub = ue_dotoggle(user[u].sub); break;
            case 'a' :  user[u].access = ue_dotoggle(user[u].access); break;
            case 'c' :  ue_adduser(); u = usernum - 1; break;
            case 'd' :  ue_deleteuser(u);
                        if (u > usernum - 1) u = usernum - 1;
                        break;
            case 'q' :  cmd[0] = ynprompt("save? ", TRUE);
                        if (cmd[0]) writeusers();
                        done = TRUE;
                        break;
            default  :  sputs("what?\n");
        }
    }
    u = oldu;
}

void main(int argc, char **argv) {
    noecho();
    chdir(F_PATH);
    sputs("yabbs user editor - alex wetmore");
    sputs("\nreading user file: "); sputs(F_USERS); sputs("\n");
    readusers();
    ue_editusers();
    echo();
}
