/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994, 1995, 1996 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "bbs_struct.h"
#include "bbs_files.h"
#include "util_common.h"

FILE *openfile(char *filename, char *mode) {
    FILE *f;
#ifdef DEBUG
    char buf[255];
#endif

    dbg(printf("opening %s (pwd = %s) for %s\n", filename, getwd(buf), mode));
    f = fopen(filename, mode);
    if (f == NULL) {
        printf("error opening %s for %s\n", filename, mode);
        perror("clbase:openfile");
    }

    return f;
}

int openmbase(int baseid, FILE **fidx, char *idxmode, 
                          FILE **fdat, char *datmode) {
    char fnamedat[1024];
    char fnameidx[1024];

    strcpy(fnamedat, F_MSGDIR); 
    strcat(fnamedat, base[baseid].dfile); 
    strcat(fnamedat, F_MDATAEXT);
    strcpy(fnameidx, F_MSGDIR);
    strcat(fnameidx, base[baseid].dfile); 
    strcat(fnameidx, F_MIDXEXT);

    *fidx = openfile(fnameidx, idxmode);
    *fdat = openfile(fnamedat, datmode);
    if ((*fdat == NULL) || (*fidx == NULL)) return -1;
    else return 0;
}

void cleanbase(int bp) {
    FILE *fi, *fo;
    int n, r, w, x;
    char buf[255], mbname[255], mbname_b[255], mbname_t[255];
    mrec msg;
    size_t len;

    strcpy(mbname, base[bp].dfile);
    strcpy(mbname_b, mbname); strcat(mbname_b, ".b");
    strcpy(mbname_t, mbname); strcat(mbname_t, ".tmp");

    if ((fi = fileopen(mbname, O_RDONLY, 0)) == -1) flerror(mbname, "read");
    if ((fo = creat(mbname_t, 432)) == -1) flerror(mbname, "write");
   
    r = w = 0;
    while (read(fi, (char *) &len, sizeof(len)) != 0) {
        r++;
        read(fi, msg.to, 9);
        read(fi, msg.from, 9);
        read(fi, msg.title, 33);
        read(fi, msg.time, 32);
        read(fi, &msg.deleted, 1);
        read(fi, msg.msg, len);
        if (msg.deleted != 'Y') {
            msg.deleted = 'N';
            w++;
            write(fo, (char *) &len, sizeof(len));
            write(fo, msg.to, 9);
            write(fo, msg.from, 9);
            write(fo, msg.title, 33);
            write(fo, msg.time, 32);
            write(fo, &msg.deleted, 1);
            write(fo, msg.msg, len);
        } else {
            sprintf(buf, "#  cleanbase: deleted message %i from %s\n", r - 1, mbname);
            writelog(buf);
            sputs(buf);
            for (x = 0; x < usernum; x++) {
                if (user[x].lastmsg[bp] >= r - 1) user[x].lastmsg[bp]--;
            }
        }   
    }

    close(fi); close(fo);

    remove(mbname_b);
    rename(mbname, mbname_b);
    rename(mbname_t, mbname);
    if (w == 0) remove(mbname);

    sprintf(buf, "#  cleanbase: deleted %i of %i messages from %s\n", r - w, r, mbname);
    writelog(buf);
    sputs(buf);
}

void clbasemain(int argc, char **argv) {
    int bp;

    log = fopen(F_LOG, "a+");               /* open log for append      */
    if (log == NULL)    
        sputs("\n\007\007error opening log, please tell sysop!\n");

    readbases();
    readusers();
    for (bp = 0; bp < MBASES; bp++) {
        if (!nullbase(bp)) 
            cleanbase(bp);
    }
    writeusers(FALSE);

    fclose(log);
}
