#! /bin/ksh
#
# NAME
#     place -- Place an article in a mail group.
#
# SYNOPSIS
#    place newsgroup [...]
#
# DESCRIPTION
#    place takes an article on standard input and stores it
#    into newsgroup(s) under $HOME/mail.
#
# SEE ALSO
#    unidel(1)

if [ $# -lt 1 ]; then echo "usage: $0 newsgroup [...]"; exit 2; fi

mailDir=$HOME/mail
newsBin=/usr/local/lib/news/bin

cd $mailDir || exit 1

lock="LOCKxxx"		# modify name as appropriate
ltemp="L.$$"
echo $$ >$ltemp || exit 1
	
trap "rm -f $ltemp ; exit 0" 0 1 2 15
xx=0
while [ "$xx" -lt 4 ]
do
	if $newsBin/newslock $ltemp $lock
	then
		trap "rm -f $ltemp $lock ; exit 0" 0 1 2 15
		break
	fi
	sleep 2
	((xx=xx+1))
done

if [ "$xx" = "4" ]
then
	# Oops, can't lock
	trap -
	rm -f $ltemp
	exit 1
fi

# Make sure there's an active file
if [ ! -f active ]; then >active || exit 1; fi

# Create the first file
artNum=`egrep "^$1[ 	]" active | cut -d' ' -f 2`
if [ "$artNum" = "" ]; then artNum=0; fi
artNum=`expr $artNum + 1`
artDir=`echo $1 | tr . /`
if [ ! -d $artDir ]; then mkdir -p $artDir || exit 1; fi
cat - >$artDir/$artNum

# Update next article number
( egrep -v "^$1[ 	]" active ; echo "$1 $artNum 1 y" ) >nactive
mv nactive active

# Now one would link the remaining files, but I'll hold off on that for the
# moment
exit 0
