/*
 * NAME:
 *     getenvs -- get a list of environment variables
 *
 * SYNOPSIS
 *     #include <getenvs.h>
 *
 *     int getenvs (Envs *envs)
 *
 * DESCRIPTION
 *    getenvs will go through the array pointed to by envs checking
 *    for the existence of each environment variable, or using the
 *    firm-coded value.
 *
 * DIAGNOSTICS
 *     Returns -1 on failure (out of memory), 0 otherwise.
 *
 * AUTHOR
 *      Ken MacLeod
 *
 */

#ifndef lint
static char sccsId [] = "@(#) getenvs.c  1.3 02 May 1992 09:25:48\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <malloc.h>
#include <getenvs.h>
#include <string.h>

int putenv ();

int
getenvs (envs)
     Envs *envs;
{
  char *pp, *getenv();
  int nameLen;
  
  while (envs -> name != NULL) {
    pp = getenv (envs -> name);
    if (pp == NULL) {		/* No env variable */
      if (envs -> def != NULL) { /* Have default */
	nameLen = strlen(envs -> name);
	envs -> env = (char *)malloc (nameLen + strlen(envs -> def) + 2);
	if (envs -> env == NULL)
	  return (-1);
	(void) sprintf (envs -> env, "%s=%s", envs->name,
			envs -> def);
	envs -> valueStr = &envs -> env[nameLen + 1];
	if (putenv (envs -> env) != 0)
	  return (-1);
      } else {			/* do not have default */
	envs -> env = NULL;
	envs -> valueStr = NULL;
      }
    } else {			/* have env variable */
      envs -> env = NULL;
      envs -> valueStr = pp;
    }
    if (envs -> valueStr != NULL && envs -> scan != NULL) {
      /* we have a value and want to scan */
      if (envs -> scan[0] == 'P') /* Copy string pointer only */
	*((char **) envs -> value) = envs -> valueStr;
      else			/* Scan value */
        (void) sscanf (envs -> valueStr, envs -> scan, envs -> value);
    }
    envs ++;
  }
  return (0);
}

int
putenvs (envs, name, value)
     Envs *envs;
     char *name, *value;
{
  char *pp;
  int nameLen;
  
  while ((envs -> name != NULL) && (strcmp (name, envs -> name) != 0))
    envs ++;

  if (envs -> name == NULL) {	/* set up for temporary use of last entry */
    envs -> env = NULL;		/* alloc new space */
    envs -> scan = NULL;	/* don't scan */
  }
  
  nameLen = strlen (name);
  if (envs -> env != NULL)
    pp = (char *)realloc ((malloc_t)envs -> env, (size_t) nameLen + strlen(value) + 2);
  else
    pp = (char *)malloc (nameLen + strlen(value) + 2);
  if (pp == NULL)
    return (-1);
  (void) sprintf (pp, "%s=%s", name, value);
  envs -> env = pp;
  envs -> valueStr = &envs -> env[nameLen + 1];
  if (envs -> scan != NULL) {	/* we have another place to put it */
    if (envs -> scan[0] == 'P') /* Copy string pointer only */
      *((char **) envs -> value) = envs -> valueStr;
    else			/* Scan value */
      (void) sscanf (envs -> valueStr, envs -> scan, envs -> value);
  }
  if (putenv (pp) != 0)
    return (-1);

  return (0);
}
