/*
 * NAME:
 *     getdefs  --  retreive defaults from the default file.
 *
 * SYNOPSIS
 *     #include <getenvs.h>
 *
 *     int getdefs (char *progName, char *fileName, Envs *envs)
 *
 * DESCRIPTION
 *    getdefs will go through the file fileName, picking up default
 *    values for program progName that correspond with values in
 *    envs.  getdefs places the name and value pair into the
 *    environment.
 *
 *    Lines not beginning with progName are ignored.
 *
 * DIAGNOSTICS
 *     Returns -1 on fatal failure (out of memory), 0 otherwise.
 *
 * AUTHOR
 *     Ken MacLeod
 *
 */

#ifndef lint
static char sccsId [] = "@(#) getdefs.c  1.2 02 May 1992 09:25:23\n\t";
#endif


#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <getenvs.h>
#include <fgetmfs.h>

extern int putenvs ();

int
getdefs (progName, fileName, envs)
     char *progName, *fileName;
     Envs *envs;
{
  FILE *file;
  char *pp, *fileLine, *name, *value;

  file = fopen (fileName, "r");
  if (file == NULL)
    return (0);			/* Don't let a little misunderstanding
				   get us down. */

  while ((fileLine = cfgetms (file)) != NULL) {
    /* Get program name */
    pp = strtok (fileLine, " \t");
    if ((pp == NULL) || (strcmp (pp, progName) != 0))
      goto cleanUpAndContinue;	/* Not our program */

    /* Get environment name and value */
    name = strtok ((char *)NULL, "=");
    if (name == NULL)
      goto cleanUpAndContinue;	/* no valid name */
    value = strtok ((char *)NULL, "\n");
    if (value == NULL)
      goto cleanUpAndContinue;	/* no valid value (actually, cgetms failed) */

    if (putenvs (envs, name, value) == -1) {
      /* out of memory */
      free ((malloc_t)fileLine);
      (void)fclose (file);
      return (-1);
    }

cleanUpAndContinue:
    free ((malloc_t) fileLine);
  }
  /* if not end of file, then it's out of memory */
  if (!feof (file)) {
    (void)fclose (file);
    return (-1);
  }

  (void)fclose (file);

  return (0);
}
