/*
 * NAME
 *     Unidel.h -- Basic, global definitions used all over Unidel
 *
 * AUTHOR
 *     Ken MacLeod
 *
 * SCCS
 *     @(#) Unidel.h  1.2 02 May 1992 09:21:04 
 */

/*----------------------------------------------------------------------------
 * Define general things used everywhere.
 */

#define LOG_COMMANDS (0x00000100l)
#define _outOfMemory outOfMemoryMsg
extern char outOfMemoryMsg[];
 
#define _findPartial 0x00000001l
#define _findExact 0x00000000l

#define _normal 0x0000
#define _noEcho 0x0001
#define _upperCase 0x0002
#define _lowerCase 0x0004
#define _defaultAnswer 0x0008
#define _defaultYes 0x0010

#define _keyLeft 0x100
#define _keyRight 0x101
#define _keyUp 0x102
#define _keyDown 0x103
#define _keyAbort 0x104

#define _true 1
#define _false 0

/* Modes of various sorts */
extern int more;		/* 1 = PrintArticle stops at the end of
				   screens and pages, 2 = stops after title */
extern int local;		/* _true = local logon, _false = remote */
extern int floorMode;
extern int expertMode;
extern int guest;
extern int finished;
extern FILE *dumpFile;		/* file where output is going, usually
				   'stdout' */

extern char *months[12], *days[7];

typedef struct {
  char command[4];
  char *printString[4];
  long selector;
  int (*function) ();
} Menu;

extern Menu mainMenu[];
extern char *selectorStrings[];

/*----------------------------------------------------------------------------
 * Declare functions that are not declared in any standard header file but
 * are used often.
 */

char *getenv ();
char *KeepString (/* char *string */);
void exit ();
