/*
 * NAME
 *     Strings.c -- string manipulation and storage functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Strings.c  1.7 02 May 1992 10:05:31\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include <string.h>
#include <varargs.h>
#include "defs.h"
#include "Unidel.h"
#include "Log.h"

char *
KeepString (string, length)
char *string;
int length;
{
  _FuncName ("KeepString");
  static char *ptr = NULL;
  static int whatsLeft;
  char *ptr1;

  length ++;
  if (ptr == NULL || (whatsLeft - length) < 0) {
    if (length >= _stringBlockAllocation) {
      ptr1 = (char *)malloc ((size_t) length);
      if (ptr1 == NULL) {
	Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
	exit (1);
      }
      return strcpy (ptr1, string);
    }
    ptr = (char *)malloc ((size_t)_stringBlockAllocation);
    if (ptr == NULL) {
      Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
      exit (1);
    }
    whatsLeft = _stringBlockAllocation;
  }
  ptr1 = strcpy (ptr, string);
  ptr += length;
  whatsLeft -= length;
  return ptr1;
}

void
AllocString (destination, source)
char *source, **destination;
{
  _FuncName ("AllocString");
  if (*destination == NULL)
    *destination = (char *)malloc ((size_t) (strlen (source) + 1));
  else
    *destination = (char *)realloc ((malloc_t)*destination,
				    (size_t) (strlen (source) + 1));
  if (*destination == NULL) {
    Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
    exit (1);
  }
  (void) strcpy (*destination, source);
}

char *
ToLower (string)
register char *string;
{
  char *oldString;

  oldString = string;

  while (*string) {
    if (isupper (*string))
      *string = tolower (*string);
    string ++;
  }

  return (oldString);
}

int
IsIn (string1, string2)
char *string1, *string2;
{
  char copyOfString2[_bufSize], *ptr2;
  int lengthOfString1;

  if (*string1 == '\0')
    return (_true);

  lengthOfString1 = strlen (string1);
  (void) strcpy (copyOfString2, string2);
  ptr2 = ToLower (copyOfString2);
  while ((ptr2 = strchr (ptr2, *string1)) != NULL) {
    if (strncmp (ptr2, string1, lengthOfString1) == 0)
      return (_true);
    ptr2 ++;
  }
  return (_false);
}

void
StrCat (string1, string2)
char *string1;
register char *string2;
{
  static char *ptr = NULL;
  register char *ptr1;

  if (string1 != NULL)
    ptr = string1;

  ptr1 = ptr;	/* get it into a register */
  while (*ptr1++ = *string2++)
    ;
  ptr = --ptr1;
}

int
split (string, array, num, delim)
char *string, *delim, **array;
int num;
{
  register char *ss, *dd;
  register int nn;
  int n2;

  ss = string;
  nn = 0;
  while (*ss != '\0') {
    if (nn++ < num)
      *array++ = ss;
    /*
     * Scan for the next delimiter in string (ss)
     */
    for (; *ss != '\0'; ss ++) {
      /* Scan for "this" character (*ss) in delim (dd) */
      dd = delim;
      while ((*dd != '\0') && (*ss != *dd))
	dd ++;

      if (*ss == *dd) {
	*ss = '\0';
	ss ++;
	if (*ss == '\0')	/* Case where delim is last char */
	  nn++;
	break;
      }
    }
  }
  /*
   * Last substring delimited by '\0'
   */
  if (nn < num)
    *array++ = ss;

  /*
   * Put NULL in remaining array positions.
   */
  for (n2 = nn; n2 < num; n2 ++)
    *array++ = (char *) 0;

  return (nn);
}

int
/*splitl (string, delim, arg0, ..., argn, (char *) 0)*/
splitl (va_alist)
va_dcl
{
  register char *ss, *dd, *delim;
  register int nn, pastArgn;
  char **arg;
  va_list pvar;


  va_start (pvar);

  /*LINTED va_arg */
  ss = va_arg (pvar, char *);
  /*LINTED va_arg */
  delim = va_arg (pvar, char *);

  pastArgn = 0;
  nn = 0;
  while (*ss != '\0') {
    /*LINTED va_arg */
    if (!pastArgn && ((arg = va_arg (pvar, char **)) != (char **) 0))
      *arg = ss;
    pastArgn = arg == (char **)0;
    nn ++;
    
    /*
     * Scan for the next delimiter in string (ss)
     */
    for (; *ss != '\0'; ss ++) {
      /* Scan for "this" character (*ss) in delim (dd) */
      dd = delim;
      while ((*dd != '\0') && (*ss != *dd))
	dd ++;

      if (*ss == *dd) {
	*ss = '\0';
	ss ++;
	if (*ss == '\0')	/* Case where delim is last char */
	  nn++;
	break;
      }
    }
  }
  /*
   * Last substring delimited by '\0'
   */
  /*LINTED va_arg */
  if (!pastArgn && ((arg = va_arg (pvar, char **)) != (char **) 0))
    *arg = ss;
  pastArgn = arg == (char **)0;

  /*
   * Put NULL in remaining arg positions.
   */
  if (!pastArgn)
    /*LINTED va_arg */
    while ((arg = va_arg (pvar, char **)) != (char **) 0)
      *arg = (char *) 0;

  va_end (pvar);
  
  return (nn);
}
