/*
 * NAME
 *     ReadMesg.c -- Message reading commands and functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) ReadMesg.c  1.9 02 May 1992 10:03:26\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <fgetmfs.h>
#include <time.h>
#include <ctype.h>
#include "protos.h"
#include "Log.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "Message.h"

extern char *hdr[], *hdrFieldNames[];
static char *Who ();
static int BetterNewsgroup ();
static void PrintRealShortHeader ();
static void BackErase ();
static void PrintHeader ();
static void PrintLine ();
static int PrintFileLine ();

void StrCat ();

static int position;
#define _atHeader 0
#define _atTop 1
#define _inMiddle 2
#define _atBottom 3

extern int linesLeft;		/* number of lines left */
extern int numLines;		/* number of lines to a screen */

/* XXX These should be in a structure and each instance local to */
/* PrintArticle  */
/* XXX Put 'hdr' here with these */
static FILE *articleFile;
static char *articleFileName;
static int articleNum;		/* Relative article number,
				   < 0 if not an article, -1 if has header */
static long bytes;
static long length;
static long startOfBody;	/* File position after ReadHeader */
static int done;		/* _true to end reading */
static int reading;		/* _false to end reading this message */
static int whoa;		/* _true to do display "--More--" */
static int backFlag;		/* _true if we want to go back an article */
static int backErase;		/* Characters to erase from prompt */

static int MorePageDown (), MorePageUp (), MoreLineDown (), MoreLineUp ();
static int MoreArtNext (), MoreArtPrev ();
static int MoreDownload (), MoreFollowup (), MoreReply (), MoreDisplayHeader ();
static int MoreStop (), MoreCancel (), MoreHelp ();
#ifdef REMIND
static int MoreUpdate ();
#endif

static Menu moreMenu[] = {
  "?", "=", NULL, NULL, NULL, 0l, MoreHelp,
  " ", "=", NULL, NULL, NULL, 0l, MorePageDown,
  "\n", "=", NULL, NULL, NULL, 0l, MoreLineDown,
  "B", "=", NULL, NULL, NULL, 0l, MoreArtPrev,
  "C", "=", NULL, NULL, NULL, 0l, MoreCancel,
  "D", "=", NULL, NULL, NULL, 0l, MoreDownload,
  "F", "=", NULL, NULL, NULL, 0l, MoreFollowup,
  "H", "=", NULL, NULL, NULL, 0l, MoreDisplayHeader,
  "L", "=", NULL, NULL, NULL, 0l, MoreLineUp,
  "N", "=", NULL, NULL, NULL, 0l, MoreArtNext,
  "R", "=", NULL, NULL, NULL, 0l, MoreReply,
  "S", "=", NULL, NULL, NULL, 0l, MoreStop,
  "Q", "=", NULL, NULL, NULL, 0l, MoreStop,
  "U", "=", NULL, NULL, NULL, 0l, MorePageUp,

  /* End of list */
  "", NULL, NULL, NULL, NULL, 0l, NULL,
};

static Menu headerMenu[] = {
  " ", "=", NULL, NULL, NULL, 0l, MorePageDown,
  "\n", "=", NULL, NULL, NULL, 0l, MoreLineDown,
  "S", "=", NULL, NULL, NULL, 0l, MoreStop,
  "Q", "=", NULL, NULL, NULL, 0l, MoreStop,

  /* End of list */
  "", NULL, NULL, NULL, NULL, 0l, NULL,
};

int
PrintMessage (flags, fileName, article, back)
long flags;
char *fileName;		/* article file name */
int article;		/* article relative number,
			   < 0 if not an article, -1 if has header */
int back;		/* We've come back to this article, no skipping */
{
  void ClearHeader (), FreeHeader ();
  char moreBuf[_bufSize];

  if (flags & _readMoreDefault)
    more = moreDefault;
  else if (flags & _readMore)
    more = 1;
  else
    more = 0;
  articleNum = article;
  articleFileName = fileName;
  done = _false;
  if ((articleFile = fopen (fileName, "r")) == NULL) {
    (void) printf ("%7d (Article no longer on-line)\n", articleNum + 1);
    return (-1);
  }
  if (article >= -1) {
    ClearHeader (hdr, hdrFieldNames);
    /* XXX Status from ReadHeader */
    (void) ReadHeader (articleFile, hdr, hdrFieldNames);
    if (!back && !(flags & _readAll) && hdr[_hdrNewsgroups]
	&& BetterNewsgroup (hdr[_hdrNewsgroups])) {
      if (!(flags & _readHeaders))
	PrintRealShortHeader (hdr, article, flags);
      goto outtaHere;
    }
    if (flags & _readHeaders) {
      PrintRealShortHeader (hdr, article, flags);
      goto outtaHere;
    }
  }
  startOfBody = ftell (articleFile);
  (void)fseek (articleFile, 0l, 2);
  length = ftell (articleFile) - startOfBody;
  (void)fseek (articleFile, startOfBody, 0);
  if (length <=0)
    length = 1;
  bytes = 1;

  numLines = lines;

  position = _atHeader;
  reading = _true;
  whoa = _false;
  backFlag = _false;
  do {
    if (article >= -1 && position == _atHeader) {
      if (more >= 2)
	linesLeft = lines;
      PrintShortHeader (hdr, article);
      if (hdr[_hdrUploadFile] != NULL) {
	position = _atBottom;
	(void)fseek (articleFile, 0l, 2);
      } else {
	position = _atTop;
	if (more >= 2)
	  whoa = _true;
      }
    }
    if (whoa) {
      whoa = _false;
      (void) sprintf (moreBuf, "--More--(%d%%)", (int) (bytes*100/length));
      backErase = strlen (moreBuf);
      (void) printf ("%s", moreBuf);
      (void) DoMenu (flags, moreMenu);
    } else if (PrintFileLine (articleFile, length, flags, moreMenu) == EOF) {
      /* XXX stop at bottom?  External pager? */
      position = _atBottom;
      break;
    }
  } while (reading && !done);

 outtaHere:
  (void) fclose (articleFile);
  if (article >= -1)
    FreeHeader (hdr, hdrFieldNames);
  if (done)
    return (2);
  else
    return (backFlag);
}

/* ARGSUSED */
static int
MoreHelp (dummy)
long dummy;
{
  BackErase (backErase);
  (void) printf ("Help\n");
  Help ("more");
  whoa = _true;
  return (0);
}

/* ARGSUSED */
static int
MoreDownload (dummy)
long dummy;
{
  BackErase (backErase);
  (void) printf ("Download\n");
  if (hdr[_hdrUploadFile])
    ReadOneFile (hdr[_hdrUploadFile]);
  else
    ReadOneFile (articleFileName);
  whoa = _true;
  return (0);
}

/* ARGSUSED */
static int
MoreFollowup (dummy)
long dummy;
{
  int followupToPoster;

  BackErase (backErase);
  (void) printf ("Followup\n");
  if (articleNum < 0) {
    /* XXX How 'bout sysop? */
    (void) printf ("Not a message, can't followup.\n");
  } else {
    followupToPoster = hdr[_hdrFollowupTo]
      && (strcmp (hdr[_hdrFollowupTo], "poster") == 0);
    if (followupToPoster)
      (void) printf ("Followups have been directed to be emailed to the author.\n");
    if (EnterMessage (0l, articleFileName, followupToPoster))
      (void) printf ("Article not %s.\n",
		     followupToPoster ? "mailed" : "posted");
  }
  whoa = _true;
  return (0);
}

/* ARGSUSED */
static int
MoreReply (dummy)
long dummy;
{
  BackErase (backErase);
  (void) printf ("Reply to author\n");
  if (articleNum < -1) {
    (void) printf ("Not a message, can't reply.\n");
  } else if (EnterMessage (0l, articleFileName, _true))
    (void) printf ("Mail not sent.\n");
  whoa = _true;
  return (0);
}

/* ARGSUSED */
static int
MoreDisplayHeader (dummy)
long dummy;
{
  BackErase (backErase);
  if (articleNum < -1) {
    (void) printf ("Not a message, no header.\n");
    whoa = _true;
  } else {
    PrintHeader (articleFile);
    (void)fseek (articleFile, startOfBody, 0);
    position = _atTop;
  }
  return (0);
}

/* ARGSUSED */
static int
MoreStop (dummy)
long dummy;
{
  BackErase (backErase);
  done = _true;
  return (0);
}

/* ARGSUSED */
static int
MoreCancel (dummy)
long dummy;
{
  _FuncName ("MoreCancel");
  FILE *articlePipe;
  char commandString[_bufSize];
  char *copyOfFrom, *author, *fullname, *sitename;
  extern int errno;

  BackErase (backErase);
  if (articleNum < 0) {
    (void) printf ("Not a message, can't cancel.\n");
  } else {
    (void) printf ("Cancel\n");
    copyOfFrom = NULL;
    if (hdr[_hdrFrom]) {
      AllocString (&copyOfFrom, hdr[_hdrFrom]);
      BreakFrom (copyOfFrom, &author, &fullname, &sitename);
    }
    /* XXX aide privs */
    if (rooms[currentRoom].type == _mailType) {
      if (AnswerYesNo ("Delete this message (Y/[N])? ", _defaultAnswer)
	  && unlink (articleFileName) != 0) {
	Log (funcName, __LINE__, LOG_ERROR,
	     "Can't unlink mail file %s, errno %d.", articleFileName, errno);
	reading = _false;
      }
    } else if ((hdr[_hdrFrom] && author
	 && (strcmp (author, logname) == 0)
	 && sitename && (IsIn (_siteName, sitename)))) {
      if (AnswerYesNo ("Cancel this message (Y/[N])? ", _defaultAnswer)) {
	(void) sprintf (commandString,
			"%s -t \"cmsg cancel %s\" -n %s -f unidel",
			_newsDelivery, hdr[_hdrMessageID], rooms[currentRoom].name);
	articlePipe = popen (commandString, "w");
	if (articlePipe == NULL) {
	  Log (funcName, __LINE__, LOG_ERROR,
	       "Unable to open pipe to generate cancle article.");
	  return 0;
	}
	(void) fprintf (articlePipe,
			"Control: cancel %s\n", hdr[_hdrMessageID]);
	(void) fprintf (articlePipe, "\n");
	(void) fprintf (articlePipe,
		"Cancelled using an alpha version of Unidel.\n");
	(void) fprintf (articlePipe,
		"RFC violations to unidel@bitsko.slc.ut.us.\n");
	(void) pclose (articlePipe);
	reading = _false;
      }
    } else
      (void) printf ("You're not the author!\n");
    if (copyOfFrom)
      free ((malloc_t)copyOfFrom);
  }
  whoa = _true;
  return (0);
}

/* ARGSUSED */
static int
MorePageDown (dummy)
long dummy;
{
  BackErase (backErase);
  position = _inMiddle;
  return (0);
}

/* ARGSUSED */
static int
MorePageUp (dummy)
long dummy;
{
  BackErase (backErase);
  /* XXX go figure */
  return (0);
}

/* ARGSUSED */
static int
MoreLineDown (dummy)
long dummy;
{
  BackErase (backErase);
  position = _inMiddle;
  linesLeft = 1;
  return (0);
}

/* ARGSUSED */
static int
MoreLineUp (dummy)
long dummy;
{
  BackErase (backErase);
  /* XXX Go figure */
  return (0);
}

/* ARGSUSED */
static int
MoreArtNext (dummy)
long dummy;
{
  BackErase (backErase);
  reading = _false;
  return (0);
}

/* ARGSUSED */
static int
MoreArtPrev (dummy)
long dummy;
{
  BackErase (backErase);
  if (position == _atTop) {
    reading = _false;
    backFlag = _true;
  } else {
    (void) fseek (articleFile, startOfBody, 0);
    position = _atHeader;
    bytes = 1;
  }
  return (0);
}

#ifdef REMIND
static int
MoreUpdate (dummy)
long dummy;
{
  BackErase (backErase);
  (void) printf ("Update\n");
  if (articleNum < 0) {
    (void) printf ("Not a message, can't update.\n");
  } else {
    /* XXX Well?  Where's the remind? */
    /* To anyone who reads this, this is/was supposed to be part of a */
    /* calendar/reminder/todo/tracking function */
  }
  whoa = _true;
  return (0);
}
#endif

static int
PrintFileLine (file, fileLength, flags, menu)
FILE *file;
long fileLength, flags;
Menu *menu;
{
  int eof;
  char *fileLine;

  eof = _true;
  if ((fileLine = fgetms (file)) != NULL) {
    bytes += strlen (fileLine);
    PrintLine (fileLine, (int) (bytes*100/fileLength), flags, menu);
    eof = !showSig && (strcmp (fileLine, "-- \n") == 0);
    free ((malloc_t)fileLine);
  }
  return (eof ? EOF : 0);
}

static void
PrintLine (string, percent, flags, menu)
char *string;
int percent;
long flags;
Menu *menu;
{
  char moreBuf[_bufSize];
  char lineBuf[_bufSize];
  int i;

  /* XXX implement term width */
  i = 0;
  while (*string) {
    lineBuf[i] = *string;
    if (++i == 80 || *string == '\n') {
      lineBuf[i] = '\0';
      (void) fputs (lineBuf, dumpFile);
      linesLeft --;
      if (linesLeft <= 1) {
	linesLeft = 1;	/* If we don't have a menu, stop next time we do */
	if (menu && more >= 1) {
	  linesLeft = lines;
	  if (percent >= 0)
	    (void) sprintf (moreBuf, "--More--(%d%%)", percent);
	  else
	    (void) strcpy (moreBuf, "--More--");
	  backErase = strlen (moreBuf);
	  (void) printf ("%s", moreBuf);
	  (void) DoMenu (flags, menu);
	}
      }
      i = 0;
    }
    string ++;
  }
}

static void
PrintRealShortHeader (hdr, article, flags)
char *hdr[];
int article;
long flags;
{
  time_t messageTime, parsedate ();
  struct tm *tm;
  char *who;
  char msgDate[128], *copyOfTitle;
  char articleNumFlags[20], articleNum[20];
  char string[_bufSize];
  int i;

  who = Who (hdr[_hdrFrom], hdr[_hdrOrganization], _false);
  if (who && (strlen (who) > (size_t) _whoLength))
    who[_whoLength] = '\0';

  if (hdr[_hdrDate]) {
    messageTime = parsedate (hdr[_hdrDate], NULL);
    tm = localtime (&messageTime);
    if (messageTime < (time ((long *) 0) - 7 * 24 * 60 * 60))
      (void) sprintf (msgDate, "%s %2d", months[tm -> tm_mon],
		      tm -> tm_mday);
    else
      (void) sprintf (msgDate, "%s %2d:%2.2d", days[tm -> tm_wday],
		      tm -> tm_hour, tm -> tm_min);
  } else {
    (void) strcpy (msgDate, "(no date)");
  }

  copyOfTitle = NULL;
  if (hdr[_hdrSubject]) {
    AllocString (&copyOfTitle, hdr[_hdrSubject]);
    if (columns > (22 + _whoLength)) {
      if (strlen (copyOfTitle) > (size_t) (columns - (22 + _whoLength)))
	/* truncate title so we don't wrap */
	copyOfTitle[columns - (22 + _whoLength)] = '\0';
    }
  }

  i = 0;
  if (articles[article].read)
    articleNumFlags[i++] = 'O';
  if (articles[article].checked)
    articleNumFlags[i++] = 'X';
  if (hdr[_hdrPriority] && (hdr[_hdrPriority][0] >= '0') && (hdr[_hdrPriority][0] <= '9') && (atoi (hdr[_hdrPriority]) < 10))
    articleNumFlags[i++] = hdr[_hdrPriority][0];
  else if (hdr[_hdrPriority])
    articleNumFlags[i++] = 'P';
  if (hdr[_hdrNewsgroups]) {
    if (BetterNewsgroup (hdr[_hdrNewsgroups]))
      articleNumFlags[i++] = '<';
    else if (strchr (hdr[_hdrNewsgroups], ',') != NULL)
      articleNumFlags[i++] = '>';
  }
  for (; i < 7; i ++)
    articleNumFlags[i] = ' ';
  (void) sprintf (articleNum, "%7d", article + 1);
  /* This copies the terminator first, then the num */
  for (i = 7; (i >= 0) && (articleNum[i] != ' '); i --)
    articleNumFlags[i] = articleNum[i];

  (void) sprintf (string, "%7s %-18s  %-9s  %s\n", articleNumFlags,
		 who ? who : "Unknown",
		 msgDate, copyOfTitle ? copyOfTitle : "");
  PrintLine (string, -1, flags, headerMenu);

  if (copyOfTitle)
    free ((malloc_t)copyOfTitle);
  if (who)
    free ((malloc_t)who);
}

void
PrintShortHeader (hdr, article)
char *hdr[];
int article;
{
  char tempBuffer[_bufSize * 4], lineBuffer[_bufSize * 4];
  char *who, *copyOfSubject;
  time_t messageTime, parsedate ();
  struct tm *tm;
  int ii;

  /* XXX wrapped 'from' lines (i.e. with organization), should be left
                                                  then right justified. */

  if (dumpFile != stdout)
    /* A marker that can be used to separate messages */
    (void) fprintf (dumpFile, " ----- \n");
  if ((article > 0) && rooms[currentRoom].displayNumber
      || floors[currentFloor].displayNumber) {
    if (dumpFile == stdout)
      (void) sprintf (tempBuffer, "%d/%d -- ", article + 1, numArticles);
    else
      (void) sprintf (tempBuffer, "%s -- ", hdr[_hdrMessageID]);
    StrCat (lineBuffer, tempBuffer);
  } else {
    StrCat (lineBuffer, seperMsg ? "-- " : "   ");
  }
  if (rooms[currentRoom].anonymous || floors[currentFloor].anonymous)
    StrCat ((char *) NULL, "*****");
  else {
    if (hdr[_hdrDate]) {
      messageTime = parsedate (hdr[_hdrDate], NULL);
      tm = localtime (&messageTime);
      (void) sprintf (tempBuffer, "%2d%s%2.2d %d:%2.2d %cm",
		      tm -> tm_year, months[tm -> tm_mon], tm -> tm_mday,
		      tm -> tm_hour % 12, tm -> tm_min,
		      (tm -> tm_hour / 12) == 0 ? 'a' : 'p');
      StrCat ((char *) NULL, tempBuffer);
    }
    who = Who (hdr[_hdrFrom], hdr[_hdrOrganization], _true);
    if (who) {
      StrCat ((char *) NULL, " from ");
      StrCat ((char *) NULL, who);
      free ((malloc_t)who);
    }
  }
  ii = strlen (lineBuffer);
  if (seperMsg) {
    if (ii < 78)
      lineBuffer[ii++] = ' ';
    for (; ii < 78; ii ++)
      lineBuffer[ii] = '-';
  }
  lineBuffer[ii++] = '\n';
  lineBuffer[ii++] = '\0';
  PrintLine (lineBuffer, 0, 0l, (Menu *) NULL);

  if (hdr[_hdrSubject]) {
    copyOfSubject = NULL;
    AllocString (&copyOfSubject, hdr[_hdrSubject]);
    (void)strcpy (tempBuffer, hdr[_hdrSubject]);
    for (ii = 0; tempBuffer[ii] != '\0'; ii ++) {
      if (isupper (tempBuffer[ii]))
	tempBuffer[ii] = tolower (tempBuffer[ii]);
    }
    if ((strcmp (tempBuffer, "(none)") != 0)
	&& (strcmp (tempBuffer, "re: (none)") != 0)) {
      (void) sprintf (tempBuffer, "   Subject: %s\n", hdr[_hdrSubject]);
      PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
    }
    free ((malloc_t)copyOfSubject);
  }
  if (hdr[_hdrSummary]) {
    (void) sprintf (tempBuffer, "   Summary: %s\n", hdr[_hdrSummary]);
    PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
  }
  if (hdr[_hdrKeywords]) {
    (void) sprintf (tempBuffer, "   Keywords: %s\n", hdr[_hdrKeywords]);
    PrintLine (tempBuffer, 0, 0l, (Menu *) NULL);
  }
}

static void
PrintHeader (article)
FILE *article;
{
  char *headerLine;
  char sigBuffer[_bufSize * 4]; /* XXX Aaack! an arbitrary size! */
  char *fileLine;
  int i, aChar;

  (void)fseek (article, 0l, 0);
  /* Print header of article */
  while ((headerLine = fgetms (article)) != NULL) {
    if (headerLine[0] == '\n') {
      free ((malloc_t)headerLine);
      break;
    }
    PrintLine (headerLine, 0, 0l, (Menu *) NULL);
    free ((malloc_t)headerLine);
  }

  /* Print signature of article */
  while ((fileLine = fgetms (article)) != NULL) {
    if (strcmp (fileLine, "-- \n") == 0)
      break;
    free ((malloc_t)fileLine);
  }
  if (fileLine != NULL) {
    free ((malloc_t)fileLine);
    PrintLine (signature, 0, 0l, (Menu *) NULL);
    i = 0;
    while ((aChar = getc (article)) != EOF) {
      sigBuffer[i++] = (char) aChar;
      if (aChar == '\n') {
	sigBuffer[i] = '\0';
	PrintLine (sigBuffer, 0, 0l, (Menu *) NULL);
	i = 0;
      }
    }
  } else {
    PrintLine ("\n", 0, 0l, (Menu *) NULL);
  }
}

static void
BackErase (characters)
int characters;
{
  char lineBuf[_bufSize*3], *ptr;

  ptr = lineBuf;
  while (characters--) {
    *ptr++ = '\b';
    *ptr++ = ' ';
    *ptr++ = '\b';
  }
  *ptr = '\0';
  (void) fputs (lineBuf, stdout);
}

static int
BetterNewsgroup (string)
/* returns _true if there is a more appropriate newsgroup for this */
/* article than the current one  */
char *string;
{
  char *copyOfString, *ptr;
  int i;

  copyOfString = NULL;
  AllocString (&copyOfString, string);
  for (ptr = strtok (copyOfString, ",");
       ptr != NULL;
       ptr = strtok ((char *) NULL, ",")) {
    if (strcmp (rooms[currentRoom].name, ptr) == 0) {
      free ((malloc_t)copyOfString);
      return (_false);
    } else {
      for (i = 0; rooms[i].name != NULL; i ++) {
	if (!floors[rooms[i].floor].forgotten && !rooms[i].forgotten
	    && (strcmp (rooms[i].name, ptr) == 0)) {
	  free ((malloc_t)copyOfString);
	  return (_true);
	}
      }
    }
  }
  free ((malloc_t)copyOfString);
  return (_false);
}

void
BreakFrom (line, author, fullname, sitename)
register char *line;
char **author, **fullname, **sitename;
{
  char *ptr;

  *author = line;
  *fullname = *sitename = NULL;
  /*
    Parse to '@' if "user@site" form, or to '<' if
    "full name <address>" form, or to '!' if it's
    siteA!siteB!user
    */
  while (*line && *line != '@' && *line != '<' && *line != '!')
    line ++;

  switch (*line) {
  case '@':	/* It's "user@site" */
    *line++ = '\0';
    *sitename = line;
    while (*line && !(*line == ' ' || *line == '\t'))
      line ++;
    if (*line) {	/* Wow! there might be a "(full name)" */
      *line++ = '\0';
      while (*line && (*line == ' ' || *line == '\t'))
	line ++;
      if (*line++ == '(') {	/* Yep! */
	*fullname = line;
	while (*line)		/* We'll go straight to the end */
	  line ++;
	if (*(--line) == ')')	/* and work back one */
	  *line = '\0';
      }
    }
    break;
  case '<':	/* It's "full name <address>" */
    *fullname = *author;
    ptr = line - 1;
    /* clear any trailing spaces on full name */
    while (ptr > *fullname && (*ptr == ' ' || *ptr == '\t'))
      *ptr-- = '\0';
    line++;
    *author = line;
    while (*line && *line != '@' && *line != '!')
      line ++;
    if (*line == '@') {	/* 'address' is "user@site" */
      *line ++ = '\0';
      *sitename = line;
      while (*line && *line != '>')
	line ++;
    } else if (*line == '!') {	/* 'address' is "siteA!siteB!user" */
      *sitename = *author;
      *author = line + 1;
      *line ++ = '\0';
      while (*line && *line != '>') {
	if (*line == '!') {
	  *sitename = *author;
	  *author = line + 1;
	  *line = '\0';
	}
	line ++;
      }
    }
    *line = '\0';
    break;
  case '!':	/* It's "siteA!siteB!user" */
    *sitename = *author;
    *author = line + 1;
    *line ++ = '\0';
    while (*line && *line != ' ' && *line != '\t') {
      if (*line == '!') {
	*sitename = *author;
	*author = line + 1;
	*line = '\0';
      }
      line ++;
    }
    if (*line) {	/* Wow! there might be a "(full name)" */
      *line++ = '\0';
      while (*line && (*line == ' ' || *line == '\t'))
	line ++;
      if (*line++ == '(') {	/* Yep! */
	*fullname = line;
	while (*line)		/* We'll go straight to the end */
	  line ++;
	if (*(--line) == ')')	/* and work back one */
	  *line = '\0';
      }
    }
    break;
  }
}

static char *
Who (from, org, withOrg)
char *from, *org;
int withOrg;
{
  _FuncName ("Who");
  char *who, *copyOfFrom, *author, *fullname, *sitename;
  int i;

  copyOfFrom = NULL;
  if (from) {
    AllocString (&copyOfFrom, from);
    BreakFrom (copyOfFrom, &author, &fullname, &sitename);
  } else
    author = fullname = sitename = NULL;

  if (fullname)
    author = fullname;

  if (org) {
    if (strcmp (org, _organization) == 0)
      sitename = NULL;	/* Don't use org if it's ours */
    else
      sitename = org;
  }

  if (sitename && !author)
    author = "Unknown";

  if (author) {
    i = strlen (author);
    who = (char *)malloc ((size_t) (i + 1 + (sitename
					     ? strlen (sitename) + 1 : 0)));
    if (!who) {
      Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
      exit (1);
    }
    (void)strcpy (who, author);
    if (withOrg && sitename) {
      who[i] = '@';
      (void)strcpy (&who[i+1], sitename);
    }
  } else
    who = NULL;

  if (copyOfFrom)
    free ((malloc_t)copyOfFrom);

  return (who);
}
