/*
 * NAME
 *     ReadFile.c -- File reading (download) functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) ReadFile.c  1.5 02 May 1992 10:03:00\n\t";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <time.h>
#include <malloc.h>
#include <stdio.h>
#include <ctype.h>
#include "protos.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "File.h"
#include "Log.h"

static char *fileFieldNames[] = {
  "File: ",
  "Desc: ",
  "User: ",
  "Date: ",
  NULL,
};

typedef struct _fileList {
  struct _fileList *next;
  char *fileName;
} FileList;
static FileList *ExpandFiles ();

static void ReadFile ();

/* ARGSUSED */
int
ReadFileCommand (type)
long type;
{
  char fileNames[_bufSize];
  FileList *expandedList;

  if (rooms[currentRoom].fileDir == NULL) {
    (void) printf ("Files are only in rooms that end with \"]\".\n");
    return 0;
  }

  (void) printf ("Enter filename(s):\n:");
  GetString (&fileNames[0], _normal);
  if (fileNames[0] == '\0') {
    return 0;
  }
  if ((expandedList
       = ExpandFiles (&fileNames[0],
		      rooms[currentRoom].fileDir)) == (FileList *) NULL)
    return 0;

  ReadFile (expandedList);
  while (expandedList != (FileList *) NULL) {
    FileList *pp;

    pp = expandedList;
    free (pp -> fileName);
    free (pp);
    expandedList = pp -> next;
  }

  return 0;
}

void
ReadOneFile (fileName)
char *fileName;
{
  _FuncName ("ReadOneFile");
  FileList *fileNames;

  fileNames = (FileList *) malloc (sizeof (FileList));
  if (fileNames == (FileList *) NULL) {
    Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
    exit (1);
  }
  fileNames->next = (FileList *) NULL;
  fileNames->fileName = strdup (fileName);
  if (fileNames->fileName == (char *) NULL) {
    Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
    exit (1);
  }
  ReadFile (fileNames);
}

static void
ReadFile (fileNames)
FileList *fileNames;
{
  char *commandString, *commandString1, destFileName[_bufSize],
  readyQuestion[_bufSize], *oneFile;
  int multipleFiles;

  multipleFiles = fileNames->next != (FileList *) NULL;
  if (local) {
    (void) printf ("Download to: ");
    GetString (destFileName, _normal);
    if (destFileName[0] != '\0') {
      if (multipleFiles)
	(void) strcat (destFileName, "/");
      while (fileNames != (FileList *) NULL) {
	commandString
	  = (char *)malloc ((size_t) (strlen (destFileName)
				      + strlen (fileNames->fileName)) + 80);
	(void) sprintf (commandString, "exec cp %s %s", fileNames->fileName,
			destFileName);
	(void)system (commandString);
	free ((malloc_t)commandString);
	fileNames = fileNames->next;
      }
    }
  } else {
    if (transferProtocol == NULL) {
      (void) printf ("You have not selected a transfer protocol.\n");
      return;
    }
    if (transferReadCommand == NULL) {
      (void) printf ("%s transfer not implemented.\n", transferProtocol);
      return;
    }
    /* 80 is a catchall for the 'exec' call below */
    commandString
      = (char *)malloc ((size_t) (strlen (transferReadCommand)
				  + strlen (fileNames->fileName)) + 80);
    commandString1
      = (char *)malloc ((size_t) (strlen (transferReadCommand)
				  + strlen (fileNames->fileName)) + 1);
    (void) sprintf (readyQuestion, "Ready for %s download? ",
		    transferProtocol);
    if (transferBatch) {
      if (AnswerYesNo (readyQuestion,
		       _defaultAnswer | _defaultYes | _noEcho) == _true) {
	/* XXX This isn't BATCH! */
	(void) sprintf (commandString1, transferReadCommand,
			fileNames->fileName);
	/* XXX Not secure, but if I remember, rz/sz tests SHELL=r* and */
	/* does not allow absolute file names? */
	(void) sprintf (commandString, "cd %s ; exec %s",
			rooms[currentRoom].fileDir
			? rooms[currentRoom].fileDir : ".", commandString1);
#ifdef notdef
	(void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; exec %s",
			rooms[currentRoom].fileDir, commandString1);
#endif
	(void) system (commandString);
      }
    } else {
      oneFile = strtok (fileNames->fileName, " ");
      while (oneFile != NULL) {
	if (AnswerYesNo (readyQuestion,
			 _defaultAnswer | _defaultYes | _noEcho) == _true) {
	  (void) sprintf (commandString1, transferReadCommand, oneFile);
	  /* XXX Not secure, but if I remember, rz/sz tests SHELL=r* and */
	  /* does not allow absolute file names? */
	  (void) sprintf (commandString, "cd %s ; exec %s",
			  rooms[currentRoom].fileDir
			  ? rooms[currentRoom].fileDir : ".", commandString1);
#ifdef notdef
	  (void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; exec %s",
			  rooms[currentRoom].fileDir, commandString1);
#endif
	  (void) system (commandString);
	} else
	  break;
	oneFile = strtok ((char *) NULL, " ");
      }
    }
    free ((malloc_t)commandString);
    free ((malloc_t)commandString1);
  }
}

int
ReadDirectory (extended)
long extended;
{
  void ClearHeader (), FreeHeader ();
  FILE *fileList;
  struct stat statBuffer;
  char *fileDesc[_maxFileFields];
#ifdef useRegex
  char *re, *regcmp (), *regex (), *dummy, *lcTemp;
#endif
  char fileListName[_bufSize];
  char matchPattern[_bufSize], commandString[_bufSize];
  char *ToLower ();
  char uploadDate[14], *fileName, fileSize[14];
  int found, aChar;
  time_t messageTime, parsedate ();
  struct tm *tm;

  if (rooms[currentRoom].fileDir != NULL) {
    if (extended) {
      GetString (matchPattern, _normal);
      (void) ToLower (matchPattern);
#ifdef useRegex
      if (matchPattern[0]) {
	re = regcmp (matchPattern, NULL);
      } else
	re = NULL;
#endif
      (void) sprintf (fileListName, "%s/.fileList",
		      rooms[currentRoom].fileDir);
      if ((fileList = fopen (fileListName, "r")) != NULL) {
	for (;;) {
	  /* Read up to a non new-line */
	  while ((aChar = getc (fileList)) == '\n')
	    ;
	  (void)ungetc (aChar, fileList);
	  /* Termination condition */
	  if (aChar == EOF)
	    break;

	  /* Read file entry */
	  ClearHeader (fileDesc, fileFieldNames);
	  /* XXX Status from ReadHeader */
	  (void) ReadHeader (fileList, fileDesc, fileFieldNames);
	  if (fileDesc[_fileName] == NULL) {
	    FreeHeader (fileDesc, fileFieldNames);
	    continue;
	  }
#ifdef useRegex
	  /* If we have a search string, look for it */
	  if (re == NULL)
	    /* If we don't have a search string, print everything */
	    found = _true;
	  else {
	    AllocString (&lcTemp, fileDesc[_fileName]);
	    found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy,
			   &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
			   &dummy) != NULL;
	    free ((malloc_t)lcTemp);
	    if (!found && fileDesc[_fileDesc]) {
	      AllocString (&lcTemp, fileDesc[_fileDesc]);
	      found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy,
			     &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
			     &dummy) != NULL;
	      free ((malloc_t)lcTemp);
	    }
	    if (!found && fileDesc[_fileUser]) {
	      AllocString (&lcTemp, fileDesc[_fileUser]);
	      found = regex (re, ToLower (lcTemp), &dummy, &dummy, &dummy,
			     &dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
			     &dummy) != NULL;
	      free ((malloc_t)lcTemp);
	    }
	  }
#else
	  found = _true;
#endif
	  if (found) {
	    fileName =
	      (char *)malloc ((size_t) (strlen (rooms[currentRoom].fileDir)
					+ strlen (fileDesc[_fileName]) + 2));
	    (void) sprintf (fileName, "%s/%s", rooms[currentRoom].fileDir,
			    fileDesc[_fileName]);
	    if (stat (fileName, &statBuffer) != -1)
	      (void) sprintf (fileSize, "%ld", statBuffer.st_size);
	    else
	      (void) strcpy (fileSize, "offlin");
	    if (fileDesc[_fileDate]) {
	      messageTime = parsedate (fileDesc[_fileDate], NULL);
	      tm = localtime (&messageTime);
	      (void) sprintf (uploadDate, "(%d%s%2d)", tm -> tm_year,
			      months[tm -> tm_mon], tm -> tm_mday);
	    } else
	      uploadDate[0] = '\0';
	    (void) printf ("%-14s %6s | %s%s\n", fileDesc[_fileName],
			   fileSize, fileDesc[_fileDesc]
			   ? fileDesc[_fileDesc] : "", uploadDate);
	    free ((malloc_t)fileName);
	  }
	  FreeHeader (fileDesc, fileFieldNames);
	}
      }
#ifdef useRegex
      if (re != NULL)
	free ((malloc_t)re);
#endif
    } else {
      GetString (matchPattern, _normal);
      (void) sprintf (commandString, "cd %s ; exec ls -FRs %s",
		      rooms[currentRoom].fileDir, matchPattern);
      (void)system (commandString);
    }
  } else {
    (void) printf ("\nFiles are only in rooms that end with \"]\".\n");
  }

  return 0;
}

/* ARGSUSED */
int
ReadArchiveHeader (dummy)
long dummy;
{
  char fileName[_bufSize], filePath[_bufSize], commandString[_bufSize], *ptr;

  if (rooms[currentRoom].fileDir == NULL) {
    (void) printf ("\nFiles are only in rooms that end with \"]\".\n");
    return 0;
  }

  (void) printf ("Enter Filename:\n: ");
  GetString (fileName, _normal);
  if (fileName[0] == '\0')
    return 0;

  if (fileName[0] == '/') {
    (void) strcpy (filePath, fileName);
  } else {
    (void) sprintf (filePath, "%s/%s", rooms[currentRoom].fileDir, fileName);
  }
  ptr = strrchr (fileName, '.');
  if ((ptr != NULL) && (strcmp (ptr, ".arc") == 0)) {
    if (!access (filePath, 4)) {
      (void) sprintf (commandString, "exec arc -il %s", filePath);
      (void)system (commandString);
    }
  } else {
    (void) printf ("File is not an archived file.\n");
  }

  return 0;
}

static FileList *
ExpandFiles (fileNames, fileDir)
char *fileNames, *fileDir;
{
  _FuncName ("ExpandFiles");
  FileList *expandedFiles = (FileList *) NULL, *prevFile, *thisFile;
  char *pp;
  int fileDirNameLen;

  fileDirNameLen = (fileDir != (char *) NULL) ? strlen (fileDir) : 0;
  pp = strtok (fileNames, ", \t\n");
  while (pp != (char *) NULL) {
    thisFile = (FileList *) malloc (sizeof (FileList));
    if (thisFile == (FileList *) NULL) {
      Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
      exit (1);
    }
    if (expandedFiles == (FileList *) NULL)
      expandedFiles = thisFile;
    else
      /*LINTED prevFile used only after first iteration */
      prevFile -> next = thisFile;
    thisFile -> fileName = (char *) malloc (fileDirNameLen
					    + strlen (pp) + 1);
    if (thisFile -> fileName == (char *) NULL) {
      Log (funcName, __LINE__, LOG_ERROR, _outOfMemory);
      exit (1);
    }
    if (fileDir != (char *) NULL) {
      (void) strcpy (thisFile -> fileName, fileDir);
      (void) strcat (thisFile -> fileName, "/");
      (void) strcat (thisFile -> fileName, pp);
    } else {
      (void) strcpy (thisFile -> fileName, pp);
    }
    thisFile -> next = (FileList *) NULL;
    prevFile = thisFile;
    pp = strtok ((char *) NULL, ", \t\n");
  }
  return (expandedFiles);
}
