/*
 * NAME
 *     Read.c -- General reading commands and functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Read.c  1.4 02 May 1992 09:13:46\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <fgetmfs.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include "protos.h"
#include "Log.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "Message.h"
#include "File.h"

extern char *hdr[];
extern int linesLeft;
static int PrintMessageByMessageID ();

/* ARGSUSED */
int
ReadStatus (dummy)
long dummy;
{
  time_t theTime;
  long totalArticles, diff;
  int totalRooms, totalFloors;
  struct tm *tm;

  (void) printf ("  This is %s, site name %s\n", _organization, _siteName);
  (void) time (&theTime);
  tm = localtime (&theTime);
  (void) printf ("  %2d%s%2.2d %d:%2.2d %cm\n", tm -> tm_year,
		 months[tm -> tm_mon], tm -> tm_mday, tm -> tm_hour % 12,
		 tm -> tm_min, (tm -> tm_hour / 12) == 0 ? 'a' : 'p');
  (void) printf ("  Version %s.\n", _version);
  (void) printf ("  Logged in as %s (%s)\n", logname, longname);
  if (floorMode)
    (void) printf ("  Floor mode.\n");
  (void) printf ("  Your terminal type is %s.\n", terminalType);
  (void) printf ("  Your transfer protocol is %s.\n",
		 transferProtocol == NULL ? "None" : transferProtocol);
  (void) printf ("  Your editor is %s.\n",
		 editorName == NULL ? "None" : editorName);
  totalArticles = 0;
  for (totalRooms = 0; rooms[totalRooms].name != NULL; totalRooms ++)
    if ((diff = rooms[totalRooms].highest - rooms[totalRooms].lowest) != -1)
      totalArticles += diff;
  for (totalFloors = 0; floors[totalFloors].name != NULL; totalFloors ++);
  (void) printf ("  %ld messages in %d rooms in %d floors.\n", totalArticles,
		 totalRooms, totalFloors);
  (void) printf ("  %dmeg message and file space.\n", _siteSize);

  return 0;
}

int
ReadMessageByNumber (firstDigit)
long firstDigit;
{
  char articleString[_bufSize], fileName[_bufSize];
  int article;

  articleString[0] = '0' + (char) firstDigit;
  GetString (&articleString[1], _normal);
  article = atoi (articleString) - 1;
  if (article < 0 || article > numArticles) {
    (void) printf ("%d isn't a valid article number.\n", article + 1);
    return 0;
  }
  (void) sprintf (fileName, "%s/%ld", RoomPath (rooms[currentRoom].name),
		  articles[article].number);
  linesLeft = lines;
  (void) PrintMessage (_readMoreDefault, fileName, article, _false);
  return 0;
}

int
ReadMessageByMessageID ()
{
  char messageID[_bufSize], *ptr;

  messageID[0] = '<';
  GetString (&messageID[1], _normal);
  ptr = strchr (messageID, '>');
  if (ptr == NULL)
    (void)strcat (messageID, ">");
  if (messageID[0]) {
    if (!PrintMessageByMessageID (messageID))
      (void) printf ("Article %s not found.\n", messageID);
  }
  return 0;
}

static int
PrintMessageByMessageID (messageID)
/* MessageID must include '<' and '>' */
char *messageID;
{
  _FuncName ("PrintMessageByMessageID");
  FILE *historyFile;
  char historyFileName[_bufSize], historyLine[_bufSize * 4], *ptr1, *ptr2, fileName[_bufSize];
  long articleNum, atol ();
  int article, room;

  (void) sprintf (historyFileName, "%s/history", _newsLibDir);
  historyFile = fopen (historyFileName, "r");
  if (historyFile == NULL) {
    Log (funcName, __LINE__, LOG_WARNING, "Unable to open news history file.");
    return (_false);
  }
  while (fgets (historyLine, _bufSize * 4, historyFile) != NULL) {
    ptr1 = strchr (historyLine, '\t');	/* ptr1 --> tab before date */
    if (ptr1 == NULL)
      continue;	/* If no '\t' then must be a screwy line, try another */
    *ptr1 = '\0';		/* terminate the messageID */
    ptr1 = strchr (ptr1 + 1, '\t'); /* ptr1 --> tab before newsgroup/article */
    /* We should have zipped past the date, if not, then another screwy line */
    if (ptr1 == NULL)
      continue;
    if (ptr1[1] == '\n')
      continue;	/* this article has expired, don't even try to test it */
    ptr2 = ptr1 + 1;		/* ptr2 --> newsgroup/article */
    ptr1 = strchr (ptr2, ' ');	/* ptr1 --> space before newsgroup/article */
    if (ptr1 == NULL)
      ptr1 = strchr (ptr2, '\n');	/* if not found, ptr1 --> new-line */
    if (ptr1 == NULL)
      continue;			/* if still not found, then it's screwy line */
    *ptr1 = '\0';		/* terminate the first newsgroup/article */
    if (strcmp (messageID, historyLine) == 0) {	/* Is this the article we're
						   looking for? */
      ptr1 = strrchr (ptr2, '/'); /* ptr1 --> '/' in newsgroup/article */
      if (ptr1 == NULL)		/* if no '/' then screwy line */
	return (_false);	/*   since we found the article, we'll exit */
      articleNum = atol (ptr1 + 1);	/* get article number */
      *ptr1 = '\0';			/* terminate newsgroup name */
      room = FindRoom (_findExact, ptr2);
      Goto (room);
      for (article = 0;
	   article < numArticles && articles[article].number != articleNum;
	   article ++)
	;
      if (article < numArticles) {
	(void) sprintf (fileName, "%s/%ld", RoomPath (rooms[currentRoom].name),
			articles[article].number);
	linesLeft = lines;
	if (PrintMessage (_readMoreDefault, fileName, article, _false) == -1)
	  return (_false);
	else
	  return (_true);
      }
      return (_false);
    }
  }
  return (_false);
}

int
ReadMessages (flags)
long flags;
{
  _FuncName ("ReadMessages");
  char fileName[_bufSize], dumpFileName[_bufSize];
  int article, increment, start, end, back;

  if (numArticles == 0)
    return 0;

  if (flags & _readForward) {
    start = 0;
    end = numArticles;
    increment = 1;
  } else {
    start = numArticles - 1;
    end = -1;
    increment = -1;
  }

  if (flags & _transferProtocol) {
    (void) sprintf (dumpFileName, "%s/tempFile", flTempDir);
    dumpFile = fopen (dumpFileName, "w");
    (void) printf ("Pre96paring download file...\n");
  }

  back = _false;		/* back == 2 to exit */
  linesLeft = lines;
  for (article = start; back != 2 && article != end; article += increment) {
    if (!((flags & _readAll) || back
	  || ((flags & _readNew) && !articles[article].read)
	  || (!(flags & _readNew) && articles[article].read))) {
      continue;
    }
    (void) sprintf (fileName, "%s/%ld", RoomPath (rooms[currentRoom].name),
		    articles[article].number);
    back = PrintMessage (flags, fileName, article, back);
    if (back == _true) {
      article -= increment * 2;
    }
    if (article < -1)
      article = -1;
    else if (article > numArticles)
      article = numArticles;
  }
	
  if (flags & _transferProtocol) {
    (void)fclose (dumpFile);
    dumpFile = stdout;
    (void) printf ("Download file completed.\n");
    ReadOneFile (dumpFileName);
    if (unlink (dumpFileName) == -1) {
      /* XXX errno? */
      Log (funcName, __LINE__, LOG_ERROR,
	   "Unlinking temporary download file '%s'.\n", dumpFileName);
    }
  }
  return 0;
}
