/*
 * NAME
 *     MenuDef.c -- Top level menu
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) MenuDef.c  1.4 02 May 1992 09:11:54\n\t";
#endif

#include <stdio.h>
#include <ctype.h>
#include "protos.h"
#include "defs.h"
#include "Unidel.h"
#include "Message.h"
#include "Log.h"

extern int strncmp ();

int Chat ();
int ReadMessages (), EnterMessageCommand (), GotoCommand (), KnownRooms (),
  Disabled (), HelpCommand ();
int EnterFileCommand (), ReadDirectory (), ReadStatus (), ReadFileCommand (),
  FindRoomCommand (), Terminate ();
int EnterRoom (), EnterSignature (), EnterFullName (), ToggleExpertMode (),
  EnterPauseMode (), EnterTerminalType ();
int EnterTransferProtocol (), EnterEditor ();
int PrintForgottenRooms (), ReadMessageByNumber (), ReadMessageByMessageID (),
  SystemCommand ();
int ReadArchiveHeader ();
int  GotoFloorCommand (), KnownFloors (), ForgetFloor (), ToggleFloorMode ();
static int ReadSubMenu ();

/*-
 * NAME
 *   Menu -- table for specifying commands and their procedures
 * 
 * SYNOPSIS
 *   command, text1, text2, text3, text4, parameter, procedure
 *
 * DESCRIPTION
 *   The first field is the sequence of four or less characters needed
 * to execute the command.  The next four fields are the words that
 * are displayed for each character, respectively.  An "=" prefix
 * means do not new-line after printing the word.  The sixth field, a
 * long int, is passed to the procedure, the seventh field, as it's
 * only parameter.
 *
 *   Since the table is searched from the beginning until the first
 * match is found, only the first match needs to have a matching word
 * in a position, the rest would not have been reached by then, for
 * example:
 * 
 *	".E?", ".", "Enter ", "\b, Help", NULL, 2l, HelpCommand,
 *	".ER", NULL, NULL, "oom", NULL, 0l, EnterRoom,
 *
 * the "." and "Enter" are not duplicated on the ".ER" line.  The
 * procedure is executed only when a complete match is found.
 *
 *   For submenus, found elsewhere, the parameter in the sixth field
 * is 'or'ed into the submenu's parameter field.
 */

Menu mainMenu[] = {
  /* Reading Commands */
  "N", "New", NULL, NULL, NULL, _readMoreDefault | _readNew | _readForward, ReadMessages,
  "O", "Old Reverse", NULL, NULL, NULL, _readMoreDefault, ReadMessages,
  "F", "Forward", NULL, NULL, NULL, _readMoreDefault | _readAll | _readForward, ReadMessages,
  "R", "Reverse", NULL, NULL, NULL, _readMoreDefault | _readAll, ReadMessages,
  "E", "Enter Message", NULL, NULL, NULL, 0l, EnterMessageCommand,
  "0", "=0", NULL, NULL, NULL, 0l, ReadMessageByNumber,
  "1", "=1", NULL, NULL, NULL, 1l, ReadMessageByNumber,
  "2", "=2", NULL, NULL, NULL, 2l, ReadMessageByNumber,
  "3", "=3", NULL, NULL, NULL, 3l, ReadMessageByNumber,
  "4", "=4", NULL, NULL, NULL, 4l, ReadMessageByNumber,
  "5", "=5", NULL, NULL, NULL, 5l, ReadMessageByNumber,
  "6", "=6", NULL, NULL, NULL, 6l, ReadMessageByNumber,
  "7", "=7", NULL, NULL, NULL, 7l, ReadMessageByNumber,
  "8", "=8", NULL, NULL, NULL, 8l, ReadMessageByNumber,
  "9", "=9", NULL, NULL, NULL, 9l, ReadMessageByNumber,
  "<", "=0", NULL, NULL, NULL, 0l, ReadMessageByMessageID,
  "=", "New Headers", NULL, NULL, NULL, _readHeaders | _readMoreDefault | _readNew | _readForward, ReadMessages,

  /* Room Commands */
  "G", "=Goto ", NULL, NULL, NULL, 0l, GotoCommand,
  "S", "Skip", NULL, NULL, NULL, 1l, GotoCommand,
  "B", "Backup", NULL, NULL, NULL, 2l, GotoCommand,
/*	"U", "Ungoto", NULL, NULL, NULL, 2l, GotoCommand,*/
  "Z", "Forget Room", NULL, NULL, NULL, 3l, GotoCommand,
  "K", "Known Rooms", NULL, NULL, NULL, 0l, KnownRooms,

  /* File Commands */
  "U", "Upload file", NULL, NULL, NULL, 0l, EnterFileCommand,
  "D", "Download file", NULL, NULL, NULL, 0l, ReadFileCommand,
  "L", "=List files ", NULL, NULL, NULL, (long) _true, ReadDirectory,

  /* Miscellaneous */
  "C", "Chat", NULL, NULL, NULL, 0l, Chat,
  "H", "Help", NULL, NULL, NULL, 7l, HelpCommand,
  "?", "Help", NULL, NULL, NULL, 1l, HelpCommand,
  "T", "Terminate", NULL, NULL, NULL, (long) _false, Terminate,
  "Y", "Your Info", NULL, NULL, NULL, 0l, ReadStatus,

  /*
   * Extended Commands
   */

  /* Enter Commands */
  ".E?", ".", "Enter ", "\b, Help", NULL, 2l, HelpCommand,
  ".ER", NULL, NULL, "oom", NULL, 0l, EnterRoom,

  ".EM", NULL, NULL, "Message", NULL, 0l, EnterMessageCommand,
  ".EF", NULL, NULL, "File", NULL, 0l, EnterFileCommand,
  ".EPM", NULL, NULL, "Protocol", "Messsage", _transferProtocol, EnterMessageCommand,

  /* Configuration Commands */
  ".EC?", NULL, NULL, "Configuration ", "\b, Help", 8l, HelpCommand,
  ".ECD", NULL, NULL, NULL, "Editor", 0l, EnterEditor,
  ".ECE", NULL, NULL, NULL, "=", 0l, ToggleExpertMode,
  ".ECF", NULL, NULL, NULL, "=", 0l, ToggleFloorMode,
  ".ECM", NULL, NULL, NULL, "Pause Messages", 0l, EnterPauseMode,
  ".ECN", NULL, NULL, NULL, "Full Name", 0l, EnterFullName,
  ".ECP", NULL, NULL, NULL, "Password", 3l, SystemCommand,
  ".ECS", NULL, NULL, NULL, "Signature", 0l, EnterSignature,
  ".ECT", NULL, NULL, NULL, "Terminal Type", 0l, EnterTerminalType,
  ".ECX", NULL, NULL, NULL, "Transfer Protocol", 0l, EnterTransferProtocol,

  /* Read Commands */
  ".R?", NULL, "Read ", "\b, Help", NULL, 4l, HelpCommand,
  ".RD", NULL, NULL, "=Directory ", NULL, (long) _false, ReadDirectory,
  ".RE", NULL, NULL, "=Extended Directory ", NULL, (long) _true, ReadDirectory,
  ".RS", NULL, NULL, "Status", NULL, 0l, ReadStatus,
  ".R0", NULL, NULL, "=0", NULL, 0l, ReadMessageByNumber,
  ".R1", NULL, NULL, "=1", NULL, 1l, ReadMessageByNumber,
  ".R2", NULL, NULL, "=2", NULL, 2l, ReadMessageByNumber,
  ".R3", NULL, NULL, "=3", NULL, 3l, ReadMessageByNumber,
  ".R4", NULL, NULL, "=4", NULL, 4l, ReadMessageByNumber,
  ".R5", NULL, NULL, "=5", NULL, 5l, ReadMessageByNumber,
  ".R6", NULL, NULL, "=6", NULL, 6l, ReadMessageByNumber,
  ".R7", NULL, NULL, "=7", NULL, 7l, ReadMessageByNumber,
  ".R8", NULL, NULL, "=8", NULL, 8l, ReadMessageByNumber,
  ".R9", NULL, NULL, "=9", NULL, 9l, ReadMessageByNumber,
  ".R<", NULL, NULL, "=<", NULL, 0l, ReadMessageByMessageID,

  ".RH", NULL, NULL, "Archive Header", NULL, 0l, ReadArchiveHeader,
  ".RA", NULL, NULL, "All", NULL, _readMoreDefault | _readAll | _readForward, ReadMessages,
  ".RG", NULL, NULL, "Global New", NULL, _readMoreDefault | _readGlobal | _readAll | _readForward, ReadMessages,
  ".RN", NULL, NULL, "New", NULL, _readMoreDefault | _readNew | _readForward, ReadMessages,
  ".RO", NULL, NULL, "Old Reverse", NULL, _readMoreDefault, ReadMessages,
  ".RR", NULL, NULL, "Reverse", NULL, _readMoreDefault | _readAll, ReadMessages,
  ".RF", NULL, NULL, "File", NULL, _transferProtocol, ReadFileCommand,
  ".RM", NULL, NULL, "=More ", NULL, _readMore, ReadSubMenu,
  ".RT", NULL, NULL, "=Text ", NULL, _readMoreDefault, ReadSubMenu,
  ".RP", NULL, NULL, "=Protocol ", NULL, _transferProtocol, ReadSubMenu,
  ".R=", NULL, NULL, "=Headers ", NULL, _readHeaders, ReadSubMenu,

  /* Miscellaneous extended commands */
  ".?", NULL, "Help", NULL, NULL, 5l, HelpCommand,
  ".H", NULL, "=Help ", NULL, NULL, 0l, HelpCommand,
  ".K", NULL, "=Known ", NULL, NULL, _findPartial, FindRoomCommand,
  ".S", NULL, "=Skip", NULL, NULL, 4l, GotoCommand,
  ".TQ", NULL, "Terminate ", "Quit-Also", NULL, (long) _true, Terminate,
  ".U", NULL, "=Ungoto ", NULL, NULL, 5l, GotoCommand,
  ".G", NULL, "=Goto ", NULL, NULL, 6l, GotoCommand,
  ".Z", NULL, "List Forgotten Rooms", NULL, NULL, 0l, PrintForgottenRooms,

  /* Floor Commands */
  ";?", "", "Floor Commands Summary", NULL, NULL, 6l, HelpCommand,
  ";G", NULL, "=Goto Floor ", NULL, NULL, 0l, GotoFloorCommand,
  ";C", NULL, "=", NULL, NULL, 0l, ToggleFloorMode,
  ";K", NULL, "Known Floors", NULL, NULL, 0l, KnownFloors,
  ";S", NULL, "Skip Floor", NULL, NULL, 1l, GotoFloorCommand,
  ";Z", NULL, "Forget Floor", NULL, NULL, 0l, ForgetFloor,
  ";>", NULL, "Next Floor", NULL, NULL, 2l, GotoFloorCommand,
  ";<", NULL, "Previous Floor", NULL, NULL, 3l, GotoFloorCommand,
  ">", "Next Floor", NULL, NULL, NULL, 2l, GotoFloorCommand,
  "<", "Previous Floor", NULL, NULL, NULL, 3l, GotoFloorCommand,
  ";N", NULL, "New messages on this floor", NULL, NULL, _readFloor | _readNew | _readForward, ReadMessages,

  /* End of list */
  "", NULL, NULL, NULL, NULL, 0l, NULL,
};

static Menu readTypesSubMenu[] = {
  "A", "All", NULL, NULL, NULL, _readAll | _readForward, ReadMessages,
  "G", "Global New", NULL, NULL, NULL, _readGlobal | _readAll | _readForward, ReadMessages,
  "N", "New", NULL, NULL, NULL, _readNew | _readForward, ReadMessages,
  "O", "Old Reverse", NULL, NULL, NULL, 0l, ReadMessages,
  "R", "Reverse", NULL, NULL, NULL, _readAll, ReadMessages,
  "F", "File", NULL, NULL, NULL, 0l, ReadFileCommand,

  /* End of list */
  "", NULL, NULL, NULL, NULL, 0l, NULL,
};

char *selectorStrings[] = {
  NULL,				/* 0 */
  "mainmenu",
  "enter",
  "/bin/passwd",
  "read",
  "summary",			/* 5 */
  "floorsum",
  "help",
  "config",
};

static int
ReadSubMenu (type)
long type;
{
  return (DoMenu (type, readTypesSubMenu));
}

int
DoMenu (type, menu)
long type;
Menu *menu;
{
  char *funcName = "DoMenu";
  char command[4];
  int aChar, i, noCR, done, status;
  unsigned int charIndex;

  charIndex = 0;
  done = _false;
  while (!done) {
    aChar = GetChar (_upperCase | _noEcho);
    command[charIndex] = (char) aChar;
    /* search for first matching command */
    for (i = 0;
	 menu[i].command[0] != '\0'
	 && strncmp (menu[i].command, command, charIndex + 1);
	 i ++);
    if (menu[i].command[0] == '\0') { /* Not found */
      if (isprint (aChar))
	(void) printf ("%c ?\n", aChar); /*   error */
      else if (iscntrl (aChar))
	(void) printf ("^%c ?\n", (aChar == 0x7f) ? '?' : aChar | 0x60);
      else
	(void) printf ("?? ?\n");
      done = _true;
    } else {			/* Found */
      if (menu[i].printString[charIndex][0] == '=') {
	/*   should we CR after printing? */
	noCR = _true;
	/* print string sans '=' */
	(void) printf ("%s", &menu[i].printString[charIndex][1]);
      } else {
	noCR = _false;
	/* print text of string */
	(void) printf ("%s", menu[i].printString[charIndex]);
      }
      if ((charIndex == 3) || (menu[i].command[charIndex + 1] == '\0')) {
	/* is the command complete? */
	if (!noCR)
	  (void) printf ("\n");	/* Yes, print that CR */
	Log (funcName, __LINE__, LOG_COMMANDS, "'%-4.*s'", charIndex + 1,
	     command);
	/* Call the command */
	status = (* menu[i].function) (type | menu[i].selector);
	done = _true;
      } else {
	/* No, try some more */
	charIndex ++;
      }
    }
  }
  return (status);
}
