/*
 * NAME
 *     log.h -- Header for log(3)
 *
 * AUTHOR
 *     Ken MacLeod
 *
 * SCCS
 *     @(#) Log.h  1.1 02 May 1992 10:59:52 
 */

#ifdef LEVELED_ERRORS
#define LOG_FATAL_ERROR -3
#define LOG_ERROR -2
#define LOG_WARNING -1
#define LOG_MESSAGE 0
#define LOG_DEBUG1 1
#define LOG_DEBUG2 2
#define LOG_DEBUG3 3
#define LOG_DEBUG4 4
#define LOG_DEBUG5 5
#define LOG_DEBUG6 6
#define LOG_DEBUG7 7
#define LOG_DEBUG8 8
#define LOG_DEBUG9 9
#ifndef LOG_PROG_TRACE
#define LOG_PROG_TRACE 1		/* level of program tracing info */
#endif

#ifndef LOG_FUNC_TRACE
#define LOG_FUNC_TRACE 5		/* level of function tracing info */
#endif

#else
#define LOG_ERROR (0x00000001l)
#define LOG_WARNING (0x00000002l)
#define LOG_MESSAGE (0x00000004l)
#define LOG_PROG_TRACE (0x00000008l)
#define LOG_FUNC_TRACE (0x00000010l)
#endif

#ifdef LEVELED_ERRORS
extern int debug;		/* program debugging level */
#else
extern long debugMask;		/* mask of debugging info to display */
extern long whereMask;		/* mask of what errors will display
				   function/line info */
#endif
extern char *logFileName;	/* name of file to log to */
extern char *programName;	/* name of program */
extern char *invoker;		/* system!name of user */

#define _FuncName(NAME) static char funcName[]=NAME
int InitLog (/* char *programName */);
void Log (/* char *funcName, int *lineNo, int level,
	       char *format, ... */ );
