/*
 * 
 * NAME
 *     log -- log an error or debug message to a file.
 *
 * SYNOPSIS
 *     log (char *funcName, int lineNo, int level, char *format, args ...)
 *
 * DESCRIPTION
 *     (See log(3))
 * 
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Log.c  1.1 02 May 1992 10:59:48\n\t";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <varargs.h>
#include <string.h>
#include <malloc.h>
#if !defined(BSD) && !defined(SYSV4) && 0
typedef void *malloc_t;
#endif
#include <time.h>
#include <Log.h>

#ifndef lint
static char _sccsID[]="@(#)Log.c	1.1 02 May 1992";
#endif

#ifdef LEVELED_ERRORS
static char *errorNames[] = {
  "ERROR: ",		/* -3 */
  "ERROR: ",			/* -2 */
  "Warning: ",		/* -1 */
  "",
  "Level 1: ",
  "Level 2: ",
  "Level 3: ",
  "Level 4: ",
  "Level 5: ",
  "Level 6: ",
  "Level 7: ",
  "Level 8: ",
  "Level 9: "
};
int debug = 0;
#else
long debugMask = LOG_ERROR | LOG_WARNING | LOG_MESSAGE;
long whereMask = ~0l;
#endif

char *programName;
char *invoker;
char *logFileName;
void exit ();
long time ();

int
InitLog (programName)
     char *programName;
{
  char *userName, *systemName, *getenv ();
#ifdef HAVE_gethostname
  size_t systemNameSize = 40;	/* A seemingly oversized place to start */
#endif
  
  programName = programName;
  userName = getenv ("LOGNAME");
  if (userName == (char *) NULL)
    userName = "unknown";
#ifdef HAVE_gethostname
  systemName = (char *) malloc (systemNameSize);
  if (systemName == (char *) NULL)
    return (-1);
  /* We loop here to make sure that we get all of systemName, because
     we can only find out how long it is by trial and error */
  while (1) {
    (void) gethostname (systemName, systemNameSize);
    for (ii = 0; ii < systemNameSize && systemName[ii] != '\0'; ii ++)
      ;
    if (ii != systemNameSize)
      break;			/* we know we got it when we see nul */
    systemNameSize += 40;	/* A seemingly reasonable increment */
    systemName = (char *) realloc ((malloc_t) systemName,
				   systemNameSize);
    if (systemName == (char *) NULL)
      return (-1);
  }
#else
  systemName = "unknown";
#endif
  invoker = (char *) malloc (((size_t) strlen (userName)) + strlen (systemName) + 3);
  if (invoker == (char *) NULL)
    return (-1);
  (void) strcpy (invoker, userName);
  (void) strcat (invoker, "@");
  (void) strcat (invoker, systemName);
  (void) strcat (invoker, " ");
#ifdef HAVE_gethostname
  free ((malloc_t) systemName);
#endif
  logFileName = (char *) NULL;

  return (0);
}

/*VARARGS0*/
void
Log (va_alist)
/* log (char *funcName, int lineNo, int level, char *format [, arg ] ...) */

va_dcl

{
  char *funcName;
  int lineNo;
  char *format;
  va_list args;
#ifdef LEVELED_ERRORS
  int level;
#else
  long mask;
#endif
  FILE *logFile;
  long theTime;
  struct tm *localTime;
  char errorString[1024];
  char outString[1024];
  char routineString[1024];

  va_start (args);
  /*LINTED va_arg */
  funcName = (char *) va_arg (args, char *);
  /*LINTED va_arg */
  lineNo = (int) va_arg (args, int);
#ifdef LEVELED_ERRORS
  /*LINTED va_arg */
  level = (int) va_arg (args, int);
#else /* !LEVELED_ERRORS */
  /*LINTED va_arg */
  mask = (long) va_arg (args, long);
#endif /* LEVELED_ERRORS */
#ifdef LEVELED_ERRORS
  if (level <= debug) {
#else
  if ((mask & debugMask) != 0) {
#endif
    /*LINTED va_arg */
    format = (char *) va_arg (args, char *);
    (void) time (&theTime);
    localTime = localtime (&theTime);
#ifdef LEVELED_ERRORS
    if (debug > 0)
#else
    if ((mask & whereMask) != 0)
#endif
      (void) sprintf (routineString, ":%s:%d", funcName, lineNo);
    else
      routineString[0] = '\0';
    (void) vsprintf (errorString, format, args);
    (void) sprintf (outString, "%s(%d/%d-%d:%2.2d:%2.2d) (%s:%ld%s) %s%s\n",
		    invoker, localTime -> tm_mon + 1, localTime -> tm_mday,
		    localTime -> tm_hour, localTime -> tm_min,
		    localTime -> tm_sec, programName, getpid (), routineString,
#ifdef LEVELED_ERRORS
		    errorNames[level + 3],
#else
		    "",
#endif
		    errorString);
    if (logFileName == (char *) NULL || logFileName[0] == '-')
      logFile = stderr;
    else
      logFile = fopen (logFileName, "a");
    (void) fprintf (logFile, "%s", outString);
    if (logFile != stderr)
      (void) fclose (logFile);
  }
  va_end (args);
#ifdef LEVELED_ERRORS
  if (level == LOG_FATAL_ERROR)
    exit (1);
#endif
}
