/*
 * NAME
 *     Input -- user input functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Input.c  1.3 02 May 1992 09:10:12\n\t";
#endif

#include <stdio.h>
#include <ctype.h>
#include <Unidel.h>
#include "protos.h"

static int SpecialChar ();
extern size_t strlen ();
extern char *strcpy ();

int
AnswerYesNo (string, flags)
char *string;
int flags;
{
  int aChar, done, answer;

  aChar = '\0';
  done = _false;
  while (!done) {
    (void) printf ("%s", string);
    aChar = GetChar (flags | _noEcho);
    if ((flags & _defaultAnswer) && aChar == ' ' || aChar == '\n') {
      aChar = (flags & _defaultYes) ? 'Y' : 'N';
    }
    switch (aChar) {
    case 'y':
    case 'Y':
      if (!(flags & _noEcho))
	(void) printf ("Yes\n");
      answer = _true;
      done = _true;
      break;
    case 'n':
    case 'N':
      if (!(flags & _noEcho))
	(void) printf ("No\n");
      answer = _false;
      done = _true;
      break;
    case _keyAbort:
      answer = -1;
      done = _true;
      break;
    default:
      if (isprint (aChar))
	(void)putchar (aChar);
      (void) printf (" ?\n");
      break;
    }
  }
  return (answer);
}

int
GetChar (inputMode)
int inputMode;
{
  int aChar;

  aChar = getchar ();
  aChar = SpecialChar (aChar);
  if (inputMode & _upperCase) {
    if (isalpha (aChar) && islower (aChar)) {
      aChar = toupper (aChar);
    }
  }
  if (inputMode & _lowerCase) {
    if (isalpha (aChar) && isupper (aChar)) {
      aChar = tolower (aChar);
    }
  }
  if (!(inputMode & _noEcho) && (aChar < 0x100)) {
    (void)putchar (aChar);
  }
  return (aChar);
}

int
SpecialChar (theChar)
int theChar;
{
  switch (theChar) {
  case 0x0d:	/* ^M */
    theChar = '\n';
    break;
  case 0x08:	/* ^H */
    theChar = _keyLeft;
    break;
  case 0x0c:	/* ^L */
    theChar = _keyRight;
    break;
  case 0x0b:	/* ^K */
    theChar = _keyUp;
    break;
  case 0x0a:	/* ^J */
    theChar = _keyDown;
    break;
  case 0x7f:	/* <DEL> */
    theChar = _keyLeft;
    break;
  case '\033':
  case '\003':
    theChar = _keyAbort;
    break;
  }
  return (theChar);
}

void
GetString (theString, inputMode)
char *theString;
int inputMode;
{
  int i, aChar;

  i = 0;
  while ((aChar = GetChar (inputMode)) != '\n') {
    if (isprint (aChar))
      theString[i++] = (char) aChar;
    else switch (aChar) {
    case _keyLeft:
    case '\10':
    case '\177':
      if (i > 0) {
	i--;
	(void) printf ("\10 \10");
      }
      break;
    }
  }
  theString[i] = '\0';
}

GetStringWDefault (prompt, theString, noBrainer, inputMode)

char *prompt, *theString, *noBrainer;
int inputMode;

{
  int i, aChar;

  if (noBrainer && noBrainer[0] != '\0' && theString[0] == '\0')
    (void) printf ("%s [%s]: ", prompt, noBrainer);
  else
    (void) printf ("%s: %s", prompt, theString);
  i = strlen (theString);
  while ((aChar = GetChar (inputMode)) != '\n') {
    if (isprint (aChar))
      theString[i++] = (char) aChar;
    else switch (aChar) {
    case _keyLeft:
    case '\10':
    case '\177':
      if (i > 0) {
	i--;
	(void) printf ("\10 \10");
      }
      break;
    case _keyAbort:
      (void) printf ("\nAborted.\n");
      return _keyAbort;
    }
  }
  theString[i] = '\0';
  if (i == 0 && noBrainer && noBrainer[0] != '\0')
    (void) strcpy (theString, noBrainer);
  return (aChar);
}
