/*
 * NAME
 *     Header.c -- Header handling functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Headers.c  1.3 02 May 1992 09:08:21\n\t";
#endif

#include <fgetmfs.h>
#include <stdio.h>
#include <malloc.h>

static int StrLNCmp ();
extern int nstrip ();
extern size_t strlen ();

void
ClearHeader (hdr, hdrFieldNames)
char **hdr, **hdrFieldNames;
{
  while (*hdrFieldNames++)
    *hdr++ = NULL;
}

void
FreeHeader (hdr, hdrFieldNames)
char **hdr, **hdrFieldNames;
{
  while (*hdrFieldNames++) {
    if (*hdr)
      free ((malloc_t)*hdr);
    hdr ++;
  }
}

int
ReadHeader (file, hdr, hdrFieldNames)
char **hdr, **hdrFieldNames;
FILE *file;
{
  char *headerLine;
  int i;

  while ((headerLine = cfgetms (file)) != NULL) {
    if (headerLine[0] == '\n') {
      free ((malloc_t)headerLine);
      break;
    }
    (void) nstrip (headerLine);
    if (headerLine[0] == '>') {	/* Quicky, get rid of '>From ' lines in mail */
      free ((malloc_t)headerLine);
      continue;
    }
    for (i = 0;
	 hdrFieldNames[i] != NULL
	 && StrLNCmp (headerLine, hdrFieldNames[i],
		      strlen (hdrFieldNames[i])) != 0; i ++);
    if (hdrFieldNames[i] != NULL) {
      register char *ptr, *ptr1;

      hdr[i] = headerLine;
      ptr = &headerLine[0];
      ptr1 = &headerLine[strlen(hdrFieldNames[i])];
      while (*ptr++ = *ptr1++)
	;
    } else
      free ((malloc_t)headerLine);
  }
  return (feof (file));	/* Error: out of memory, iff not end of file */
}

void
WriteHeader (file, hdr, hdrFieldNames)
FILE *file;
char **hdr, **hdrFieldNames;
{
  while (*hdrFieldNames) {
    if (*hdr)
      (void) fprintf (file, "%s%s\n", *hdrFieldNames, *hdr);
    hdr ++;
    hdrFieldNames ++;
  }
  (void) putc ('\n', file);
}

/* Assumes ASCII strings and only characters from "A-Za-z0-9" and "-" */
static int
StrLNCmp (s1, s2, nn)
register char *s1, *s2;
unsigned int nn;
{
  register int dd;

  while (*s1 && *s2 && nn && ((dd = (*s1-*s2)) == 0 || dd == -32 || dd == 32))
    s1++, s2++, nn--;

  return (nn);
}
