/*
 * NAME
 *     General.c -- general functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) General.c  1.6 02 May 1992 09:07:34\n\t";
#endif

#include <termio.h>
#include <stdio.h>
#include <fgetmfs.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include "protos.h"
#include "Log.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "Message.h"
#include "File.h"

extern int linesLeft;

void
ScanNewArticles ()
{
  char *ptr;
  int i;

  for (i = 0; rooms[i].name != NULL; i ++) {
    if (!rooms[i].forgotten) {
      rooms[i].newArticles = 0;
      if (rooms[i].highest != 0) {
	if (strchr (rooms[i].articlesRead, ',') == NULL) {
	  if ((ptr = strchr (rooms[i].articlesRead, '-')) == NULL) {
	    rooms[i].newArticles = 1;
	  } else {
	    rooms[i].newArticles = atoi (ptr + 1) < rooms[i].highest;
	  }
	} else {
	  rooms[i].newArticles = 1;
	}
      }
    }
  }
}

int
HelpCommand (topic)
long topic;
{
  Help (selectorStrings[topic]);
  return 0;
}

void
Help (topic)
char *topic;
{
#ifdef XXXPageHelp
  char commandString[_bufSize];
#endif
  char tempString[_bufSize], fileName[_bufSize];

  if (topic == NULL) {
    GetString (tempString, _lowerCase);
    /* XXX tempString gets put into a command, make sure it's _just_ a */
    /* file name */
  } else
    (void)strcpy (tempString, topic);
  (void) sprintf (fileName, "%s/%s.doc", _docDir, tempString);
  if (tempString[0]) {
    linesLeft = lines;
    if (PrintMessage (_readMoreDefault, fileName, -2, 0) == -1)
      (void) printf ("No such topic, %s.\n", tempString);
#ifdef XXXPageHelp
    (void) printf ("\n");
    (void) sprintf (commandString, "%s -v \"^#\" %s | %s"
		    _egrep, fileName, filePager);
    (void) UserCommand (commandString);
#endif
    (void) printf ("\n");
  }
}

int
UserCommand (command)
char *command;
{
  char commandString[_bufSize];
  extern int secure;
  int status;
  
  if (secure)
    (void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; %s",
		    flTempDir, command);
  else
    (void) sprintf (commandString, "%s", command);
  SetupTerminal (_false);
  status = system (commandString);
  SetupTerminal (_true);

  return (status);
}

void
SetupTerminal (userMode)
int userMode;		/* TRUE means set to run in user mode, FALSE means
			   restore */
{
#ifdef noway
  static struct termio originalMode;
  struct termio currentMode;
#endif

  if (userMode) {
    setbuf (stdout, (char *) NULL);
    (void)system ("stty -icrnl -icanon -echo -isig eof \\^a eol \\^@");
#ifdef noway
    ioctl (0, TCGETA, &originalMode);
    originalMode . c_lflag &= ~(XCASE);
    originalMode . c_lflag |= (ECHOE);
    originalMode . c_cc [VERASE] = 0x08;
    originalMode . c_cc [VKILL] = 0x15;
    originalMode . c_cc [VSWTCH] = 0x03;
    currentMode = originalMode;
    currentMode.c_iflag &= ~(ICRNL);
    currentMode.c_lflag &= ~(ICANON | ECHO | ISIG);
    currentMode.c_cc[VEOF] = 1;
    currentMode.c_cc[VEOL] = 0;
    ioctl (0, TCSETA, &currentMode);
#endif
  } else {
    (void)system ("stty icrnl icanon echo isig eof \\^d eol \\^`");
#ifdef noway
    ioctl (0, TCSETA, &originalMode);
#endif
  }
}

/* ARGSUSED */
int
Disabled (dummy)
long dummy;
{
  (void) printf ("This function is under construction, please excuse the dust.\n");
  return 0;
}

int
Terminate (quitAlso)
long quitAlso;
{
  if (quitAlso) {
    finished = _true;
  } else {
    (void) printf ("Do you really want to quit (Y/[N])? ");
    if (GetChar (_upperCase) == 'Y')
      finished = _true;
  }
  if (finished == _true)
    MarkRead ();

  return 0;
}

int
SystemCommand (selector)
long selector;
{
  SetupTerminal (_false);
  (void)system (selectorStrings[selector]);
  SetupTerminal (_true);
  return 0;
}

/* ARGSUSED */
int
Chat (dummy)
long dummy;
{
  char userName[_bufSize], chatCommand[_bufSize];

  (void) printf ("\n");
  SetupTerminal (_false);
  (void)system (_listUsersCommand);
  SetupTerminal (_true);
  (void) printf ("\nEnter NAME of the person you would like to chat with.\n: ");
  GetString (userName, _lowerCase);
  if (userName[0] != '\0') {
    (void) sprintf (chatCommand, "%s %s", _chatCommand, userName);
    SetupTerminal (_false);
    (void)system (chatCommand);
    SetupTerminal (_true);
    (void) printf ("\nYou are now back in room:\n");
  }

  return 0;
}

void
SetupTransferProtocol (protocol)
char *protocol;
{
  _FuncName ("SetupTransferProtocol");
  FILE *protocolFile;
  char protocolFileName[_bufSize], *fields[5];
  static char *protocolLine;
  int nf;

  if (protocol == NULL || protocol[0] == '\0')
    return;
  (void) sprintf (protocolFileName, "%s/Transfers", _libDir);
  if ((protocolFile = fopen (protocolFileName, "r")) != NULL) {
    while ((protocolLine = fgetms (protocolFile)) != NULL) {
      if (protocolLine[0] == '\0' || protocolLine[0] == '#'
	  || isspace(protocolLine[0])) {
	free ((malloc_t)protocolLine);
	continue;
      }
      (void)nstrip (protocolLine);
      nf = split (protocolLine, fields, 5, ":");
      if (nf >= 5 && strcmp (fields[0], protocol) == 0) {
	(void)fclose (protocolFile);
	transferProtocol = fields[0];
	transferDescription = fields[1];
	transferFlags = fields[2];
	transferEnterCommand = fields[3];
	transferReadCommand = fields[4];
	transferBatch = IsIn ("batch", transferFlags);
	(void)fclose (protocolFile);
	return;
      }
      free ((malloc_t)protocolLine);
    }
    (void)fclose (protocolFile);
  } else {
    Log (funcName, __LINE__, LOG_ERROR, "Could not open Transfers file '%s'.",
		    protocolFileName);
  }
  Log (funcName, __LINE__, LOG_ERROR, "Could not find protocol '%s'.",
       protocol);
  transferProtocol = NULL;
}

void
SetupEditor (editor)
char *editor;
{
  _FuncName ("SetupEditor");
  FILE *editorFile;
  char editorFileName[_bufSize], *fields[4];
  static char *editorLine;
  int nf;

  if (editor == NULL || editor[0] == '\0')
    return;
  (void) sprintf (editorFileName, "%s/Editors", _libDir);
  if ((editorFile = fopen (editorFileName, "r")) != NULL) {
    while ((editorLine = fgetms (editorFile)) != NULL) {
      if (editorLine[0] == '\0' || editorLine[0] == '#'
	  || isspace(editorLine[0])) {
	free ((malloc_t)editorLine);
	continue;
      }
      (void)nstrip (editorLine);
      nf = split (editorLine, fields, 4, ":");
      if (nf >= 4 && strcmp (fields[0], editor) == 0) {
	(void)fclose (editorFile);
	editorName = fields[0];
	editorDescription = fields[1];
	editorFlags = fields[2];
	editorCommand = fields[3];
	(void)fclose (editorFile);
	return;
      }
      free ((malloc_t)editorLine);
    }
    (void)fclose (editorFile);
  } else {
    Log (funcName, __LINE__, LOG_ERROR, "Could not open Editors file '%s'.",
	 editorFileName);
  }
  Log (funcName, __LINE__, LOG_ERROR, "Could not find editor '%s'.", editor);
  editorName = NULL;
}

int
Edit (fileName)
char * fileName;
{
  char commandString[_bufSize];
  int status;

  if (editorName == NULL || editorCommand == NULL) {
    (void) printf ("You have not selected an editor.\n");
    return (_false);
  }

  (void) sprintf (commandString, editorCommand, fileName);
  status = UserCommand (commandString);

  return (!status);	/* Reverse the sense of shell exits */
}
