/*
 * NAME
 *     Floor.c -- Floor functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Floor.c  1.2 02 May 1992 09:06:32\n\t";
#endif

#include <stdio.h>
#include <ctype.h>
#include "protos.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"

static int FindFloor ();

extern char *user[];

int
GotoFloorCommand (type)
long type;
{
  char floorName[_bufSize];
  int room, floor;

  switch ((int) type) {
  case 0:		/* Goto Floor */
    GetString (floorName, _normal);
    if (floorName[0]) {
      room = FindFloor (floorName);
      if (room != -1) {
	MarkRead ();
	Goto (room);
      }
    }
    break;
  case 1:		/* Skip Floor */
  case 2:		/* Next Floor */
    floor = currentFloor;
    do {
      floor ++;
      if (floors[floor].name == NULL)
	floor = 0;
      /* This actually looks up the first non-forgotten room in that floor */
      room = FindFloor (floors[floor].name);
    } while (floors[floor].forgotten ||
	     ((room == -1) && (floor != currentFloor)));
    if (room != -1) {
      MarkRead ();
      Goto (room);
    }
    break;
  case 3:		/* Previous Floor */
    floor = currentFloor;
    do {
      if (floor == 0)
	for (floor = 0; floors[floor].name != NULL; floor ++);
      floor --;
      /* This actually looks up the first non-forgotten room in that floor */
      room = FindFloor (floors[floor].name);
    } while (floors[floor].forgotten ||
	     ((room == -1) && (floor != currentFloor)));
    if (room != -1) {
      MarkRead ();
      Goto (room);
    }
    break;
  }

  return 0;
}

static int
FindFloor (floorName)
/* Returns the first known room on this floor or -1 */
char *floorName;
{
  char floorNameCopy[_bufSize];
  int floor, room, i;

  for (i = 0; floorName[i] != '\0'; i ++)
    floorNameCopy[i] = isupper (floorName[i])
      ? tolower (floorName[i]) : floorName[i];
  floorNameCopy[i] = '\0';

  for (floor = 0;
       (floors[floor].name != NULL)
       && !IsIn (floorNameCopy, floors[floor].name)
       && !IsIn (floorNameCopy, floors[floor].description); floor ++)
    ;
  if (floors[floor].name == NULL)		/* No floor by that name */
    return (-1);

  for (room = 0;
       (rooms[room].name != NULL)
       && !(!rooms[room].forgotten && (rooms[room].floor == floor));
       room ++);
  if (rooms[room].name == NULL)		/* No known rooms on that floor */
    return (-1);
  return (room);
}

/* ARGSUSED */
int
ForgetFloor (dummy)
long dummy;
{
  if (currentFloor != 0) {
    floors[currentFloor].forgotten = _true;
    (void) GotoFloorCommand (2l);	/* Next Floor */
  }

  return 0;
}

/* ARGSUSED */
int
KnownFloors (dummy)
long dummy;
{
  int floor;

  for (floor = 0; floors[floor].name != NULL; floor ++) {
    if (!floors[floor].forgotten) {
      (void) printf ("[%s", floors[floor].name);
      if (floors[floor].description != NULL)
	(void) printf (":\t%s", floors[floor].description);
      (void) printf ("]\n");
    }
  }

  return 0;
}

/* ARGSUSED */
int
ToggleFloorMode (dummy)
long dummy;
{
  if (floorMode) {
    floorMode = _false;
    AllocString (&user[_userFloorMode], "No");
    (void) printf ("Normal mode.\n");
  } else {
    floorMode = _true;
    AllocString (&user[_userFloorMode], "Yes");
    (void) printf ("Floor mode.\n");
  }

  return 0;
}
