/*
 * NAME
 *     EnterMesg.c -- Message entering
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) EnterMesg.c  1.7 02 May 1992 09:03:29\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <fgetmfs.h>
#include <time.h>
#include <malloc.h>
#include "protos.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "Message.h"
#include "User.h"
#include "File.h"

void StrCat ();
static void CopyMessage ();
static int GetHeaders ();

char *GetAddresses ();

static int EditSend (), EditPrint (), EditAbort (), EditContinue (),
  EditHold (), EditHelp ();
static int EdHeadHelp (), EdHeadTo (), EdHeadExpires (),
  EdHeadUserHeader (), EdHeadNewsgroups (), EdHeadOther ();
static int ValidNewsgroups (), EdHeadDistribution ();

static Menu editMenu[] = {
  "?", "Help", NULL, NULL, NULL, 0l, EditHelp,
  "S", "Send", NULL, NULL, NULL, 0l, EditSend,
  "P", "Print", NULL, NULL, NULL, 0l, EditPrint,
  "A", "Abort", NULL, NULL, NULL, 0l, EditAbort,
  "C", "Continue", NULL, NULL, NULL, 0l, EditContinue,
  "H", "Hold Message", NULL, NULL, NULL, 0l, EditHold,

  /* Edit Headers */
  "E?", "Edit ", "\b, Help", NULL, NULL, 0l, EdHeadHelp,
  "EB", NULL, "=Bcc", NULL, NULL, (long) _hdrBcc, EdHeadTo,
  "EC", NULL, "=Cc", NULL, NULL, (long) _hdrCc, EdHeadTo,
  "ED", NULL, "=Distribution", NULL, NULL, (long) _hdrDistribution, EdHeadDistribution,
  "EE", NULL, "=Expires", NULL, NULL, (long) _hdrExpires, EdHeadExpires,
  "EF", NULL, "=Followup-To", NULL, NULL, (long) _hdrFollowupTo, EdHeadNewsgroups,
  "EK", NULL, "=Keywords", NULL, NULL, (long) _hdrKeywords, EdHeadOther,
  "EM", NULL, "=Summary", NULL, NULL, (long) _hdrSummary, EdHeadOther,
  "EN", NULL, "=Newsgroups", NULL, NULL, (long) _hdrNewsgroups, EdHeadNewsgroups,
  "EO", NULL, "=Organization", NULL, NULL, (long) _hdrOrganization, EdHeadOther,
  "EP", NULL, "=Priority", NULL, NULL, (long) _hdrPriority, EdHeadOther,
  "ER", NULL, "=Reply-To", NULL, NULL, (long) _hdrReplyTo, EdHeadTo,
  "ES", NULL, "=Subject", NULL, NULL, (long) _hdrSubject, EdHeadOther,
  "ET", NULL, "=To", NULL, NULL, (long) _hdrTo, EdHeadTo,
  "E0", NULL, "=", NULL, NULL, (long) _hdrUser0, EdHeadUserHeader,
  "E1", NULL, "=", NULL, NULL, (long) _hdrUser1, EdHeadUserHeader,
  "E2", NULL, "=", NULL, NULL, (long) _hdrUser2, EdHeadUserHeader,
  "E3", NULL, "=", NULL, NULL, (long) _hdrUser3, EdHeadUserHeader,
  "E4", NULL, "=", NULL, NULL, (long) _hdrUser4, EdHeadUserHeader,
  "E5", NULL, "=", NULL, NULL, (long) _hdrUser5, EdHeadUserHeader,
  "E6", NULL, "=", NULL, NULL, (long) _hdrUser6, EdHeadUserHeader,
  "E7", NULL, "=", NULL, NULL, (long) _hdrUser7, EdHeadUserHeader,
  "E8", NULL, "=", NULL, NULL, (long) _hdrUser8, EdHeadUserHeader,
  "E9", NULL, "=", NULL, NULL, (long) _hdrUser9, EdHeadUserHeader,

  /* End of list */
  "", NULL, NULL, NULL, NULL, 0l, NULL,
};

static int followup, reply, mailFlag, editing, edit;
static char *tempFileName;
static char *newHdr[_hdrMax];
extern char *hdr[], *hdrFieldNames[];

int
EnterMessageCommand (flags)
long flags;
{
  (void) EnterMessage (flags, "", _false);
  return 0;
}

/* ARGSUSED */
int
EnterMessage (type, articleFileName, replyByMail)
long type;
char *articleFileName;
int replyByMail;	/* _true if doing a 'reply' by mail */
{
  void ClearHeader (), FreeHeader ();
  int answer, i;

  if (rooms[currentRoom].readOnly || floors[currentFloor].readOnly) {
    (void) printf ("No messages can be entered in this room.\n");
    return (_false);
  }

  followup = (articleFileName[0] != '\0');
  reply = replyByMail;
  mailFlag = (replyByMail || (rooms[currentRoom].type == _mailType));

  ClearHeader (newHdr, hdrFieldNames);
  /* Clear the extra fields not defined with hdrFieldNames */
  for (i = _hdrUser0; i <= _hdrUser9; i ++)
    newHdr[i] = NULL;
  if (!GetHeaders ())
    return (_true);

  tempFileName = tmpnam ((char *) NULL);

  if (followup
      && (answer = AnswerYesNo ("Do you want to include a copy of the message (Y/[N])? ", _defaultAnswer)) == _true) {
    CopyMessage (articleFileName, tempFileName);
  }
  if (answer == -1)
    return (_true);

  editing = _true;
  edit = _true;
  do {
    if (edit)
      (void) Edit (tempFileName);
    (void) printf ("Edit: ");
    edit = _false;
    (void) DoMenu (0l, editMenu);
  } while (editing);

  FreeHeader (newHdr, hdrFieldNames);
  /* Free the extra fields not defined with hdrFieldNames */
  for (i = _hdrUser0; i <= _hdrUser9; i ++)
    if (newHdr[i])
      free ((malloc_t)newHdr[i]);
  return (_false);
}

static void
CopyMessage (source, dest)
char *source, *dest;
{
  FILE *sourceFile, *destFile;
  char *headerLine;
  int aChar, lastChar;

  (void) printf ("OK, but edit it to remove unnecessary verbiage, signatures, etc.\n");

  if ((sourceFile = fopen (source, "r")) == NULL) {
    /* XXX log */
    (void) printf ("Aack!  Couldn't open the original file!  Scream at sysop\n");
    return;
  }
  if ((destFile = fopen (dest, "w")) == NULL) {
    (void) fclose (sourceFile);
    (void) printf ("Aack!  Couldn't open the new file!  Scream at sysop\n");
    return;
  }

  /* Zip past header of article */
  while ((headerLine = fgetms (sourceFile)) != NULL) {
    aChar = headerLine[0];
    free ((malloc_t)headerLine);
    if (aChar == '\n')
      break;
  }

  if (hdr[_hdrMessageID]) {
    (void) fprintf (destFile, "In article %s", hdr[_hdrMessageID]);
    if (mailFlag || hdr[_hdrFrom])
      (void) fprintf (destFile, ", ");
  }
  if (mailFlag)
    (void) fprintf (destFile, "you write");
  else if (hdr[_hdrFrom])
    (void) fprintf (destFile, "%s writes", hdr[_hdrFrom]);
  if (hdr[_hdrMessageID] || hdr[_hdrFrom])
    (void) fprintf (destFile, ":\n");
  lastChar = '\n';
  while ((aChar = getc (sourceFile)) != EOF) {
    if (lastChar == '\n')
      (void) putc ('>', destFile);
    (void) putc (aChar, destFile);
    lastChar = aChar;
  }
  if (lastChar != '\n')
    (void) putc ('\n', destFile);

  (void) fclose (sourceFile);
  (void) fclose (destFile);
}

/* ARGSUSED */
static int
EditSend (flag)
long flag;
{
  FILE *messageFile, *outPipe;
  char commandString[_bufSize], signatureFileName[_bufSize];
  int aChar, lastChar, i;

  /* XXX Can/should we Cc or Bcc an article using mail? */
  messageFile = fopen (tempFileName, "r");
  if (messageFile != NULL) {
    if (newHdr[_hdrTo]) {
      (void) sprintf (commandString, "%s %s %s %s %s", _mailDelivery,
		      GetAddresses (newHdr[_hdrTo]),
		      newHdr[_hdrCc] ? GetAddresses (newHdr[_hdrCc]) : "",
		      newHdr[_hdrBcc] ? GetAddresses (newHdr[_hdrBcc]) : "",
		      logname);
      outPipe = popen (commandString, "w");
      if (newHdr[_hdrBcc]) {	/* It _is_ a blind cc! */
	free ((malloc_t)newHdr[_hdrBcc]);
	newHdr[_hdrBcc] = NULL;
      }
    } else if (!mailFlag && newHdr[_hdrNewsgroups]) {
      outPipe = popen (_newsDelivery, "w");
    } else {
      (void) printf ("Either a \"To:\" for mail or a \"Newsgroups:\" for messages must be set.\n");
      (void) printf ("Use \"E(dit) T(o)\" or \"E(dit) N(ewgroups)\" to fix this.\n");
      return (_false);
    }
  }
  if (outPipe == NULL || messageFile == NULL) {
    (void) sprintf (commandString, "mv %s %s/held.message\n", tempFileName,
		    homeDir);
    if (system (commandString) == 0)
      (void) printf ("Unable to save message, message held.\n");
    else
      (void) printf ("Unable to save message, unable to hold message; do you have a paddle?\n");
    if (messageFile != NULL) {
      (void) fclose (messageFile);
      if (outPipe != NULL)
	(void) pclose (outPipe);
    }
    return (_false);
  }

  /* XXX Not any more. */
  /* Both mail and news add From, Date, and Message-ID */
  /* Write the extra headers not defined with hdrFieldNames,
     these headers before the defined headers is kinda icky but
     WriteHeader terminates the header */
  for (i = _hdrUser0; i <= _hdrUser9; i ++)
    if (newHdr[i])
      (void)fprintf (outPipe, "%s\n", newHdr[i]);
  WriteHeader (outPipe, newHdr, hdrFieldNames);

  while ((aChar = getc (messageFile)) != EOF) {
    (void) putc (aChar, outPipe);
    lastChar = aChar;
  }
  if (lastChar != '\n')
    (void) putc ('\n', outPipe);

  (void) fclose (messageFile);
  (void) sprintf (signatureFileName, "%s/.signature", homeDir);
  if (mailFlag && (messageFile = fopen (signatureFileName, "r")) != NULL) {
    /* Normally, this would be "\n-- \n", but we've guaranteed new-line
       at end of file */
    (void) fprintf (outPipe, "-- \n");
    while ((aChar = getc (messageFile)) != EOF) {
      (void) putc (aChar, outPipe);
      lastChar = aChar;
    }
    if (lastChar != '\n')
      (void) putc ('\n', outPipe);
    (void) fclose (messageFile);
  }

  (void) pclose (outPipe);
  (void) unlink (tempFileName);

  editing = _false;
  return (_true);
}

/* ARGSUSED */
static int
EditAbort (flag)
long flag;
{
  if (AnswerYesNo ("Are you sure (Y/N)? ", 0) == _true) {
    editing = _false;
    (void) unlink (tempFileName);
  }
  return 0;
}

static int
GetHeaders ()
{
  char tempBuf[_bufSize*4];
  char *copyOfFrom, *author, *fullname, *sitename;
  int answer;

  if (mailFlag) {
    if (reply) {
      copyOfFrom = NULL;
      if (hdr[_hdrReplyTo]) {
	AllocString (&copyOfFrom, hdr[_hdrReplyTo]);
	BreakFrom (copyOfFrom, &author, &fullname, &sitename);
      } else if (hdr[_hdrFrom]) {
	AllocString (&copyOfFrom, hdr[_hdrFrom]);
	BreakFrom (copyOfFrom, &author, &fullname, &sitename);
      } else
	author = fullname = sitename = NULL;
      if (author == NULL || sitename == NULL) {
	if (copyOfFrom)
	  free ((malloc_t)copyOfFrom);
	(void) printf ("There is no return or reply-to address.\n");
	return (_false);
      }
      (void) sprintf (tempBuf, "%s@%s", author, sitename);
      if (copyOfFrom)
	free ((malloc_t)copyOfFrom);
      AllocString (&newHdr[_hdrTo], tempBuf);
    }
    (void) printf ("To");
    if (!EdHeadTo ((long) _hdrTo))
      return (_false);
  } else if (!followup
	     && (answer = AnswerYesNo ("Is this a follow-up to another message (Y/[N])? ", _defaultAnswer)) == _true) {
    (void) printf ("  You should go to the message you wish to follow-up to and\n");
    (void) printf ("use F(ollow-up).  Using R(everse read) is one way to go back\n");
    (void) printf ("through messages.\n");
    return (_false);
  }
  if (answer == -1)
    return (_false);

  /* Create From */
  newHdr[_hdrFrom]
    = (char *)malloc ((size_t) (strlen (logname) + strlen (longname)
				+ strlen (_siteName) + 5));
  (void) sprintf (newHdr[_hdrFrom], "%s@%s (%s)", logname, _siteName,longname);

  /* Get subject */
  if (followup && hdr[_hdrSubject]) {
    if (!(strncmp (hdr[_hdrSubject], "Re:", 3) == 0
	  || strncmp (hdr[_hdrSubject], "RE:", 3) == 0
	  || strncmp (hdr[_hdrSubject], "re:", 3) == 0)) {
      StrCat (tempBuf, "Re: ");
    } else
      StrCat (tempBuf, "");
    StrCat ((char *) NULL, hdr[_hdrSubject]);
    AllocString (&newHdr[_hdrSubject], tempBuf);
  }
  (void) printf ("Subject");
  if (!EdHeadOther ((long) _hdrSubject))
    return (_false);

  if (followup) {
    if (hdr[_hdrSummary])
      AllocString (&newHdr[_hdrSummary], hdr[_hdrSummary]);
    (void) printf ("Summary");
    if (!EdHeadOther ((long) _hdrSummary))
      return (_false);
  }

  if (followup && hdr[_hdrKeywords])
    AllocString (&newHdr[_hdrKeywords], hdr[_hdrKeywords]);

  /* Get key words */
#ifndef askForKeywords		/* Otherwise we only ask for keywords if they're already there */
  if (newHdr[_hdrKeywords]) {
#endif
    (void) printf ("Keywords");
    if (!EdHeadOther ((long) _hdrKeywords))
      return (_false);
#ifndef askForKeywords
  }
#endif

  if (!mailFlag && (strchr (rooms[currentRoom].name, '.') != NULL
		    || (followup && (hdr[_hdrDistribution] != NULL)))) {
    if (hdr[_hdrDistribution] != NULL)
      AllocString (&newHdr[_hdrDistribution], hdr[_hdrDistribution]);
    (void) printf ("Distribution");
    if (!EdHeadDistribution ((long) _hdrDistribution))
      return (_false);
  }

  if (!mailFlag && followup
      && (hdr[_hdrFollowupTo]
	  || (hdr[_hdrNewsgroups]
	      && (strchr (hdr[_hdrNewsgroups], ',') != NULL)))) {
    if (hdr[_hdrFollowupTo]) {
      (void) printf ("Followups have been redirected to\n");
      AllocString (&newHdr[_hdrNewsgroups], hdr[_hdrFollowupTo]);
    } else
      AllocString (&newHdr[_hdrNewsgroups], hdr[_hdrNewsgroups]);
    (void) printf ("Newsgroups");
    if (!EdHeadNewsgroups ((long) _hdrNewsgroups))
      return (_false);
  } else if (!mailFlag)
    AllocString (&newHdr[_hdrNewsgroups], rooms[currentRoom].name);

  /* Create or prepend references */
  if (followup && (hdr[_hdrMessageID] || hdr[_hdrReferences])) {
    newHdr[_hdrReferences]
      = (char *)malloc ((size_t) ((hdr[_hdrMessageID]
				   ? strlen (hdr[_hdrMessageID]) : 0)
				  + (hdr[_hdrReferences]
				     ? strlen (hdr[_hdrReferences]) : 0)) +14);
    StrCat (newHdr[_hdrReferences], "");
    if (hdr[_hdrMessageID])
      StrCat ((char *)NULL, hdr[_hdrMessageID]);
    if (hdr[_hdrReferences]) {
      if (hdr[_hdrMessageID])
	StrCat ((char *)NULL, " ");
      StrCat ((char *)NULL, hdr[_hdrReferences]);
    }
  }

  AllocString (&newHdr[_hdrOrganization], _organization);

  return (_true);
}

/* ARGSUSED */
static int
EditPrint (flag)
long flag;
{
  char commandString[_bufSize];

  PrintShortHeader (newHdr, -1);
  (void) sprintf (commandString, "%s %s", filePager,
		  tempFileName);
  (void) printf ("\n");
  (void) UserCommand (commandString);
  (void) printf ("\n");
  return (_false);
}

/* ARGSUSED */
static int
EditContinue (flag)
long flag;
{
  edit = _true;
  return (_false);
}

/* ARGSUSED */
static int
EditHold (flag)
long flag;
{
  char commandString[_bufSize];

  (void) sprintf (commandString, "mv %s %s/held.message\n", tempFileName,
		  homeDir);
  if (system (commandString) == 0)
    (void) printf ("Message held.\n");
  else
    (void) printf ("Error trying to hold message; do you have a paddle?\n");
  editing = _false;
  return (_false);
}

/* ARGSUSED */
static int
EditHelp (flag)
long flag;
{
  Help ("edit");
  return (_false);
}

/* ARGSUSED */
static int
EdHeadHelp (dummy)
long dummy;
{
  static char helpful[] = { _hdrSubject, _hdrCc, _hdrBcc, _hdrKeywords,
			      _hdrSummary, _hdrDistribution, _hdrPriority,
			      _hdrExpires, '\0' };
  int i;

  for (i = 0; i < _hdrMax; i ++) {
    if (newHdr[i] != NULL || ((i != '\0') && (strchr (helpful, i) != NULL)))
      if ((i >= _hdrUser0) && (i <= _hdrUser9))
	(void) printf ("%d) %s\n", i - _hdrUser0, newHdr[i]);
      else
	(void) printf ("%s%s\n", hdrFieldNames[i], newHdr[i] ? newHdr[i] : "");
  }
  (void) printf ("\nType E(dit) and the first letter of header to change.\n");
  return (_false);
}

static int
EdHeadTo (field)
long field;
{
  char workingAddresses[_bufSize];
  int status, answer;

  if (newHdr[field])
    (void) strcpy (workingAddresses, newHdr[field]);
  else
    workingAddresses[0] = '\0';

  if ((field == _hdrTo) && !mailFlag) {
    (void) printf ("\n  Using \"To:\" will cause your message to be mailed.\nTo");
  }

  do {
    if (GetStringWDefault ("", workingAddresses, (field == _hdrTo)
			   ? _adminName : NULL, _normal) == _keyAbort) {
      (void) printf ("%s unchanged.\n", hdrFieldNames[field]);
      return (_false);
    }
    if (workingAddresses[0] == '\0')
      break;
    status = ValidAddresses (workingAddresses);
    if (status == 1) {
      if ((answer = AnswerYesNo ("Do you want to send anyway (Y/[N])? ",
				 _defaultAnswer)) == _true)
	status = 0;
    }
    if (answer == -1)
      return (_false);
  } while (status != 0);

  if (workingAddresses[0] != '\0')
    AllocString (&newHdr[field], workingAddresses);
  else if (newHdr[field])
    free ((malloc_t)newHdr[field]), newHdr[field] = NULL;

  return (_true);
}

static int
EdHeadOther (field)
long field;
{
  int status;
  char workingString[_bufSize];

  if (newHdr[field])
    (void) strcpy (workingString, newHdr[field]);
  else
    workingString[0] = '\0';

  do {
    if ((status = GetStringWDefault ("", workingString, (char *) NULL, _normal)) == _keyAbort)
      break;
    status = 0;
    if ((int) field == _hdrSubject && workingString[0] == '\0'
	&& (rooms[currentRoom].displaySubject
	    || floors[rooms[currentRoom].floor].displaySubject)) {
      (void) printf ("Message \"Subjects\" are required in this room.\n");
      status = 1;
    }
  } while (status != 0);
  if (status == _keyAbort) {
    (void) printf ("%s unchanged.\n", hdrFieldNames[field]);
    return (_false);
  }
  if (workingString[0] != '\0')
    AllocString (&newHdr[field], workingString);
  else if ((int) field == _hdrSubject)
    AllocString (&newHdr[field], "(None)");
  else if (newHdr[field] != NULL)
    free ((malloc_t)newHdr[field]), newHdr[field] = NULL;

  return (_true);
}

static int
EdHeadNewsgroups (field)
long field;
{
  char workingString[_bufSize];

  if (newHdr[field])
    (void) strcpy (workingString, newHdr[field]);
  else
    workingString[0] = '\0';

  for(;;) {
    if (GetStringWDefault ("", workingString, (char *) NULL, _normal) == _keyAbort) {
      (void) printf ("%s unchanged.\n", hdrFieldNames[field]);
      return (_false);
    }
    if (workingString[0] == '\0'
	|| (field == _hdrFollowupTo && strcmp (workingString, "poster") == 0)
	|| ValidNewsgroups (workingString))
      break;
    else
      (void) printf ("%s\b\b", hdrFieldNames[field]);
  }
  if (workingString[0] != '\0')
    AllocString (&newHdr[field], workingString);
  else if (newHdr[field])
    free ((malloc_t)newHdr[field]), newHdr[field] = NULL;

  return (_true);
}

static int
EdHeadDistribution (field)
long field;
{
  char workingString[_bufSize];

  if (newHdr[field])
    (void) strcpy (workingString, newHdr[field]);
  else
    workingString[0] = '\0';
  for(;;) {
    if (GetStringWDefault ("", workingString,
			   (char *) NULL, _normal) == _keyAbort) {
      (void) printf ("%s unchanged.\n", hdrFieldNames[field]);
      return (_false);
    }
    /* XXX Put the dists in def or load them from Init */
    if (workingString[0] == '\0'
	|| IsIn (workingString, "~world~na~usa~utah~cit~"))
      break;
    else
      (void) printf ("'%s' is not a valid distribution.\n%s\b\b",
		     workingString, hdrFieldNames[field]);
  }

  if (strcmp ("world", workingString) != 0 || workingString[0] != '\0')
    AllocString (&newHdr[field], workingString);
  else if (newHdr[field])
    free ((malloc_t)newHdr[field]), newHdr[field] = NULL;

  return (_true);
}

static int
EdHeadExpires (field)
long field;
{
  time_t theExpiry, parsedate ();
  struct tm *tm;
  char timeZone[4], *ptr, workingExpire[_bufSize];

  if (newHdr[field])
    (void) strcpy (workingExpire, newHdr[field]);
  else
    workingExpire[0] = '\0';

  for (;; (void) printf ("%s\b\b", hdrFieldNames[field])) {
    if (GetStringWDefault ("", workingExpire,
			   (char *) NULL, _normal) == _keyAbort) {
      (void) printf ("%s unchanged.\n", hdrFieldNames[field]);
      return (_false);
    }
    if (workingExpire == '\0') {
      if (newHdr[field])
	free ((malloc_t)newHdr[field]), newHdr[field] = NULL;
      return (_true);
    }
    if ((theExpiry = parsedate (workingExpire, NULL)) < 8 * 60 * 60 * 24 * 7) {
      (void) printf ("I don't understand that date.\n");
      continue;
    }
    if (theExpiry > (time ((long *) 0) + 8 * 60 * 60 * 24 * 7)) {
      /* WEEKS */
      (void) printf ("Too far in the future.\n");
      continue;
    }
    if (theExpiry < (time ((long *) 0) - 1 * 60 * 60 * 24)) { /* DAYS */
      (void) printf ("Expiry date already past.\n");
      continue;
    }

    /* If all checks pass, we're done */
    break;
  }

  /* Put expiry in local-time internet format */
  (void) strcpy (timeZone, "GMT");
  if ((ptr = getenv ("TZ")) != NULL)
    (void) strncpy (timeZone, ptr, 3);

  tm = localtime (&theExpiry);
  (void) printf ("Expires: %s, %2d %s %2d %2d:%2.2d:%2.2d %s\n",
		 days[tm -> tm_wday], tm -> tm_mday, months[tm -> tm_mon],
		 tm -> tm_year, tm -> tm_hour, tm -> tm_min, tm -> tm_sec,
		 timeZone);
  tm = gmtime (&theExpiry);
  (void) sprintf (workingExpire, "%s, %2d %s %2d %2d:%2.2d:%2.2d GMT",
		  days[tm -> tm_wday], tm -> tm_mday, months[tm -> tm_mon],
		  tm -> tm_year,tm -> tm_hour, tm -> tm_min, tm -> tm_sec);

  AllocString (&newHdr[field], workingExpire);

  return (_true);
}

static int
EdHeadUserHeader (field)
long field;
{
  char workingString[_bufSize];

  if (newHdr[field])
    (void) strcpy (workingString, newHdr[field]);
  else
    workingString[0] = '\0';
	
  if (GetStringWDefault ("", workingString,
			 (char *) NULL, _normal) == _keyAbort)
    return (_false);

  if (workingString[0] != '\0') {
    /* XXX check header name syntax */
    AllocString (&newHdr[field], workingString);
  } else if (newHdr[field])
    free ((malloc_t)newHdr[field]), newHdr[field] = NULL;
  return (_false);
}

static int
ValidNewsgroups (newsgroups)
char *newsgroups;
{
  char copyOfNewsgroups[_bufSize], *ptr;
  int badRoom;

  (void) strcpy (copyOfNewsgroups, newsgroups);
  badRoom = _false;
  for (ptr = strtok (copyOfNewsgroups, ", ");
       ptr != NULL;
       ptr = strtok ((char *) NULL, ", ")) {
    if (FindRoom (_findExact, ptr) == -1) {
      (void) printf ("'%s' is not a valid room name.\n", ptr);
      badRoom |= _true;
    }
  }
  return (!badRoom);
}
