/*
 * NAME
 *     Data.c -- global data
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Data.c  1.4 02 May 1992 08:59:32\n\t";
#endif

#include <stdio.h>
#include "getenvs.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "Message.h"
#include "File.h"
#include "User.h"

char *homeDir, *logname, *longname, *terminalType;
Room *rooms;
Floor *floors;
char signature[] = { _signatureMark };

char outOfMemoryMsg[] = "Out of memory.";

/* User information */
int moreDefault;		/* default for more */
int columns, lines;
int showSig = _false;		/* Print text after "-- \n" */
int seperMsg = _false;		/* Separate msgs with "--------" */
int jokes = _true;		/* Only if you appreciate humor. */

char *transferProtocol, *transferDescription, *transferFlags, *transferReadCommand, *transferEnterCommand;
char *editorName, *editorDescription, *editorFlags, *editorCommand;
char *filePager;
int transferBatch;	/* True if transfer protocol is a batch protocol */

Envs envs[] = {
  "HOME", NULL, NULL, NULL, "P", (void *)&homeDir,
  "LOGNAME", NULL, NULL, NULL, "P", (void *)&logname,
  "PATH", _defaultPath, NULL, NULL, NULL, (void *)NULL,
  "SHELL", _defaultShell, NULL, NULL, NULL, (void *)NULL,
  "PAGER", _defaultPager, NULL, NULL, "P", (void *)&filePager,
  "ORGANIZATION", _organization, NULL, NULL, NULL, (void *)NULL,
  "TERM", _defaultTerm, NULL, NULL, "P", (void *)&terminalType,
  "EDITOR", NULL, NULL, NULL, "P", (void *)&editorCommand,
  NULL, NULL, NULL, NULL, NULL, NULL,
};

/* Room by room information */
unsigned int currentFloor;
unsigned int currentRoom, previousRoom;

/* Modes of various sorts */
int more;		/* 1 = PrintArticle stops at the end of screens and
			   pages, 2 = stops after title */
int local;		/* on console, _false = remote */
int floorMode;
int expertMode;
int guest;		/* _true = no downloads, no uploads, no posting */
int finished;
FILE *dumpFile;		/* file where output is going, usually 'stdout' */

char *hdr[_hdrMax];
char *hdrFieldNames[] = {
  "From ",
  "From: ",
  "Path: ",
  "Newsgroups: ",
  "Subject: ",
  "Message-ID: ",
  "Reply-To: ",
  "References: ",
  "Date: ",
  "Expires: ",
  "Control: ",
  "Sender: ",
  "Followup-to: ",
  "Distribution: ",
  "Organization: ",
  "Lines: ",
  "Keywords: ",
  "Summary: ",
  "Approved: ",
  "File: ",
  "To: ",
  "Priority: ",
  "ContentType: ",
  "Cc: ",
  "Bcc: ",
  NULL,
};

char *months[12] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
char *days[7] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

/* File Listing information */
char *flTempDir;

int linesLeft, numLines;
