#!/bin/sh
#
# NAME
#    new-mail  --  start up mail processing for a user
#
# SYNOPSIS
#    new-mail userName
#
# DESCRIPTION
#    I use this because I haven't fixed SetUp.sh to automatically create
#    a link for the new user's mail file to forward mail to 'place'.
#

userName=$1
spoolDir=/var/mail
bbsHome=/var/spool/bbshome
place=/usr/local/bin/place

# lnName is the name of the mail file used to link to this users file
lnName=mickey

if [ "0$userName" = "0" ]
then
  echo "usage: $0 userName"
  exit 1
fi

egrep "^$userName:" /etc/passwd >/dev/null || {
  echo "$0: No such user '$userName'"
  exit 1
}

cd $spoolDir

[ -f $userName.bak ] && {
  echo "$0: Backup file $spoolDir/$userName.bak already exists."
  exit 1
}

cp $userName $userName.bak

[ -f $userName ] || {
  echo "$0: No such file or not an ordinary file, '$spoolDir/$userName'"
  exit 1
}

mkdir split
cd split

LOGNAME=$userName
HOME=$bbsHome/$userName
export LOGNAME HOME

csplit -k - "/^From /" "{98}" <../$userName

if [ -f x99 ]
then
  egrep "^From " xx99 >/dev/null && {
    echo "$0: More than 98 messages in '$spoolDir/$userName'"
    echo "$0: Messages left in $spoolDir/split"
    exit 1
  }
fi

rm xx00

for ii in xx??
do
  $place mail <$ii
done

rm xx??
cd ..
rmdir split
cd $bbsHome/$userName/mail
chown $userName active mail/*
chmod 640 active mail/*

cd $spoolDir
ln $lnName $userName
