#include <stdio.h>
#include <unistd.h>
#include <string.h>

#define _maxNameLen 8
#define _maxFullNameLen 40

char baseDir[] = "/var/spool/bbshome/";

main (argc, argv, envp)
int argc;
char **argv;
char **envp;
{
	char homeDir[sizeof(baseDir)+_maxNameLen+1];
	int status;

	if (argc != 3) {
		(void) fprintf (stderr, "usage: %s login fullName\n", argv[0]);
		exit (2);
	}
	if (strlen(argv[1]) > (size_t) _maxNameLen) {
		(void) fprintf (stderr, "%s: user name too long.\n", argv[0]);
		exit (2);
	}
	if (strlen(argv[2]) > (size_t) _maxFullNameLen) {
		(void) fprintf (stderr, "%s: full name too long.\n", argv[0]);
		exit (2);
	}

	(void) strcpy (homeDir, baseDir);
	(void) strcat (homeDir, argv[1]);

	setuid(0);
	if (fork() == 0) {
		execl ("/usr/sbin/useradd", "-gbbs", "-d", homeDir, "-s/usr/local/bin/unidel", "-c", argv[2], "-m", "-k/usr/local/lib/unidel/skel", argv[1], (char *)0);
		exit (1);
	}
	wait(&status);
	execl ("/usr/bin/passwd", "-d", argv[1], (char *)0);
}
