/*
 * NAME
 *     adm-rmail -- record size of files mailed for accounting
 *
 * DESCRIPTION
 *     I use this program to record the size of mail received from
 *     other sites for accounting.  I pay long distance to get quick
 *     mail through UUNET.
 */

#include <stdio.h>
#include <sys/stat.h>

/*
 * _fudgeFactor is an approximation of the time/bytes used up in
 * transferring the control file and dead time between files.  It is
 * added to the raw file size.  It was calculated
 *     8 seconds * 150 bytes/second
 */
#define _fudgeFactor 1200

char *logFileName = "/usr/local/lib/unidel/lib/log-rmail";
char *realRMail = "/usr/bin/rmail";

main (int argc, char **argv, char **envp)
{
  extern int errno;
  FILE *logFile;
  struct stat fileStat;
  int ii;
  char *uuName, *getenv();

  if ((argc > 1) &&(logFile = fopen (logFileName, "a")) != (FILE *) NULL) {
    if (fstat (0, &fileStat) == -1) {
      (void) fprintf (logFile, "# %s -- Could not stat input file, errno == %d\n", argv[1], errno);
    } else if (fileStat.st_mode & S_IFREG) {
      uuName = getenv ("UU_MACHINE");
      if (uuName == (char *) NULL)
	uuName = "unknown";
      for (ii = 1; ii < argc; ii ++) {
	(void) fprintf (logFile, "%ld\t%s\t%s\n",
			(fileStat.st_size + _fudgeFactor) / (argc - 1),
			argv[ii], uuName);
      }
    } else {
      (void) fprintf (logFile, "# %s -- Not a regular file, st_mode = 0x%4.4x\n",
		      argv[1], fileStat.st_mode);
    }
  }
  fclose (logFile);
  (void) execve (realRMail, argv, envp);
  /* Should not return */
  return (1);
}
