#
#  NewUser  --  auto registration for new users
#

UNIDIR=/usr/local/lib/unidel
LIBDIR=$UNIDIR/lib
BINDIR=$UNIDIR/bin
DOCDIR=$UNIDIR/doc
SECUREDIR=$UNIDIR/secure
HOMEDIRS=/var/spool/bbshome
gid=101
adminAddress=postmaster
passwdFile=/etc/passwd

trap "" 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
echo

if [ -f $DOCDIR/blurb.doc ]
then
	more $DOCDIR/blurb.doc
fi

ans=n
while [ "$ans" = "n" ]
do
  echo "
Enter your full name.  This is the name that other users around the world
will see on messages that you write.  If you are going to be using USENET,
the world wide network, it is recommended that you use your REAL name.  This
name can be changed at any time.
Full name:"
  read name
  fullName=`echo "$name" | /usr/bin/tr -d ":"`
  while [ "$ans" = "n" ]
  do
    echo "
Enter your login name or handle.  This is the name you will use when you log
into this system.  It is also the name the system knows you by, and your
mailing address on this system.  For best results, do not use periods,
spaces, colons or other special characters.  There is an 8 character limit.
You can not change this name, and it must be unique among all names on this
system.  You will have as many chances as required to pick a unique name.
Login name:"
    read name
    name=`echo "$name" | /usr/bin/tr -d ":"`
    tName=`echo "$name" | /usr/bin/tr -d ".@$#\'\"\\/"`
    loginName=`echo "$tName" | /usr/bin/tr " [A-Z]" "_[a-z]" | cut -c1-8`
    if /bin/grep "^$loginName:" $passwdFile >/dev/null
    then
      echo "We already have someone by that name, try a different spelling."
      ans=n
    else
      ans=y
    fi
  done
  echo "City, State, Zip:"
  read city
  echo "Computer type? (ex. Mac II, Compaq 386, Cray X/MP, AT Clone, etc.)"
  read computer
  echo
#  name=`echo "$name" | $BINDIR/UpLow`
#  city=`echo "$city" | $BINDIR/UpLow`
  echo "Name:      $fullName"
  echo "Login:     $loginName"
  echo "City:      $city"
  echo "Computer:  $computer"
  echo
  echo "Is this correct? ([y]/n) \c"
  read ans
done
echo "Creating user information files..."

$UNIDIR/buseradd $loginName "$fullName"

SHELL=/bin/sh
export SHELL
unset PAGER EDITOR VISUAL TERM

# We won't tell them it's not our fault :-)
echo "\nAnd Once More Just For Jokes, \c"
exec login $loginName

# in case login wasn't found.
exit 0
