/*
 *  AutoVal  --  Takes a user login, password and name as arguments and
 *               creates a passwd entry for it.  Returns the user number
 *               of the new user.
 */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pwd.h>

/*#define runReal	/* if AutoVal suid root and passwd is /etc/passwd */

#ifdef SVR2
#	define S_IXGRP 0010
#	define S_IWGRP 0020
#	define S_IRGRP 0040
#	define S_IXOTH 0001
#	define S_IWOTH 0002
#	define S_IROTH 0004

	int mkdir (path, mode)

	char *path;
	int mode;

	{
		char mkdirCommand[1024];

		strcpy (mkdirCommand, "mkdir ");
		strcat (mkdirCommand, path);
		if ((errno=system (mkdirCommand)) != 0)
			return (-1);
		chmod (path, mode);
		return (0);
	}
#endif

#define gid 102
#define _minPasswd 301
#define _maxPasswd 499
#define gecoss "0000-"
#define gecost "(0000)"
#define homeDir "/home/rspdev/ken/play/unidel/usr"
#define shell "/home/rspdev/ken/play/unidel/bin/unidel"
#define recallDir "/home/rspdev/ken/play/unidel/usr"
#define setupDefaultFiles "/home/rspdev/ken/play/unidel/bin/SetUp"
#define _passwdFile "/home/rspdev/ken/play/unidel/lib/passwd"

main (argc, argv)

int argc;
char argv[];

{
    FILE *passwdFile;
    char uidFound[_maxPasswd];
    int i, status, passwdFD;
    struct passwd *newPasswd, *aPasswd, *fgetpwent (), *getpwent ();
    char workString[512], pw_name[16], pw_passwd[16], pw_age[512];
    char pw_comment[512], pw_gecos[512], pw_dir[512], pw_shell[512];

    if (argc != 1) {
        printf ("0 Usage:  %s <passwdLine\n", argv[0]);
        exit (1);
    }
    if ((aPasswd = fgetpwent (stdin)) == NULL) {
        printf ("0 Bad passwd format.\n");
        exit (1);
    }
    newPasswd = (struct passwd *) malloc (sizeof (struct passwd));
    newPasswd -> pw_name = pw_name;
    newPasswd -> pw_passwd = pw_passwd;
    newPasswd -> pw_age = pw_age;
    newPasswd -> pw_comment = pw_comment;
    newPasswd -> pw_gecos = pw_gecos;
    newPasswd -> pw_dir = pw_dir;
    newPasswd -> pw_shell = pw_shell;
    strcpy (newPasswd -> pw_name, aPasswd -> pw_name);
    strcpy (newPasswd -> pw_passwd, aPasswd -> pw_passwd);
    newPasswd -> pw_uid = aPasswd -> pw_uid;
    newPasswd -> pw_gid = aPasswd -> pw_gid;
    strcpy (newPasswd -> pw_age, aPasswd -> pw_age);
    strcpy (newPasswd -> pw_comment, aPasswd -> pw_comment);
    strcpy (newPasswd -> pw_gecos, aPasswd -> pw_gecos);
    strcpy (newPasswd -> pw_dir, aPasswd -> pw_dir);
    strcpy (newPasswd -> pw_shell, aPasswd -> pw_shell);
    if (newPasswd -> pw_uid != _minPasswd) {
		printf ("0 Bad user-id.\n");
		exit (1);
	}
    if (newPasswd -> pw_gid != gid) {
		printf ("0 Bad group-id.\n");
		exit (1);
	}
    if (strncmp (newPasswd -> pw_dir, homeDir, strlen (homeDir)) != 0) {
		printf ("0 Bad home directory.\n");
		exit (1);
	}
    if (strcmp (newPasswd -> pw_shell, shell) != 0) {
		printf ("0 Bad shell.\n");
		exit (1);
	}
    sprintf (workString, "%s/%s", recallDir, newPasswd -> pw_name);
    status = mkdir (workString, S_IREAD | S_IWRITE | S_IEXEC | S_IRGRP | S_IWGRP | S_IXGRP | S_IXOTH | S_IROTH);
    if (status != 0) {
        printf ("0 Could not create recall directory, %d.\n", errno);
        exit (1);
    }
#ifdef _runReal
    if (setuid (0) != 0) {
      printf ("0 Unable to setuid.\n");
      exit (1);
    }
#endif
    if ((passwdFile = fopen (_passwdFile, "r+")) == NULL) {
        printf ("0 Unable to open passwd file, %d.\n", errno);
        exit (1);
    }
    for (i = _minPasswd; i < _maxPasswd; i++)
        uidFound[i] = 0;
    while ((aPasswd = fgetpwent (passwdFile)) != NULL) {
		if (aPasswd -> pw_uid >= _minPasswd && aPasswd -> pw_uid < _maxPasswd)
	        uidFound[aPasswd -> pw_uid] = 1;
    }
    for (i = _minPasswd; (i < _maxPasswd) && (uidFound[i] == 1); i ++)
		;
    if (i == _maxPasswd) {
		printf ("0 No user-ids available.\n");
        fclose (passwdFile);
        exit (1);
    }
	fclose (passwdFile);
    newPasswd -> pw_uid = i;
	if ((passwdFile = fopen (_passwdFile, "a+")) != NULL) {
	    if (putpwent (newPasswd, passwdFile) != 0) {
			printf ("0 Unable to put passwd entry, %d.\n", errno);
			exit (1);
		}
	} else {
		printf ("0 Unable to open %s to append passwd.\n", _passwdFile);
		exit (1);
	}
	fclose (passwdFile);
    sprintf (workString, "%s/%s", recallDir, newPasswd -> pw_name);
#ifdef runReal
    status = chown (workString, i, gid);
    if (status != 0) {
        printf ("0 Not able to chown recall directory, %d, user-id %d.\n",
		  errno, i);
    }
#endif
    putenv ("SHELL=/bin/sh");
    sprintf (workString, "%s %s", setupDefaultFiles, newPasswd -> pw_name);
    status = system (workString);
    if (status != 0) {
        printf ("0 Unable to set up default files, %d, user-id %d.\n",
		  status, i);
        exit (1);
    }
    printf ("%d\n", i);
    return (0);
}


