#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#include "citadel.h"

extern long yourpos;
extern char *axdefs[8];
extern char *days[7];
extern char *months[12];


lookuser (usersupp)
     struct usersupp *usersupp;
{
  struct usersupp structure;
  int file;
  struct tm *tmstruct;
  long aa;
  char aaa[100];

  enter_btmp ("[Read User]");
  printf("User name: ");
  getline(aaa,29);
  if (strlen (aaa) != 0)
    {
      file=open("usersupp",O_RDWR); 
      if (file<0) 
	interr(90);
      aa=finduser(file,aaa);
      if (aa!=(-1))
	{
	  read(file,&structure,sizeof(struct usersupp));
	  tmstruct = localtime (&structure.lastcall);

	  printf ("\nUser #%d, %-26.26s", structure.eternal, 
		  structure.fullname);

	  if ((usersupp->axlevel >= 6) 
	      || (usersupp->eternal == structure.eternal))
	    printf ("(%s)\n", axdefs[structure.axlevel]);
	  else
	    printf ("\n");

	  printf ("Last login: %s %s %d %2.2d:%2.2d from %-16.16s\n",
		  days[tmstruct->tm_wday], months[tmstruct->tm_mon], 
		  tmstruct->tm_mday, tmstruct->tm_hour, 
		  tmstruct->tm_min, structure.lasthost);

	  if (usersupp->axlevel >= 6)
	    {
	      if (structure.timescalled != 0)
		printf ("Calls: %d          Posts: %d         Ratio: %d\n",
			structure.timescalled, structure.posted,
			structure.posted/structure.timescalled);

	      printf ("On today: %2.2d:%2.2d     Total: %2.2d:%2.2d      Lim/day: %2.2d:%2.2d\n",
		      structure.today/60, structure.today%60,
		      structure.online/60, structure.online%60,
		      structure.timelimit/60, structure.timelimit%60);

	      dis_regis(&structure);
	    }
	  else
	    printf ("Calls: %d      Posts: %d\n\n", structure.timescalled,
		    structure.posted);
	  readbio(structure.fullname);
	}
      else printf ("No such user.\n");
      close (file);
    }
return(0);
}


edituser (structure, usersupp)
     struct usersupp *structure;
     struct usersupp usersupp;
{
  int a,b;
  struct tm *tmstruct;

  if (usersupp.axlevel == 6)
    {
      if (structure->axlevel >= 6)
	printf ("Cannot edit an aide.\n");
    }
  else
    do 
      {

	tmstruct = localtime (&structure->lastcall);

	printf ("\nUser #%d, %s\nLast login: %s %s %d %2.2d:%2.2d from %-16.16s\n",
		structure->eternal, structure->fullname, 
		days[tmstruct->tm_wday], months[tmstruct->tm_mon], 
		tmstruct->tm_mday, tmstruct->tm_hour, tmstruct->tm_min, 
		structure->lasthost);

	if (structure->timescalled != 0)
	  printf ("Calls: %d         Posts: %d      Ratio: %d\n",
		  structure->timescalled, structure->posted,
		  structure->posted/structure->timescalled);

	printf ("On today: %2.2d:%2.2d     Total: %2.2d:%2.2d      Lim/day: %2.2d:%2.2d\n",
		structure->today/60, structure->today%60,
		structure->online/60, structure->online%60,
		structure->timelimit/60, structure->timelimit%60);

	dis_regis(structure);

	printf("Current access level: %d [%s]\n",structure->axlevel,
		axdefs[structure->axlevel]);
	printf("New level (? to list them, n for no change): ");
	a=inkey();
	if (a=='n')
	  {
	    printf ("No change\n");
	    return (0);
	  }
	if (a=='?') 
	  {
	    printf("list\n");
	    for (b=0; b<6; ++b) 
	      printf("%d %s\n",b,axdefs[b]);
	  }
	a=a-48;
      } 
  while((a<-1)||(a>5));
  printf("%d\n",a);
  switch(a) 
    {
    case 0:
      structure->timelimit = LIM0;
      printf ("Setting time limit to %d minutes.\n", LIM0);
      break;
    case 1:
      structure->timelimit = LIM1;
      printf ("Setting time limit to %d minutes.\n", LIM1);
      break;
    case 2:
      structure->timelimit = LIM2;      
      printf ("Setting time limit to %d minutes.\n", LIM2);
      break;
    default:
      if ((structure->timelimit < TIMELIM) && (structure->axlevel < 3))
	{
	  structure->timelimit = TIMELIM;
	  printf ("Setting time limit to %d minutes.\n");
	}	    
      else
	printf ("Not changing time limit.\n");
      break;
    }
  structure->axlevel=a;
  return(0);
}




/* aides can't remove other's aide status, nor can an aide */
/* set an aide bit on someone else... use useradmin for that */


userlist(usersupp) 
     struct usersupp *usersupp;
{
  int a,b,i,file;
  char aaa[100];
  long aa,cc,nrecs;
  struct usersupp tmpsupp;
  struct tm *tmstruct;

  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("No usersupp file available.\n");
      exit(1);
    }
  if (usersupp->axlevel>=6) {
printf("   ## USER NAME            LAST CALL      #CALLS #POSTS LEVEL LAST HOST\n");
printf("-----------------------------------------------------------------------------\n");
  } else {
printf("   ## USER NAME            LAST CALL      #CALLS #POSTS       LAST HOST\n");
printf("-----------------------------------------------------------------------------\n");
  }
  aa=lseek(file,0L,2);
  nrecs=(aa/sizeof(struct usersupp));
  lseek (file, 0L, 0);
	i=1;
  for (cc=0; cc<nrecs; ++cc)
    {
      read(file,&tmpsupp,sizeof(struct usersupp));
      aa=tmpsupp.lastcall;
      tmstruct=localtime(&aa);
      sprintf(aaa,"%2.2d/%2.2d/%2.2d %2.2d:%2.2d",
              (tmstruct->tm_mon+1), tmstruct->tm_mday, tmstruct->tm_year,
              tmstruct->tm_hour, tmstruct->tm_min);
    
      printf("%5ld %-20.20s %-14.14s %6d %6d ",
                tmpsupp.eternal,
                tmpsupp.fullname,
                aaa,
                tmpsupp.timescalled,
                tmpsupp.posted
                );

      if (usersupp->axlevel >= 6) {  
        if (tmpsupp.axlevel == 7)      {printf ("sys   ");}
	else if (tmpsupp.axlevel == 6) {printf ("aide  ");} 
        else if (tmpsupp.axlevel == 0) {printf ("del   ");}
        else if (tmpsupp.axlevel == 1) {printf ("new   ");}
        else if (tmpsupp.axlevel == 2) {printf ("prob  ");}
        else if (tmpsupp.axlevel == 4) {printf ("net   ");}
        else if (tmpsupp.axlevel == 5) {printf ("pref  ");}
        else                             printf ("norm  ");
       } else {
	printf ("      ");
       }
      printf ("%-16.16s\n", tmpsupp.lasthost);
	i++;
	if (i==usersupp->screenlength){
		printf("..Hit any key to continue..");
		getchar();
		back(27);
		i=1;
	}
    }

  close(file);

}

addbio(fullname)
char fullname[30];
{
	struct bio {
			char fullname[30];
	                char line1[80];
	                char line2[80];
                	char line3[80];
        	        char line4[80];
			char line5[80];
 	             } bio;
	int file;
	struct bio tempbio;
	long aa, cc, nrecs;
	int found=0;

	printf("\nCurrent biography reads:\n");
	readbio(fullname);
	printf("Change it (y/n): ");
	switch (yesno())
	{
		case 0:
			return;
	}
	
	printf("\nEnter five text lines below.  80 chars max per line.\n");
	getline(&bio.line1[0], 80);
	getline(&bio.line2[0], 80);
	getline(&bio.line3[0], 80);
	getline(&bio.line4[0], 80);
	getline(&bio.line5[0], 80);

	file = open ("biofile", 2);
        if (file < 0 )  {
                file = creat("biofile", 0755);
                if (file == -1) {
                        printf("\nAn internal error has occured in creating the biofile.\n");
                        exit(1);
                }
        }

	strcpy(bio.fullname, fullname);

	aa=lseek(file,0L,2); 
	nrecs=(aa/sizeof(struct bio));
	lseek (file, 0L, 0);

	for (cc=0; cc<nrecs; ++cc)
	{
  		read(file,&tempbio,sizeof(struct bio));
		if(strncmp(fullname, tempbio.fullname)==0) {
			lseek (file,(long) ((cc+1)*sizeof(bio)), 0);

			write(file,&bio,sizeof(struct bio));
			close (file);
			return;
		}
	}
	lseek(file,0L,2);
	write(file,&bio,sizeof(struct bio));
	close (file);

}

readbio(fullname)
char fullname[30];
{
	
	struct bio {
			char fullname[30];
	                char line1[80];
	                char line2[80];
                	char line3[80];
        	        char line4[80];
			char line5[80];
 	             } bio;
	int file;
	long cc;
	long aa, nrecs;

	file = open ("biofile", O_RDWR);
	if (file < 0 )  { 
		printf("\nUser does not have a biography on file.\n");
		close (file);
		return;
	}

	aa=lseek(file,0L,2); 
	nrecs=(aa/sizeof(struct bio));
	lseek (file, 0L, 0);

	for (cc=0; cc<nrecs; ++cc)
	{
  		read(file,&bio,sizeof(struct bio));
		if(strncmp(fullname, bio.fullname)==0) {
			printf("\nUser's Biography:\n");
			printf("%s\n", bio.line1);
			printf("%s\n", bio.line2);
			printf("%s\n", bio.line3);
			printf("%s\n", bio.line4);
			printf("%s\n", bio.line5);
			close (file);
			return;
		}
	}

	printf("\nUser does not have a biography on file.\n");
	close (file);

}
