/* Cit/UX 3.11 userlist routine, modified for Sunset, pirmann 10/24/92 */

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include "citadel.h"
#include "sysconfig.h"

struct tm *localtime();

main()
{
  int a,b,file;
  char aaa[100];
  long aa,cc,nrecs;
  struct usersupp usersupp;
  struct tm *tmstruct;
  
  chdir (BBSDIR);
  
  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("No usersupp file available.\n");
      exit(1);
    }

printf("   ## USER NAME            LAST CALL      #CALLS #POSTS LEVEL LAST HOST\n");
printf("-----------------------------------------------------------------------------\n");

  aa=lseek(file,0L,2);
  nrecs=(aa/sizeof(struct usersupp));
  lseek (file, 0L, 0);
  for (cc=0; cc<nrecs; ++cc)
    {
      read(file,&usersupp,sizeof(struct usersupp));
      aa=usersupp.lastcall;
      tmstruct=localtime(&aa);
      sprintf(aaa,"%2.2d/%2.2d/%2.2d %2.2d:%2.2d",
	      (tmstruct->tm_mon+1), tmstruct->tm_mday, tmstruct->tm_year,
	      tmstruct->tm_hour, tmstruct->tm_min);
      
      printf("%5ld %-20.20s %-14.14s %6d %6d ",
		usersupp.eternal,
		usersupp.fullname,
		aaa,
		usersupp.timescalled,
		usersupp.posted
		);

	if (usersupp.axlevel == 6)      {printf ("aide  ");} 
        else if (usersupp.axlevel == 0) {printf ("del   ");}
        else if (usersupp.axlevel == 1) {printf ("new   ");}
        else if (usersupp.axlevel == 2) {printf ("prob  ");}
        else if (usersupp.axlevel == 4) {printf ("net   ");}
        else if (usersupp.axlevel == 5) {printf ("pref  ");}
        else if (usersupp.axlevel == 7) {printf ("sysop ");}
	else                             printf ("      ");

      printf ("%-16.16s\n", usersupp.lasthost);
    }

  close(file);
  exit(0);

}

