/* ulog.c */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"

extern struct usersupp usersupp;
extern long logintime, timetoday;
extern char mytty[9];

ulog(fullname, lastcall, mytty, stat, lasthost)
     char lasthost[17];
     int stat;
     char fullname[30];
     long lastcall;
     char mytty[9];
{
  struct tm *tmstruct, *tmstruct2;
  FILE *logf;
  char logline[80], logdate[7], whichlog[20];
  char login[6], logout[6], testin[6], testout[6], datein[9];
  long atime, thiscall, timeon;

  lastcall=logintime;
  tmstruct = localtime(&lastcall);
  sprintf (login,"%2.2d:%2.2d", tmstruct->tm_hour, tmstruct->tm_min);

  login[6] = '\0';
  strcpy (testin, login);

  sprintf (datein, "%2.2d/%2.2d/%2.2d",
	   (tmstruct->tm_mon+1),
	   tmstruct->tm_mday,
	   tmstruct->tm_year);
  sprintf (logdate, "%2.2d%2.2d%2.2d", (tmstruct->tm_mon+1), tmstruct->tm_mday,
	   tmstruct->tm_year);

  datein[9] = '\0';
  logdate[7] = '\0';
  
  time(&atime);
  
  tmstruct2 = localtime (&atime);
  if ((strncmp(lasthost, "(unk", 4)) || (stat == 4))
    sprintf (logdate, "%2.2d%2.2d%2.2d", (tmstruct2->tm_mon+1), 
	     tmstruct2->tm_mday, tmstruct2->tm_year);

  sprintf (logout,"%2.2d:%2.2d", tmstruct2->tm_hour, tmstruct2->tm_min);
  logout[6] = '\0';
  strcpy (testout, logout);

  if (stat != 3) 
    thiscall = ((long) atime - (long) lastcall) / 60;

if (stat == 5) /* new user's first call */
  sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s (%d) NEW\n",
         fullname, mytty, lasthost, datein, login, logout, thiscall);
else
if (stat == 4) /* timelimit */
  sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s (%d) LIMIT\n",
         fullname, mytty, lasthost, datein, login, logout, thiscall);
else
if (stat == 3) /* username "off" */
  sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s OFF\n",
         fullname, mytty, lasthost, datein, login, logout);
else
if (stat == 2) /* sleeping */
  sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s (%d) SLEEP\n",
         fullname, mytty, lasthost, datein, login, logout, thiscall);
else
  if (stat == 1) /* dropcarr */
   sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s (%d) DROP\n",
         fullname, mytty, lasthost, datein, login, logout, thiscall);
else /* logout normal */
  sprintf (logline, "%-20.20s %5.5s %-16.16s %8.8s %5.5s - %5.5s (%d)\n",
         fullname, mytty, lasthost, datein, login, logout, thiscall);

/* Old loggin system: */
  sprintf (whichlog, "%s.%s", LOGFILE, logdate); 

/* New system so that it can be logged to a tty */
/*  sprintf (whichlog, "%s", LOGFILE); */

  if ((logf = fopen (whichlog, "a"))!= NULL) 
    fprintf (logf, "%s", logline);
  fclose (logf);
  
  if (stat != 3) 
    {
      printf ("%s", logline);

      readyerself();
      time (&atime);
      timeon = (((long)atime - (long)logintime) / 60 ) + timetoday;
      usersupp.today=timeon;
      usersupp.online = usersupp.online + timeon; /* update total */
      writeyerself();

      if (! (((usersupp.timelimit - usersupp.today) % 60 < 0) && 
	     ((usersupp.timelimit - usersupp.today) / 60 <= 0)))
	printf ("\nYou have %dh %dm remaining today.\n", 
		(usersupp.timelimit-usersupp.today)/60,
		(usersupp.timelimit-usersupp.today)%60);
    }
  return (0);
}

badpw (fullname, mytty, lasthost, tried)
     char lasthost[16];
     char fullname[30];
     char mytty[9];
     char tried[20];
{
  FILE *logf;
  long atime;
  struct tm *tmstruct;
  char datein[9],tdate[9], whichlog[20], logdate[7];
  char logline[80], itime[6], ttime[6];
  
  time(&atime);
  tmstruct = localtime(&atime);

  sprintf (datein, "%2.2d/%2.2d/%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);
  sprintf (logdate, "%2.2d%2.2d%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);

  datein[9] = '\0';
  logdate[7] = '\0';
  strcpy (tdate, datein);

  sprintf (itime,"%2.2d:%2.2d", tmstruct->tm_hour, tmstruct->tm_min);
  itime[6] = '\0';
  strcpy (ttime, itime);

  sprintf (logline, "Badpw : %-18.18s %5.5s %-16.16s %8.8s %5.5s\n",
	   fullname, mytty, lasthost, datein, ttime);
 /* Old Loggin system.. */ 
/*   sprintf (whichlog, "%s.%s", LOGFAIL, logdate); */

 /* NEW LOGGIN SYSTEM */
sprintf (whichlog, "%s", LOGFAIL);

  if ((logf = fopen (whichlog, "a")) != NULL) 
    fprintf (logf, "%s", logline);
  fclose (logf);

  return(0);
}

inlog ()
{
  FILE *logf;
  struct tm *tmstruct;
  char datein[9], whichlog[20], logdate[7];
  char logline[80], itime[6];
  
  tmstruct = localtime(&usersupp.lastcall);

  sprintf (datein, "%2.2d/%2.2d/%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);
  sprintf (logdate, "%2.2d%2.2d%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);
  sprintf (itime,"%2.2d:%2.2d", tmstruct->tm_hour, tmstruct->tm_min);

  datein[9] = '\0';
  logdate[7] = '\0';
  itime[6] = '\0';

 /* Old logging system.. */ 
/*  sprintf (logline, "Login : %-18.18s %5.5s %-16.16s %8.8s %5.5s (%d)\n",
	   usersupp.fullname, mytty, usersupp.lasthost, datein, itime,
	   usersupp.timescalled); */

/*  sprintf (whichlog, "%s.%s", LOGINLOG, logdate); */


 /* NEW LOGGIN SYSTEM */
  sprintf (logline, "Login : %-18.18s %5.5s %-16.16s %8.8s %5.5s (%d)\n",
	   usersupp.fullname, mytty, usersupp.lasthost, datein, itime,
	   usersupp.timescalled);
  sprintf (whichlog, "%s", LOGINLOG);

  if ((logf = fopen (whichlog, "a")) != NULL) 
    {
      fprintf (logf, "%s", logline);
      fclose (logf);
    }
  else
    printf ("cannot open logfile!\n");

  return(0);
}

outlog ()
{
  FILE *logf;
  struct tm *tmstruct;
  char datein[9], whichlog[20], logdate[7];
  char logline[80], logout[6];
  long atime, thiscall;

  time(&atime);
  tmstruct = localtime (&atime);

  sprintf (logout,"%2.2d:%2.2d", tmstruct->tm_hour, tmstruct->tm_min);
  logout[6] = '\0';

  tmstruct = localtime (&usersupp.lastcall);

  sprintf (datein, "%2.2d/%2.2d/%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);
  sprintf (logdate, "%2.2d%2.2d%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);

  datein[9] = '\0';
  logdate[7] = '\0';



/* Old looggin system.. */  
/*  sprintf (logline, "Logout: %-18.18s %5.5s %-16.16s %8.8s %5.5s\n",
	   usersupp.fullname, mytty, usersupp.lasthost, datein, logout); */
/*  sprintf (whichlog, "%s.%s", LOGINLOG, logdate); */


/* NEW LOGGING SYSTEM */
  thiscall = ((long) atime - (long) logintime) / 60;
  sprintf (logline, "Logout: %-18.18s %5.5s %-16.16s %8.8s %5.5s (%d)\n", usersupp.fullname, mytty, usersupp.lasthost, datein, logout, thiscall);

  sprintf (whichlog, "%s", LOGINLOG);

  if ((logf = fopen (whichlog, "a")) != NULL) 
    fprintf (logf, "%s", logline);
  fclose (logf);

  return(0);
}

