/*
 * internal uadmin routine.
 * dave pirmann@rutgers.edu 7/8/91
 */

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <curses.h>
#include <time.h>
#include "citadel.h"

struct tm *localtime();
int need_rewrite = 0;

useradmin ()
{
   char            user[29];
   long            aa, bb;
   int             file, a;
   struct usersupp usersupp;
   char oldname[26];

   printf ("User Administration\n\nEnter user name: ");
   file = open ("usersupp", O_RDONLY);
   getline (user, 29);
   setsane();
   aa = finduser (file, user);
   if (aa != (-1))
     {
       initscr ();
       read (file, &usersupp, sizeof (struct usersupp));
       pwcrypt (usersupp.password, PWCRYPT);
       close (file);

   /* display user information */
       clear ();
       refresh ();
       move (1, 0);
       printw ("1. User name\n");
       printw ("2. User number\n");
       printw ("3. Last host\n");
       printw ("4. Password\n");
       printw ("5. Time today\n");
       printw ("6. Times called\n");
       printw ("7. Messages posted\n");
       printw ("8. Time limit\n");
       printw ("9. Access level\n");
       printw ("10. Last call\n");
       for (a = 11; a <= 12; ++a)
	 {
	   move (a, 0);
	   printw ("%d.\n", a);
	 }
       for (a = 1; a <= 20; ++a)
	 display_field (&usersupp, a);
       refresh ();
       adminregis (&usersupp);
       strcpy (oldname, usersupp.fullname);
       while (1)
	 {
	   move (10, 50);
	   addstr ("Enter field number to change");
	   move (11, 50);
	   addstr ("0 to exit");
	   move (13, 50);
	   addstr ("--> _____");
	   refresh ();
	   move (13, 54);
	   refresh ();
	   gets (user);
	   refresh ();
	   a = atoi (user);
	   if (a == 0)
	     break;
	   if (a > 0) 
	     {
	       edit_field (&usersupp, a);
	       adminregis (&usersupp);
	     }
	   if (a < 0)
	     adminregis (&usersupp);
	 }

       if (need_rewrite==1) 
	 {
	   sttybbs(0);
	   move (20, 0);
	   standout();
	   addstr ("Save changes (y/n)? ");
	   standend(); 
	   refresh();
	   if (yesno()) 
	     {
	       file=open("usersupp",O_RDWR);
	       bb = finduser (file, oldname);
	       pwcrypt(usersupp.password,PWCRYPT);
	       if (bb>= 0L) write(file,&usersupp,sizeof(struct usersupp));
	       close(file);
	       move (21,1);
	       standout();
	       printf("useradmin: rewriting user hash table\n");
	       standend(); 
	       refresh();
	       write_hashtab();
	     }
	 }
       clear ();
       refresh ();
       endwin ();
       return (0);
     }  

   else
     {
       printf ("No such user.\n");
       close (file);
       return (1);
     }
 }

adminregis (userdata)
     struct usersupp *userdata;
{
  int a, b;
  char pbuf[20];

  standout ();
  move (1, 48);
  printw ("%-29s", userdata->RGname);
  move (2, 48);
  printw ("%-29s", userdata->RGaddr);
  move (3, 48);
  printw ("%-14s %2s %11s",
	  userdata->RGcity, userdata->RGstate, userdata->RGzip);
  strcpy (pbuf, userdata->RGphone);
  userdata->RGphone[0] = 0;
  for (a = 0; a < strlen (pbuf); ++a)
    {
      if ((pbuf[a] >= '0') && (pbuf[a] <= '9'))
	{
	  b = strlen (userdata->RGphone);
	  userdata->RGphone[b] = pbuf[a];
	  userdata->RGphone[b + 1] = 0;
	}
    }
  while (strlen (userdata->RGphone) < 10)
    {
      strcpy (pbuf, userdata->RGphone);
      strcpy (userdata->RGphone, " ");
      strcat (userdata->RGphone, pbuf);
    }
  move (4, 48);
  printw ("(%c%c%c) %c%c%c-%c%c%c%c               ",
	  userdata->RGphone[0], userdata->RGphone[1],
	  userdata->RGphone[2], userdata->RGphone[3],
	  userdata->RGphone[4], userdata->RGphone[5],
	  userdata->RGphone[6], userdata->RGphone[7],
	  userdata->RGphone[8], userdata->RGphone[9]);
  move (5, 48);
  printw ("%-29s", userdata->RGemail);
  standend ();
  refresh ();
  return (0);
}


display_field (userdata, fieldnum)
     struct usersupp *userdata;
     int fieldnum;
{
  struct tm *tmstruct;
  char laston[30];

  move (0, 0);
  refresh ();
  if (fieldnum < 11)
    move (fieldnum, 20);
  else
    move (fieldnum, 5);
  refresh ();
  switch (fieldnum)
    {
    case 1:
      printw ("%-30s", userdata->fullname);
      break;
    case 2:
      printw ("%-10ld", userdata->eternal);
      break;
    case 3:
      printw ("%-16s", userdata->lasthost);
      break;
    case 4:
      printw ("%-20s", userdata->password);
      break;
    case 5:
      printw ("%d", userdata->today/60);
      break;
    case 6:
      printw ("%-5d", userdata->timescalled);
      break;
    case 7:
      printw ("%-5d", userdata->posted);
      break;
    case 8:
      printw ("%-5d", userdata->timelimit);
      break;
    case 9:
      printw ("%1d", userdata->axlevel);
      break;
    case 10:
      tmstruct=localtime(&userdata->lastcall);
      sprintf(laston,"%2d/%2d/%2d",
	      (tmstruct->tm_mon+1),
	      tmstruct->tm_mday,
	      tmstruct->tm_year);
      printw ("%-20ls", laston);
      break;
    case 11:
      if (userdata->flags & US_PERM)
	addstr ("Do not scroll off          ");
      else
	addstr ("Scroll off after two months");
      break;
    case 12:
      if (userdata->flags & US_REGIS)
	addstr ("Registered with name and address ");
      else
	addstr ("Not registered                   ");
      break;
    default:
      break;
    }
  refresh ();
  return (0);
}

edit_field (userdata, fieldnum)
     struct usersupp *userdata;
     int fieldnum;
{
  char new[100];

  if (fieldnum < 10)
    {
      move (fieldnum, 20);
      addstr ("                                               ");
      move (fieldnum, 20);
      refresh ();
    }
  switch (fieldnum)
    {
    case 1:
      gets (userdata->fullname);
      need_rewrite=1;
      break;
    case 2:
      break;
    case 3:
      break;
    case 4:
      gets (userdata->password);
      need_rewrite=1;
      break;
    case 5:
      userdata->today = 0;
      need_rewrite=1;
      break;
    case 6:
      gets (new);
      userdata->timescalled = atoi (new);
      need_rewrite=1;
      break;
    case 7:
      gets (new);
      userdata->posted = atoi (new);
      need_rewrite=1;
      break;
    case 8:
      gets (new);
      userdata->timelimit = atoi (new);
      need_rewrite=1;
      break;
    case 9:
      gets (new);
      userdata->axlevel = atoi (new);
      need_rewrite=1;
      break;
    case 10:
      break;
    case 11:
      userdata->flags = (userdata->flags ^ US_PERM);
      need_rewrite=1;
      break;
    case 12:
      userdata->flags = (userdata->flags ^ US_REGIS);
      need_rewrite=1;
      break;
    default:
      break;
    }
  display_field (userdata, fieldnum);
  return (0);
}

write_hashtab() 
{
  struct usersupp u;
  int h;
  int in,out;
	
  in=open("usersupp",O_RDONLY);
  out=creat("hashtab",0600);
  while(read(in,&u,sizeof(struct usersupp))) 
    {
      h=hash(u.fullname);
      write(out,&h,sizeof(int));
    }
  close(in);
  close(out);
  return(0);
}
