/****************************************************************************/
/*                  YOUR SYSTEM CONFIGURATION                               */
/* Set all the values in this file appropriately BEFORE compiling any of the*/
/* C programs. If you are upgrading from an older version of Citadel/UX, it */
/* is vitally important that the #defines which are labelled "structure size*/
/* variables" are EXACTLY the same as they were in your old system,         */
/* otherwise your files will be munged beyond repair.                       */
/****************************************************************************/

/****************************************************************************/
/* Networking stuff
 * set NODENAME to your UUCP node name. Set HUMANNODE to the human-readable
 * name of your system.
 */

#define NODENAME	"saturn"	/* Your system's uucp nodename      */
#define HUMANNODE	"SaturnBBS"
#define NETWORKED       0               /* 1 for yes 0 for no */
/****************************************************************************/

#define LOGFILE         "logs/bbslog"
#define LOGFAIL         "logs/pwfail"
#define LOGINLOG        "logs/logins"
#define INTLOG          "logs/citlog"

#define BBSDIR		"/usr1/bbs"
/* This is the directory Citadel will reside in. */
/* referred to only by programs run outside of the front chroot */

#define PWCRYPT		142
/* Set PWCRYPT to any value between 0 and 255 for password encryption. DO
 * NOT CHANGE IT ONCE IT IS SET or your users will all be locked out.
 */

/* #define ALLOWNEW        1 */
/* old: set to 1 to allow new users, 0 to not allow new users */
/* new: touch file .nonew to not allow new users in BBSDIR */

#define MAKEROOM        4
/* minimum axlevel to create a new room */

#define LOBBYPOST       6
/* minimum axlevel to post in the lobby */

#define CREATAIDE	1
/* If CREATAIDE is set to 1, anyone who creates a class 3 (passworded) or
 * class 4 (invitation-only) room automatically becomes the room-aide for
 * that room. */

#define SLEEPING	180
/* If the program is waiting for input more than SLEEPING number of seconds,
 * Citadel will print "Sleeping? Call again." and hang up. To disable the
 * feature, set SLEEPING to 0. 900 seconds = 15 minutes */

#define TIMELIM         120
/* time limit for a normal user in minutes */
/* set to 0 to disable time limits */

#define LIM1 60     /* time limit for a level 1 user, etc */
#define LIM0 5
#define LIM2 10

#define PURGEDAY        30  
/* time in days to purge inactive users */

/* #define ENABLE_FEEDBACK /* */
/* define this if you want users to be prompted to leave feedback */

#define INITAX		1
/* New users are assigned the access level of INITAX:
 * 0 = Marked for deletion, 1 = New User, 2 = Problem User, 3 = Local User,
 * 4 = Network User, 5 = Preferred User, 6 = Aide, 7 = Sysop
 * set this value to 4 for instant validation or 1 for validation required.
 */

#define VALIDAX         3
/* set this to the axlevel to validate a user to */

#define REGISCALL	1
/* If a user has called REGISCALL times, he/she will be required to register.
 * Set this value to 0 to disable required registration.
 * NOTE: Citadel/UX still does not require user validation by the sysop. */

/*** STRUCTURE SIZE VARIABLES ***/
/* You may NOT change these six values once you set up your system.	    */
/* Do not set MAILSLOTS higher than MSGSPERRM 				    */

#define MAXROOMS	100		/* Number of rooms in system        */
#define MAILSLOTS	50		/* Number of mail slots             */
#define MSGSPERRM	200		/* Messages per room                */
#define MM_FILELEN      (50000L)        /* default size per setup.c         */
#define MM_MAIL       (5000000L)        /* this size reserved for mail only */

/*** END OF STRUCTURE SIZE VARIABLES ***/

#define TWITDETECT	1		/* 1=on, 0=off                      */
#define TWITROOM	"Garbage"	/* Name of room to send problems to */
/* If TWITDETECT is set to 1, messages posted by those designated as
 * "problem users" will automatically be moved to TWITROOM regardless of
 * what room they were posted in.
 */

/*
Wiz Net: Shag says, "no... stupid-20, fluff-30, serious-40, high-50/60, and
mail-1,000,000 ;)"
*/
