/* usersupp purge utility. */
/* fixed for Sunset, pirmann 10/24/92 */
/* set PURGEDAY in sysconfig.h before compiling this */
/* and make sure the BBSUID/GID is set in front.h */

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include "citadel.h"
#include "cctype.h"
#include "front.h" /* contains UID info */

#define CLN PURGEDAY*24*60*60

#include "hash.h"

main()
{
  chdir (BBSDIR);
  system ("cp usersupp ./tmp/usersupp.bak");
  userpurge();
  exit (0);
}

write_hashtab() 
{
  struct usersupp u;
  int h;
  int in,out;
	
  in=open("usersupp",O_RDONLY);
  out=creat("hashtab",0644);
  while(read(in,&u,sizeof(struct usersupp)))
    {
      h=hash(u.fullname);
      write(out,&h,sizeof(int));
    }
  close(in);
  close(out);
  chown ("hashtab", BBSUID, BBSGID);
  chmod ("hashtab", 0644);
  return(0);
}

userpurge() 
{	
  int b,file,file2;
  struct usersupp usersupp;
  long now,call,aa;
  char ldate[9];
  
  struct tm *tmstruct;

  time(&now);
  printf("userpurge: <<  Purging user file   >>\n");
  printf("userpurge: <<  %4.4d day limit      >>\n", PURGEDAY);
  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("No usersupp file available.\n");
      return(1);
    }
  file2=creat("usersupp.new",0644);
  if (file2<0)
    {
      printf("Can't open the new file.\n");
      close(file);
      return(2);
    }
  
  /* preserve the first record */
  read(file,&usersupp,sizeof(struct usersupp));
  write(file2,&usersupp,sizeof(struct usersupp));

  while (read(file,&usersupp,sizeof(struct usersupp))>0)
    {
      call=now-(usersupp.lastcall);
      if (usersupp.axlevel==0) call=CLN+2L;
      if ((usersupp.eternal == 0) || (usersupp.eternal == 16859))
	call = CLN+2L;
      if (usersupp.timescalled == 0) call = CLN+2L;
      if ((call<=CLN)||(usersupp.flags&US_PERM)||(usersupp.axlevel>=5))
	{
	  b=write(file2,&usersupp,sizeof(struct usersupp));
	  if (b<1) fprintf(stderr,"userpurge: cannot rewrite\n");
	}
      else
	{
	  aa=usersupp.lastcall;
	  tmstruct = localtime(&aa);
	  sprintf (ldate, "%d/%d/%d", tmstruct->tm_mon, 
		   tmstruct->tm_mday, tmstruct->tm_year);
	  printf ("%5ld %-20.20s %-8.8s  %5.5d  %5.5d  %-16.16s\n", 
		  usersupp.eternal, usersupp.fullname, ldate, 
		  usersupp.timescalled, usersupp.posted, usersupp.lasthost);
	}
    }
  close(file);
  close(file2);
  system("mv usersupp.new usersupp");
  chown ("usersupp", BBSUID, BBSGID);
  chmod("usersupp",0644);
  printf("userpurge: << Rewriting hash table >>\n");
  write_hashtab();
  return(0);
}

