/*
 * Citadel/UX setup program
 * for davecit code ONLY!
 *
 * *** YOU MUST EDIT sysconfig.h >BEFORE< COMPILING SETUP ***
 */

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include "citadel.h"

main(argc,argv) 
int argc;
char *argv[];
{
  int a=0;
  int loop=0;
  int MKROOM=0, MKUSER=0, MKMSG=0;
  char aaa[20];
  char option[3];
  int flag;

  printf ("Citadel/UX Davecode Setup Utility\n\n");

  if (argc == 1)
    {
      printf ("Syntax: setup -option [-option -option]\n");
      printf ("    -r   Set up room files\n");
      printf ("    -u   Set up usersupp with first user\n");
      printf ("    -m   Set up message files\n");
      exit (0);
    }
  
  for (loop=1; loop<argc; loop++)
    {
      strcpy (option, argv[loop]);
      flag = option[1];

      switch (flag) 
	{
	case 'r':
	  MKROOM = 1;
	  break;
	case 'u':
	  MKUSER = 1;
	  break;
	case 'm':
	  MKMSG = 1;
	  break;
	default:
	  printf ("Unknown option: %s\n", argv[loop]);
	  break;
	}
    }

  chdir (BBSDIR);

  if (MKMSG==1)
    cre8msg();
  if (MKROOM==1)
    cre8room();
  if (MKUSER==1)
    cre8user();

  exit(0);
}

cre8msg() 
{
  struct msgmain msgmain;
  FILE *fp;
  long aa;
  int i;
  char name1[50], name2[50];

  printf ("Creating Message Files\n----------------------\n");
  printf ("     Making directories for MMstructures and msgmains...\n");
  system ("mkdir structures");
  system ("mkdir msgmains");

  printf ("     Making msgmain and mmstructure files....\n");
  printf ("     This may take some time...\n");

  for (i=0;i<MAXROOMS;i++)
    {
      printf ("%d ", i);
      sprintf (name1, "msgmains/msgmain.%d", i);
      fp=fopen(name1,"wb");
      if (i != 1)
	for (aa=0; aa<=(MM_FILELEN+100); ++aa) 
	  putc(0,fp);	
      else 
	for (aa=0;aa<=(MM_MAIL+100);++aa) putc(0,fp);
      fclose(fp);

      msgmain.MMlowest=1L;
      msgmain.MMhighest=1L;
      msgmain.MMcurpos=0L;
      msgmain.MMflags=0;
	  
      sprintf (name2, "structures/MMstructure.%d",i);
      fp=fopen(name2,"wb");
      fwrite(&msgmain,sizeof(struct msgmain),1,fp);
      fclose(fp);
    }
  printf ("     Finished.\n");
  return(0);
}

cre8room ()
{
  int a;
  FILE *fp;
  char aaa[50];
  struct fullroom fullroom;
  struct quickroom quickroom;

  printf ("Creating Room Files\n-------------------\n");

  /* Load up a blank fullroom structure to be used for all rooms */
  for (a = 0; a < MSGSPERRM; ++a)
   {
      fullroom.FRnum[a] = 0L;
      fullroom.FRpos[a] = 0L;
   }

  printf ("     Creating directories...\n");
  system ("mkdir rooms");

  printf ("     Creating quickroom...\n");

  /* Open a new quickroom file */
  fp=fopen("quickroom","wb");
  strcpy(quickroom.QRpasswd,"");
  quickroom.QRroomaide=0L;
  quickroom.QRhighest=0L;
  quickroom.QRgen=1;
  quickroom.QRflags=QR_INUSE;

  /* Create Lobby> Mail> and Aide> */
  strcpy(quickroom.QRname,"Lobby");
  fwrite(&quickroom,sizeof(struct quickroom),1,fp);

  strcpy(quickroom.QRname,"Mail");
  fwrite(&quickroom,sizeof(struct quickroom),1,fp);
  
  strcpy(quickroom.QRname,"Aide");
  fwrite(&quickroom,sizeof(struct quickroom),1,fp);

  /* make the remaining rooms blanks */
  strcpy(quickroom.QRname,"");
  quickroom.QRflags=0;
  for (a=3; a<MAXROOMS; ++a) 
    fwrite(&quickroom,sizeof(struct quickroom),1,fp);
  fclose(fp);

  printf ("     Creating fullroom files\n");
  printf ("     This may take some time...\n");

  for (a = 0; a < MAXROOMS; ++a)
    {
      sprintf (aaa, "./rooms/fullrm%d", a);
      fp = fopen (aaa, "wb");
      fwrite (&fullroom, sizeof (struct fullroom), 1, fp);
      fclose (fp);
   }
  printf ("     Finished.\n");
  return(0);
}

cre8user() 
{
  int file;
  struct usersupp usersupp;
  long aa;

  printf ("Creating User File\n------------------\n");
  printf ("     Creating usersupp file and default user.\n");
  printf ("     Do not remove the default user.\n");

  unlink("usersupp");
  file=creat("usersupp",0666);
  usersupp.screenwidth=0;
  usersupp.eternal=0L;
  usersupp.timescalled=0;
  usersupp.posted=0;
  strcpy(usersupp.fullname,"!");
  strcpy(usersupp.password,"");
  usersupp.axlevel=4;
  write(file,&usersupp,sizeof(struct usersupp));
  close(file);

  printf ("     Creating eternal user number file...\n");

  file=creat("eternal",0666);
  chmod("eternal",0666);
  aa=1L;
  write(file,&aa,4);
  close(file);
  printf ("     Finished.\n");
  return (0);
    
}



