/* More Citadel/UX routines...
 * unlike routines.c, some of these DO use global variables.
 */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif

#include "citadel.h"

long atol();
long lseek();
long finduser();

extern int unseen;
extern int curr_rm;
extern int ugnum;
extern long uglsn, timetoday;
extern struct quickroom quickroom;
extern struct usersupp usersupp;
extern struct fullroom fullroom;
extern char temp[];
extern char *axdefs[8];

eopen(name,mode)
     char *name;
     int mode; 
{
  int ret;
  ret=open(name,mode);
  if (ret<0) 
    {
      fprintf(stderr,"Cannot open file '%s', mode=%d\n",name,mode);
      interr(1);
    }
  return(ret);
}

pwcrypt(text,code)
     char text[];
     int code; 
{
  int a;
  for (a=0; a<strlen(text); ++a) 
    text[a]=(text[a]^(((code|128)^a)&0xFF));
  return(0);
}

int room_prompt(qrptr)	/* return proper room prompt character */
     struct quickroom *qrptr; 
{
  int a;
  a='>'; 
  if ((qrptr->QRflags)&QR_DIRECTORY) 
    a=']';
  if ((a==']')&&((qrptr->QRflags)&QR_NETWORK)) 
    a='}';
  if ((a=='>')&&((qrptr->QRflags)&QR_NETWORK)) 
    a=')';
  return(a);
}

updatels() 	/* make all messages old in current room */
{
  int a;

  readyerself();
  storeug();
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm])
      usersupp.lastseen[curr_rm]=fullroom.FRnum[a];
  if (curr_rm==1)         /* if mail room, do it a little differently... */
    usersupp.lastseen[1]=usersupp.mailnum[MAILSLOTS-1];
  writeyerself();
}

updatepartial() 	/* make SOME messages old in current room */
{
  int a;

  readyerself();
  storeug();
  for (a=0; a<unseen; ++a)
    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm])
      usersupp.lastseen[curr_rm]=fullroom.FRnum[a];
  if (curr_rm==1)         /* if mail room, do it a little differently... */
    usersupp.lastseen[1]=usersupp.mailnum[MAILSLOTS-1];
  writeyerself();
}

storeug() 	/* store <u>ngoto information */
{
  ugnum=curr_rm;
  uglsn=usersupp.lastseen[curr_rm];
  return(0);
}

getline(string,lim)	/* Gets a line from the terminal */
     char string[];	/* Pointer to string buffer */
     int lim;		/* Maximum length - if negative, no-show */
{
  int a,b; 
  char flag;
  flag=0;
  
  if (lim<0) 
    { 
      lim=(0-lim); 
      flag=1; 
    }
  strcpy(string,"");
 GLA:
  a=inkey();
  a=(a&127);
  if ((a==8)&&(strlen(string)==0)) 
    goto GLA;
  if ((a!=13)&&(a!=8)&&(strlen(string)==lim)) 
    goto GLA;
  if ((a==8)&&(string[0]!=0)) 
    {
      string[strlen(string)-1]=0;
      putc(8,stdout); 
      putc(32,stdout); 
      putc(8,stdout); 
      goto GLA; 
    }
  if ((a==13)||(a==10)) 
    {
      putc(13,stdout);
      putc(10,stdout); 
      return(0); 
    }
  b=strlen(string);
  string[b]=a;
  string[b+1]=0;
  if (flag==0)
    putc(a,stdout);
  if (flag==1)
    putc('*',stdout);
  goto GLA;
}

delete_message(delnum) /* Delete message from current room */
     long delnum; 
{
  int file,a,b;
  char aaa[100];

  if (curr_rm==1) 
    {
      printf("Can't delete mail.\n");
      return(1); 
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=eopen(aaa,O_RDWR);
  a=read(file,&fullroom,sizeof(struct fullroom));
  if (a<1) 
    interr(79); 
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]==delnum) 
      {
	fullroom.FRnum[a]=0L;
	fullroom.FRpos[a]=0L;
      }
  lseek(file,0L,0);
  a=write(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(80);
  close(file);
  file=eopen("quickroom",O_RDWR);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  b=read(file,&quickroom,sizeof(struct quickroom));
  if (b<1)
    interr(82);
  quickroom.QRhighest=0L;
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]>quickroom.QRhighest)
      quickroom.QRhighest=fullroom.FRnum[a];
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  b=write(file,&quickroom,sizeof(struct quickroom));
  if (b<1) 
    interr(83);
  close(file);
  printf("Message deleted.\n");
  return(0);
}

upload(c)	/* c = upload mode */
     int c; 
{
  char buf[151],aaa[100],bbb[60],ccc[60];
  int a,b,file;
  long cc;
  FILE *fp;

  enter_btmp ("[Upload]");
  if (((quickroom.QRflags&QR_DIRECTORY)==0) || 
      ((quickroom.QRflags&QR_UPLOAD)==0) ) 
    {
      printf("Not in this room.\n");
      return(1);
    }
  if (usersupp.axlevel < 3) 
    {
      printf("Need higher access to upload.\n");
      return(1);
    }
  printf("Enter filename: ");
  getline(aaa,15);
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]=='/') aaa[a]='_';
      if (aaa[a]==';') aaa[a]=0;
      if (aaa[a]=='&') aaa[a]=0;
    }
  sprintf(bbb,"./files/%s/%s",quickroom.QRdirname,aaa);
  file=open(bbb,O_RDONLY);
  if (file>(-1)) 
    {
      printf("'%s' already exists.\n",aaa);
      close(file);
      return(1);
    }
  printf("Enter a short description of the file:\n: ");
  getline(buf,150);
  file=creat(bbb,0666);
  if (file<0) 
    {
      printf("Can't create that file?\n");
      return(1); 
    }
  if (c>0) 
    {
      close(file);
      unlink(bbb);
    }
  switch(c) 
    {
    case 0:
      a=0;
      printf("Receiving %s - press Ctrl-D to end.\n",bbb);
      do 
	{
	  b=inkey(); 
	  if (b==13) 
	    {
	      b=10; 
	      printf("\r"); 
	    }
	  if (b!=4)
	    { 
	      printf("%c",b); 
	      write(file,&b,1); 
	    }
	} 
      while(b!=4);
      close(file);
      a=0;
      break;
    case 1:
      sprintf(bbb,"cd ./files/%s; rx %s", quickroom.QRdirname,aaa);
      a=system(bbb);
      break;
    case 2:
      sprintf(bbb,"cd ./files/%s; kermit -ria %s", quickroom.QRdirname,aaa);
      a=system(bbb);
      break;
    case 3:
      sprintf(bbb,"cd ./files/%s; rz", quickroom.QRdirname);
      a=system(bbb);
      break;
    }
  if (a==0) 
    printf("*** Transfer successful.\n");
  else
    {
      printf("*** Transfer unsuccessful.\n");
      return(a);
    }
  sprintf(ccc,"./files/%s/filedir",quickroom.QRdirname);
  fp=fopen(ccc,"r+");
  if (fp==NULL) fp=fopen(ccc,"w");
  fseek(fp,0L,2);
  fprintf(fp,"%s %s\n",aaa,buf);
  fclose(fp);
  time(&cc);			/* put together an upload notice */
  fp=fopen(temp,"wb");
  if (fp==NULL) 
    interr(22);
  putc(255,fp);
  putc(MES_NORMAL,fp);
  putc(0,fp);
  fprintf(fp,"Psysop"); putc(0,fp);
  fprintf(fp,"T%ld",cc); putc(0,fp);
  fprintf(fp,"A%s",usersupp.fullname); putc(0,fp);
  fprintf(fp,"O%s",quickroom.QRname); putc(0,fp);
  fprintf(fp,"N%s",NODENAME); putc(0,fp); putc('M',fp);
  fprintf(fp,"NEW UPLOAD: '%s'\r %s\n",aaa,buf);
  putc(0,fp);
  fclose(fp);
  save_message(temp,buf,0,M_LOCAL);
  return(0);
}

move_message(pos)
     long pos; 
{
  char targ[20];
  int file,a,h;
  struct quickroom qtemp;

  h=curr_rm;
  pull_message(pos,temp);
  do 
    {
      curr_rm=(-1);
      printf("Enter target room: ");
      getline(targ,19);
      if (targ[0]==0)
	{
	  curr_rm = h;
	  return(1);
	}
      file=open("quickroom",O_RDONLY);
      for (a=0; a<MAXROOMS; ++a) 
	{
	  read(file,&qtemp,sizeof(struct quickroom));
	  if ((!strucmp(qtemp.QRname,targ))&&(qtemp.QRflags&QR_INUSE)) 
	    curr_rm=a;
	}
      close(file);
    } 
  while(curr_rm<0);

  gotocurr();
  save_message(temp,"",0,M_LOCAL);
  curr_rm=h;
  gotocurr();
  return(0);
}

aide_message(text) 			/* post a message in Aide> */
     char *text; 
{
  long now;
  FILE *fp;
  int hold_rm;

  hold_rm=curr_rm;
  curr_rm=2; 
  gotocurr();
  time(&now);
  fp=fopen(temp,"wb"); 
  if (fp==NULL) 
    interr(92);
  putc(255,fp);
  putc(MES_NORMAL,fp);
  putc(0,fp);
  fprintf(fp,"Psysop"); putc(0,fp);
  fprintf(fp,"T%ld",now); putc(0,fp);
  fprintf(fp,"ACitadel"); putc(0,fp);
  fprintf(fp,"OAide"); putc(0,fp);
  fprintf(fp,"N%s",NODENAME); 
  putc(0,fp);
  putc('M',fp);
  fprintf(fp,"%s\n",text);
  putc(0,fp);
  fclose(fp);
  save_message(temp,"",1,M_LOCAL);
  curr_rm=hold_rm; 
  gotocurr();
  return(0);
}

strcase(string) /* Case-converts a string */
     char string[]; 
{
  int a,b,c;
  b=0; c=0;

  for (a=0; a<strlen(string); ++a) 
    {
      if (islower(string[a])) 
	++b;
      if (isupper(string[a])) 
	++c; 
    }
  if ((b!=0)&&(c!=0)) 
    return(0);
  for (a=0; a<strlen(string); ++a) 
    {
      string[a]=toascii(string[a]);
      string[a]=ctolower(string[a]); 
    }
  string[0]=ctoupper(string[0]);
  for (a=1; a<strlen(string); ++a) 
      if (isspace(string[a-1])) 
	string[a]=ctoupper(string[a]);
  return(0);
}



sendmess(mytty) /* sends a message to a tty from "OPERATOR"*/
     char mytty[6];
{
  char totty[6];
  char l1[78], l2[78], l3[78];
  char sendstring[50];
  FILE *sendm;

  printf ("Send a message to which tty (enter as 'ttyp0') ? ");
  getline (totty,5);
  if (totty[1] != 't') 
    printf ("Please enter the ttyname in the form 'ttyp0'.\n");
  else 
    {
      printf ("Enter up to three lines of message, pressing return at the end\nof each line.  Press return on the blank lines to end.\n\n");
      printf ("1> ");
      getline (l1, 78);
      printf ("2> ");
      getline (l2, 78);
      printf ("3> ");
      getline (l3, 78);
      sprintf (sendstring, "/tmp/message.%s", totty);
      sendm = fopen(sendstring,"w");
      fprintf (sendm, "(%s on %s)\n", usersupp.fullname, mytty);
      fprintf (sendm,"%s\n%s\n%s", l1, l2, l3);
      fclose (sendm);
    }
}

daycheck(lastday)
     int lastday;
{
  long current;
  struct tm *thiscall;

  readyerself();
  time (&current); 
  thiscall = localtime (&current);

  if (lastday != thiscall->tm_yday) {
    timetoday = 0;
    usersupp.today = 0;
  }

  if (usersupp.today < 0) {
    timetoday = 0;
    usersupp.today = 0;
  }

  writeyerself();

  return(0);
}

print_system_config()
{
  printf ("\n\nThis system's UUCP nodename is   :     %s\n", NODENAME);
  printf ("This system's human name is      :     %s\n", HUMANNODE);
  if (NETWORKED)
    printf ("This system is networked.\n");
  else
    printf ("This system is not networked.\n");

  printf ("The UNIX pathname of the bbs is  :     %s\n\n", BBSDIR);
  printf ("Minimum axlevel to make rooms    :     %d (%s)\n",
	  MAKEROOM, axdefs[MAKEROOM]);
  printf ("Minimum axlevel to post in lobby :     %d (%s)\n",
	  LOBBYPOST, axdefs[LOBBYPOST]);
  printf ("Automatic roomaide assignment?   :     ");
  if (CREATAIDE) 
    printf ("Yes\n");
  else
    printf ("No\n");
  
  printf ("\nSleeping timeout                 :     %d min.\n", SLEEPING/60);
  printf ("Default user timelimit           :     %d min.\n", TIMELIM);
  printf ("Initial new user access level    :     %d (%s)\n", INITAX,
	  axdefs[INITAX]);
  printf ("Users are validated to level     :     %d (%s)\n", VALIDAX,
	  axdefs[VALIDAX]);
  if (REGISCALL)
    printf ("Users must register on call #    :     %d\n", REGISCALL);
  else
    printf ("Users are not required to register.\n");
  printf ("Unused accounts purge after      :     %d days.\n", PURGEDAY);

  if (TWITDETECT)
    printf ("Twitting is enabled.\n");
  else
    printf ("Twitting is not enabled.\n");

  printf ("\nMaximum rooms in system          :     %d\n", MAXROOMS);
  printf ("Maximum messages per room        :     %d\n", MSGSPERRM);
  printf ("Maximum mail messages per user   :     %d\n", MAILSLOTS);

  return(0);
}
