/* Citadel/UX independent routines (i.e. no global variables are used) */
/* for version 3.11 */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif

#include "citadel.h"
#include "defs.h"
#include "hash.h"

long atol();
long lseek();

extern char *days[7];
extern char *months[12];
extern char *axdefs[8];
extern char structfile[50];
extern int curr_rm;
extern int curr_line;
extern int abort_read;
extern long timetoday, logintime;
extern struct usersupp usersupp;

#include "cctype.h"

strucmp (st1,st2) /* Compares two strings without case sensitivity */
     char st1[],st2[]; 
{
  char aaa[100],bbb[100];
  int a;
  
  for (a=0; a<=strlen(st1); ++a)
    aaa[a]=ctolower(st1[a]);
  for (a=0; a<=strlen(st2); ++a) 
    bbb[a]=ctolower(st2[a]);
  return(strcmp(aaa,bbb));
}

back (spaces) /* Destructive backspace */
     int spaces; 
{
  int a;

  for (a=1; a<=spaces; ++a) 
    {
      putc(8,stdout); putc(32,stdout); putc(8,stdout);
    }
}

yesno()  /* Returns 1 for yes, 0 for no */
{
  int a;
  while (1) 
    {
      a=inkey(); 
      a=ctolower(a);
      if (a=='y') 
	{ 
	  printf("Yes\n"); 
	  return(1); 
	}
      if (a=='n') 
	{ 
	  printf("No\n"); 
	  return(0); 
	}
    }
}


getusinfo (structure)  /* configure user account */
     struct usersupp *structure; 
{
  int a; 
  char aaa[100];

  do 
    {
      a = structure->screenwidth;
      printf("Screen your screen width [%d]: ",a);
      getline(aaa,3); 
      if (aaa[0])
        a=atoi(aaa);
      if ((a<40)||(a>132))
        printf("...must be between 40 and 132.\n");
    } 
  while((a<40)||(a>132));
  structure->screenwidth=a;

  do 
    {
      a = structure->screenlength;
      printf("Screen length [%d]: ",a);
      getline(aaa,3);
      if (aaa[0])
        a=atoi(aaa);
      if ((a<20)||(a>132))
        printf("...must be between 20 and 132.\n");
    } 
  while((a<20)||(a>132));
  structure->screenlength=a;


  setyesno("Experienced Citadel user (limited help)  ",
           &structure->flags, US_EXPERT);

  setyesno("Print last old message when reading new  ",
           &structure->flags, US_LASTOLD);

  setyesno("Do not prompt after each message         ",
           &structure->flags, US_NOPROMPT);
 
  setyesno("Pause on full screen                     ",
           &structure->flags, US_PAUSE);
/*
  setyesno("[Brackets] around prompts.               ",
           &structure->flags, US_BRACKETS);*/
/*
  setyesno("Use the full message editor by default   ",
           &structure->flags, US_EDITOR); */
/*
  printf("Are you an experienced Citadel user? ");
  structure->flags=((structure->flags)|US_EXPERT);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_EXPERT);

  printf("Print last old message on New message request? ");
  structure->flags=((structure->flags)|US_LASTOLD);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_LASTOLD);

  printf("Prompt after each message? ");
  structure->flags=((structure->flags)|US_NOPROMPT);
  if (yesno()==1) 
    structure->flags=((structure->flags)^US_NOPROMPT);

  printf ("Pause each screenful of message output? ");
  structure->flags=((structure->flags)|US_PAUSE);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_PAUSE);
*/
  return(0);
}

getfield (file,string)		/* Break out next null-terminated string */
     int file; 
     char string[]; 
{
  int a,b,c;

  strcpy(string,"");
  a=0;
  do 
    {
      c=0; 
      b=read(file,&c,1);
      if (b<1) 
	{ 
	  string[a]=0; 
	  return(0); 
	}
      string[a]=c;
      ++a;
    } 
  while(c!=0); 
  return(0);
}

getstring (file,string)		/* get a line of text from a file */
     int file;                  /* ignores lines beginning with # */
     char string[]; 
{	
  int a,b,c;

  do 
    {
      strcpy(string,"");
      a=0;
      do
	{
	  c=0;
	  b=read(file,&c,1);
	  if (b<1)
	    {
	      string[a]=0; 
	      return(-1); 
	    }
	  string[a]=c;
	  ++a;
	}
      while(c!=10);
      string[a-1]=0;
    } 
  while(string[0]=='#');
  return(strlen(string));
}

pattern (search,patn)	/* Searches for patn in search string */
     char search[];
     char patn[];
{
  int a,b;

  for (a=0; a<strlen(search); ++a)
    {	
      b=strncmp(&search[a],patn,strlen(patn));
      if (b==0) 
	return(b);
    }
  return(1);
}

directory (path)
     char *path;
{
  char flnm[16];
  char comment[151];
  char tname[100];
  struct stat statbuf; 
  long aa;
  FILE *fp, *ls;

  sprintf(tname,"ls %s",path);
  ls=(FILE *)popen(tname,"r"); 
  if (ls==NULL) 
    return(1);
  printf("-----------------------------------------------------------\n");
  while (fgets(flnm,16,ls)!=NULL) 
    {
      flnm[strlen(flnm)-1]=0;
      sprintf(tname,"%s/%s",path,flnm);
      stat(tname,&statbuf);
      aa=(long)statbuf.st_size;
      sprintf(tname,"%s/filedir",path);
      fp=fopen(tname,"r");
      comment[0]=0;
      if (fp!=NULL) 
	{
	  do 
	    {
	      fgets(comment,151,fp);
	      comment[strlen(comment)-1]=0;
	      if (!strncmp(comment,flnm,strlen(flnm))) 
		goto FND;
	    } 
	  while(!feof(fp));
	FND:		
	  fclose(fp);
	}
      if (strncmp(flnm,comment,strlen(flnm)))
	comment[strlen(flnm)+1]=0;
      if (strcmp(flnm,"filedir"))
	printf("%-14s %8ld %s\n",flnm,aa,&comment[strlen(flnm)+1]);
    }
  fclose(ls);
  return(0);
}

fpgetfield (fp,string)	/* level-2 break out next null-terminated string */
     FILE *fp;
     char string[];
{
  int a,b;

  strcpy(string,"");
  a=0;
  do 
    {
      b=getc(fp);
      if (b<1) 
	{ 
	  string[a]=0;
	  return(0); 
	}
      string[a]=b;
      ++a;
    } 
  while(b!=0);
  return(0);
}


#define MORE_MSG "-- More? (q:quit, any:more) --"

/* increment():  Returns 1 and sets abort_read to true
                 if the reader wants to abort this message
                 returns 0 otherwise. */


int increment(l)
     int *l;
{
  int c;
  
  if (usersupp.flags&US_PAUSE && (++curr_line >= 22))
    { 
      printf(MORE_MSG);
      c = ctolower(getchar());
      back (strlen(MORE_MSG));
      if ( (c == 'q') || (c == 's') )
	{
	  curr_line = 1;
	  if (usersupp.flags&US_NOPROMPT) abort_read=1;
	  return(1);
	}
      else
	if (c != 10)
	  curr_line = 1;
    }
  return(0);
}

fmout2(width,fp)
     int width;
     FILE *fp;
{
  int a,b,c,real,old=0,l;
  char aaa[140];
	
  l = 1;
  strcpy(aaa,""); 
  old=255;
  c=1;            /* c is the current pos */
 FMTA2:	
  old=real; 
  a=getc(fp); 
  real=a;
  if (a<=0) 
    goto FMTEND2;
	
  if ( ((a==13)||(a==10)) && (old!=13) && (old!=10) ) 
    a=32;
  if ( ((old==13)||(old==10)) && (isspace(real)) ) 
    {
      printf("\n"); 
      if (increment()) 
	goto FMTEND2;
      c=1; 
    }
  if (a>126) 
    goto FMTA2;
  if (a>32) 
    {
      if ( ((strlen(aaa)+c)>(width-5)) && (strlen(aaa)>(width-5)) )
	{ 
	  printf("\n%s",aaa); 
	  if (increment()) 
	    goto FMTEND2;
	  c=strlen(aaa); 
	  aaa[0]=0; 
	}
      b=strlen(aaa); 
      aaa[b]=a; 
      aaa[b+1]=0; 
    }
  if (a==32)
    {
      if ((strlen(aaa)+c)>(width-5)) 
	{
	  printf("\n");
	  if (increment()) 
	    goto FMTEND2;
	  c=1;
	}
      printf("%s ",aaa); 
      ++c; 
      c=c+strlen(aaa);
      strcpy(aaa,""); 
      goto FMTA2; 
    }
  if ((a==13)||(a==10)) 
    {
      printf("%s\n",aaa);
      if (increment()) 
	goto FMTEND2;
      c=1;
      strcpy(aaa,""); 
      goto FMTA2; 
    }
  goto FMTA2;

 FMTEND2: 
  printf("\n");
  increment ();
  return(0);
}


fmout (width,fp)
     int width;
     FILE *fp;
{
  int a,b,c,real,old;
  char aaa[140];
	
  strcpy(aaa,"");
  old=255;
  c=1; /* c is the current pos */
 FMTA:	
  old=real;
  a=getc(fp); 
  real=a;
  if (a<=0) goto FMTEND;
  
  if ( ((a==13)||(a==10)) && (old!=13) && (old!=10) ) a=32;
  if ( ((old==13)||(old==10)) && (isspace(real)) ) 
    {
      printf("\n");
      c=1; 
    }
  if (a>126) 
    goto FMTA;
  if (a>32) 
    {
      if ( ((strlen(aaa)+c)>(width-5)) && (strlen(aaa)>(width-5)) )
	{
	  printf("\n%s",aaa); 
	  c=strlen(aaa); 
	  aaa[0]=0; 
	}
      b=strlen(aaa);
      aaa[b]=a;
      aaa[b+1]=0; 
    }
  if (a==32) 
    {
      if ((strlen(aaa)+c)>(width-5)) 
	{ 
	  printf("\n");
	  c=1;
	}
      printf("%s ",aaa); 
      ++c; 
      c=c+strlen(aaa);
      strcpy(aaa,"");
      goto FMTA; 
    }
  if ((a==13)||(a==10)) 
    {
      printf("%s\n",aaa);
      c=1;
      strcpy(aaa,""); 
      goto FMTA; 
    }
  goto FMTA;
  
 FMTEND:	
  printf("\n");
  return(0);
}

strproc(string)
     char string[];
{
  int a;
  char aaa[100];
  char bbb[5];

  strcpy(aaa,string);
  if (string[0]==0) 
    return(0);

/* Convert non-printable characters to blanks */
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]<32) 
	aaa[a]=32;
      if (aaa[a]>126) 
	aaa[a]=32; 
    }

/* Remove leading and trailing blanks */
  while(aaa[0]<33) 
    strcpy(aaa,&aaa[1]);
  while(aaa[strlen(aaa)-1]<33) 
    aaa[strlen(aaa)-1]=0;

/* Remove double blanks */
  bbb[1]=0;
  strcpy(string,"");
  for (a=0; a<strlen(aaa); ++a) 
    {
      if ((aaa[a]==32)&&(aaa[a+1]==32)) 
	goto PSSKP;
      bbb[0]=aaa[a];
      strcat(string,bbb);
    PSSKP:
      bbb[1]=0;
    }

/* remove characters which would interfere with the network */
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]=='!') 
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]=='@')
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]=='_') 
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]==',') 
	strcpy(&aaa[a],&aaa[a+1]);
    }
  return(0);
}

/* needed to set terminal parameters for things not controlled by
   citadel, like shell, subsystem, info system, etc */

externstty()        
{

#ifdef SUNOS
  struct termio live;

  ioctl(0, TCGETA, &live);
  live.c_iflag=live.c_iflag|ICRNL;
  ioctl(0, TCSETA, &live);
#endif

  return(0);
}

sttybbs(sflag) 
     int sflag;
{
#ifdef SUNOS
  struct termio live;

  ioctl(0,TCGETA,&live);
  live.c_iflag=ISTRIP|IXON|IXANY|ICRNL;
  live.c_oflag=OPOST|ONLCR;
  live.c_lflag=NOFLSH;
  if (sflag==1) live.c_lflag=ISIG|NOFLSH;
  live.c_line=0;
  live.c_cc[0]=15;
  live.c_cc[1]=3;
  live.c_cc[2]=8;
  live.c_cc[3]=24;
  live.c_cc[4]=1;
  live.c_cc[5]=255;
  live.c_cc[6]=0;
  live.c_cc[7]=0;
  ioctl(0,TCSETA,&live);
#else
  struct sgttyb live;

  gtty (0, &live);
  live.sg_flags |= CBREAK;
  live.sg_flags |= CRMOD;
  live.sg_flags |= NL1;
  live.sg_flags &= ~ECHO;
  if (sflag==1) live.sg_flags |= NOFLSH;
  stty (0, &live);
#endif

  return(0);
}

long finduser(file,name)
     int file;
     char *name; 
{
  FILE *fp;
  int c=0;
  int uh,fh;
  long pp;
	
  uh=hash(name);
  fp=fopen("hashtab","r");
  if (fp==NULL)
    interr(96);
  while(fread(&fh,sizeof(int),1,fp)>0) 
    {
      if (uh==fh) 
	{
	  pp=(long)c * (long)sizeof(struct usersupp);
	  lseek(file,pp,0);
	  fclose (fp); 
	  return(pp);
	} 
      ++c;
    }
  fclose(fp);
  return(-1L);
}

alias(name)		/* process alias and routing info for mail */
     char name[]; 
{
  FILE *fp;
  int a,b,file;
  char aaa[300],bbb[300];
	
  fp=fopen("network/mail.aliases","r");
  if (fp==NULL) 
    return(2);
 GNA:	
  strcpy(aaa,""); 
  strcpy(bbb,"");
  do 
    {
      a=getc(fp);
      if (a==',') a=0;
      if (a>0) 
	{ 
	  b=strlen(aaa); 
	  aaa[b]=a;
	  aaa[b+1]=0; 
	}
    }
  while(a>0);
  do
    {
      a=getc(fp);
      if (a==10) 
	a=0;
      if (a>0) 
	{ 
	  b=strlen(bbb); 
	  bbb[b]=a; 
	  bbb[b+1]=0; 
	}
    }
  while(a>0);
  if (a<0) 
    {
      fclose(fp);
      goto DETYPE;
    }
  if (strucmp(name,aaa)) 
    goto GNA;
  fclose(fp);
  strcpy(name,bbb);
  printf("*** Mail is being forwarded to %s\n",name);

 DETYPE:	/* determine local or remote type, see citadel.h */
  for (a=0; a<strlen(name); ++a) 
    if (name[a]=='!') 
      return(M_UUCP);
  for (a=0; a<strlen(name); ++a)
    if (name[a]=='@')
      for (b=a; b<strlen(name); ++b)
	if (name[b]=='.') 
	  return(M_UUCP);
  b=0;
  for (a=0; a<strlen(name); ++a) 
    if (name[a]=='@') 
      ++b;
  if (b>1) 
    {
      printf("Too many @'s in address\n");
      return(M_ERROR);
    }
  if (b==1) 
    {
      for (a=0; a<strlen(name); ++a)
	if (name[a]=='@') 
	  strcpy(bbb,&name[a+1]);
      while (bbb[0]==32) 
	strcpy(bbb,&bbb[1]);
      file=open("network/mail.sysinfo",O_RDONLY);
    GETSN:
      do 
	{
	  a=getstring(file,aaa);
	}
      while ((a>=0)&&(strucmp(aaa,bbb)));
      a=getstring(file,aaa);
      if (!strncmp(aaa,"use ",4)) 
	{
	  strcpy(bbb,&aaa[4]);
	  goto GETSN;
	}
      close(file);
      if (!strncmp(aaa,"uum",3)) 
	{
	  strcpy(bbb,name);
	  for (a=0; a<strlen(bbb); ++a) 
	    {
	      if (bbb[a]=='@') 
		bbb[a]=0;
	      if (bbb[a]==' ') 
		bbb[a]='_';
	    }
	  while(bbb[strlen(bbb)-1]=='_') 
	    bbb[strlen(bbb)-1]=0;
	  sprintf(name,&aaa[4],bbb);
	  return(M_UUCP);
	}
      if (!strncmp(aaa,"bin",3)) 
	{
	  strcpy(aaa,name);
	  strcpy(bbb,name);
	  while (aaa[strlen(aaa)-1]!='@')
	    aaa[strlen(aaa)-1]=0;
	  aaa[strlen(aaa)-1]=0;
	  while (aaa[strlen(aaa)-1]==' ') 
	    aaa[strlen(aaa)-1]=0;
	  while (bbb[0]!='@')
	    strcpy(bbb,&bbb[1]);
	  strcpy(bbb,&bbb[1]);
	  while (bbb[0]==' ')
	    strcpy(bbb,&bbb[1]);
	  sprintf(name,"%s @%s",aaa,bbb);
	  return(M_BINARY);
	}
      printf("Error in network/mail.sysinfo file\n");
      return(M_ERROR);
    }
  return(M_LOCAL);
}


/* tabooname routine added locally */
taboo(iname)
     char iname[];
{
  FILE *fopen(),*fp;
  char aaa[30],bbb[30];
  int a,taboo;

  if ((fp = fopen("tabooname","r")) == NULL) 
    interr(89);
  taboo=0;
  for (a=0; a<=strlen(iname); ++a) 
    aaa[a]=ctolower(iname[a]);
  while (fscanf(fp,"%s",bbb) != EOF) 
    {
      if (bbb[0]=='@') break;
      if (pattern(aaa,bbb)==0) taboo++;
    }
  fclose(fp);
  return(taboo);
}

getint(file)
     int file;
{
  short int a;    /* on a VAX a int is 32 bits */
  read(file,&a,2);
  return(a);
}

islocked() /* returns 1 if locked, 0 if not */
{
  int file;
  struct msgmain msgmain;

  sprintf (structfile, "structures/MMstructure.%d", curr_rm);
  file=open(structfile,O_RDONLY);
  read(file,&msgmain,sizeof(struct msgmain));
  close(file);
  if (msgmain.MMflags & MM_BUSY) 
    return(1);
  else
    return(0);
}

unlock () /* unlocks locked message base */
{
   struct msgmain  msgmain;
   FILE *fp;

   sprintf (structfile, "structures/MMstructure.%d", curr_rm);
   fp = fopen (structfile, "rb");
   fread (&msgmain, sizeof (struct msgmain), 1, fp);
   msgmain.MMflags = msgmain.MMflags & ~MM_BUSY;
   fclose (fp);
   fp = fopen (structfile, "wb");
   fwrite (&msgmain, sizeof (struct msgmain), 1, fp);
   fclose (fp);
   return (0);
}


int timecheck () 
{ 
  long curtime; 
  long timeon;

  readyerself ();
  if ((usersupp.timelimit == 0)||(usersupp.axlevel >= 6)) 
    return (0);

  time (&curtime);
  timeon = (((long)curtime - (long)logintime) / 60 ) + timetoday;
  
  usersupp.today=timeon;
  writeyerself();
  
  if ((int) timeon > usersupp.timelimit)     /* exceeded timelimit */
    {
      printf ("\nYou have exceeded your daily time limit.\n");
      printf ("Call back tomorrow.\n");
      return (1);
    }
  if (usersupp.timelimit - (int) timeon < 15)   /* < 15 minutes left */
    {
      printf ("\nYou have %d minutes left.\n\n", 
	      usersupp.timelimit - (int) timeon);
      return (0);
    }
  return(0);
}

int timeprint () 
{ 
  long curtime; 
  long timecall, timeon;
  struct tm *ft, *ct;
  readyerself ();

  time (&curtime);
  timecall = (( (long) curtime - (long) logintime) / 60 );
  timeon = timecall + timetoday; 

  ft = localtime (&curtime);
  printf ("The current time is: %2.2d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d.\n", 
	  ft->tm_mon+1, ft->tm_mday, ft->tm_year, 
	  ft->tm_hour, ft->tm_min, ft->tm_sec);

  ct = localtime (&logintime);
  printf ("You logged in at   : %2.2d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d.\n\n", 
	  ct->tm_mon+1, ct->tm_mday, ct->tm_year, 
	  ct->tm_hour, ct->tm_min, ct->tm_sec);

  printf ("You have been on   : %dh %dm this call\n", timecall/60, 
	  timecall % 60);
  printf ("You have been on   : %dh %dm total today\n\n", timeon/60, 
	  timeon % 60);

  if (usersupp.timelimit == 0)
    printf ("You have no time limit.\n");
  else 
    if (usersupp.axlevel >= 6)
      printf ("Time limits are not enforced for aides.\n");
    else 
      printf ("\nTime remaining     : %dh %dm\n",
	      (usersupp.timelimit - timeon)/60, 
	      (usersupp.timelimit - timeon)%60);
  return (0);
}


/* Displays "prompt", and sets bit offset "bit" in "item" appropriately
*/
int setyesno(prompt,item,bit)
char *prompt;
int *item,bit;
{
  int a, def;
  def = (*item & bit);
  printf("%s[%s] ",prompt,(def) ? "Yes" : "No");
  while (1) 
    {
      a=tolower(inkey());
      if (a == 13)
        a = (def != 0);
      if ((a=='y') || (a==1))
        { 
          printf("Yes\n"); 
          *item = *item | bit;
          return(1); 
        }
      if ((a=='n') || (a==0))
       { 
          printf("No\n"); 
          *item = (*item | bit) ^ bit;
          return(0); 
        }
    }
}
