/* Citadel/UX room-oriented routines */
/* 3.10 quartz */
/* routines:
   knrooms: list known rooms
   listzrooms: list zapped rooms
   editroom: aide edit room routine
   ungoto
   download
   roomdir: list room directory
   invite
   kickout
   killroom
   forget
   entroom
   gotocurr
   whoknows

   new to quartz implementation:

   room_desc: enter room description
   print_desc: print room description
   print_type: show room type info
   messstat: room message info
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#include "citadel.h"
#include "defs.h"

long atol();
long lseek();
long finduser();

extern int curr_rm;
extern int ugnum;
extern long uglsn;
extern struct quickroom quickroom;
extern struct usersupp usersupp;
extern struct fullroom fullroom;

knrooms(USgiven)
     struct usersupp *USgiven;
{
  char aaa[100];
  int a,b,c,d,file;
  struct quickroom QRscratch;

  b=1;
  printf("\n");
  printcenter("Rooms with unread messages:");
  printf("\n");
  file=open("./quickroom",O_RDONLY); 
  if (file<0) 
    return(1);
  d=0;
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) 
	interr(58);
      if (a==1) 
	QRscratch.QRhighest=USgiven->mailnum[MAILSLOTS-1];
      if ((QRscratch.QRflags & QR_INUSE)
	  && (QRscratch.QRhighest> (USgiven->lastseen[a]) )
	  && ( (a!=2) || (USgiven->axlevel>=6))
	  && (QRscratch.QRgen != (USgiven->forget[a]) )
	  && (	((QRscratch.QRflags&QR_PREFONLY)==0)
	      ||	((USgiven->axlevel)>=5))
	  && (	((QRscratch.QRflags&QR_PRIVATE)==0)
	      ||	((USgiven->axlevel)>=6)
	      ||	(QRscratch.QRgen==(USgiven->generation[a]))))
	{
	  if (d==3) 
	  {
	      printf("\n"); 
	      d=0; 
	  }
	  c=room_prompt(&QRscratch);
	  sprintf(aaa, "%s%c", QRscratch.QRname,c);
	  printf("   %-21s", aaa);
	  d++;
	}
    } 
  if (d!=0) printf("\n");
  
  d=0;

  b=1;
  printf("\n");
  printcenter("No unseen messages in:");
  printf("\n");
  lseek(file,0L,0);
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) return(1);
      if (a==1) QRscratch.QRhighest=USgiven->mailnum[MAILSLOTS-1];
      if ((QRscratch.QRflags & QR_INUSE)
	  && (QRscratch.QRhighest<=USgiven->lastseen[a])
	  && ( (a!=2) || ((USgiven->axlevel)>=6))
	  && (QRscratch.QRgen != USgiven->forget[a])
	  && (	((QRscratch.QRflags&QR_PREFONLY)==0)
	      ||	((USgiven->axlevel)>=5))
	  && (	((QRscratch.QRflags&QR_PRIVATE)==0)
	      ||	((USgiven->axlevel)>=6)
	      ||	(QRscratch.QRgen==USgiven->generation[a]))) 
	{
	  if (d==3) 
	  {
	      printf("\n"); 
	      d=0; 
	  }
	  c=room_prompt(&QRscratch);
	  sprintf(aaa, "%s%c", QRscratch.QRname,c);
	  printf("   %-21s", aaa);
	  d++;
	}
    }
  if (b!=1) 
    printf("\n");

  close(file);
  return(0);
}

listzrooms(USgiven)		/* list public forgotten rooms */
     struct usersupp *USgiven;
{
  int a,b,c,d,file;
  struct quickroom QRscratch;

  b=1;
  printf("\n   Forgotten public rooms:\n");
  file=open("./quickroom",O_RDONLY); 
  if (file<0) 
    return(1);
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) interr(58);
      if (a==1) QRscratch.QRhighest=USgiven->mailnum[MAILSLOTS-1];
      if ((QRscratch.QRflags & QR_INUSE)
	  && (QRscratch.QRgen == (USgiven->forget[a]) )
	  && ( (a!=2) || ((USgiven->axlevel)>=6))
	  && (	((QRscratch.QRflags&QR_PRIVATE)==0)
	      ||	((USgiven->axlevel)>=6)
	      ||	(QRscratch.QRgen==(USgiven->generation[a])))) 
	{
	  d=b+strlen(QRscratch.QRname)+3;
	  if (d>=(USgiven->screenwidth)) 
	    {
	      printf("\n");
	      b=1; 
	    }
	  c=room_prompt(&QRscratch);
	  printf("%s%c  ",QRscratch.QRname,c);
	  b=b+strlen(QRscratch.QRname)+3;
	}
    } 
  if (b!=1) 
    printf("\n");
  close(file);
  return(0);
}

editroom(person)                    /* .<A>ide <E>dit room */
     struct usersupp *person;
{
  int file,file2,a,b;
  char aaa[50]; 
  long aa;
  struct usersupp tempUS;

  enter_btmp ("[Edit Room]");
  if (curr_rm<2) 
    {
      printf("Can't edit this room.\n");
      return(0);
    }

  file=open("quickroom",O_RDWR);
  if (file<0) 
    interr(34);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  a=read(file,&quickroom,sizeof(struct quickroom));
  if (a<1) 
    interr(35);
  printf("Room name is currently: %s\n",quickroom.QRname);
  printf("New name <return=same>? ");
  getline(aaa,19);
  if (aaa[0]!=0) strcpy(quickroom.QRname,aaa);
  printf("This is currently a");
  if ((quickroom.QRflags&QR_PRIVATE)==0) 
    printf(" public");
  if (quickroom.QRflags&QR_PRIVATE) 
    printf(" private");
  if (quickroom.QRflags&QR_PASSWORDED) 
    printf(", passworded");
  if (quickroom.QRflags&QR_GUESSNAME) 
    printf(", guessname");
  printf(" room");
  if ((quickroom.QRflags&QR_PASSWORDED)==QR_PASSWORDED)
    printf(", password: %s",quickroom.QRpasswd);
  if (quickroom.QRflags&QR_PREFONLY) 
    printf(", preferred users only");
  printf(".\n");
  if (quickroom.QRflags&QR_DIRECTORY) 
    {
      printf("Directory room");
      if (quickroom.QRflags&QR_UPLOAD) 
	printf(", uploading allowed");
      if (quickroom.QRflags&QR_DOWNLOAD) 
	printf(", downloading allowed");
      if (quickroom.QRflags&QR_VISDIR) 
	printf(", visible directory");
      printf(".\nDirectory name: %s\n",quickroom.QRdirname); 
    }
  if (quickroom.QRflags&QR_ANONONLY)
    printf("Anonymous-only room.\n");


  quickroom.QRflags=0;
  quickroom.QRflags=QR_INUSE;            /* oooops!  We need this *on*/

  printf("New room type? <1>pub <2>guessname <3>passwd <4>inv-only : ");
  do 
    b=inkey()-48;
  while ((b<1)||(b>4));
  printf("%d\n",b);

   if (b != 1) 
     quickroom.QRflags = (quickroom.QRflags + QR_PRIVATE);
   if (b == 2) 
     quickroom.QRflags = (quickroom.QRflags + QR_GUESSNAME);
   if (b == 3) 
     quickroom.QRflags = (quickroom.QRflags + QR_PASSWORDED);

  if ((quickroom.QRflags&QR_PASSWORDED)==QR_PASSWORDED) 
    {
      printf("<return> or new password: ");
      getline(aaa,9);
      if (aaa[0]!=0) strcpy(quickroom.QRpasswd,aaa); 
    }
  if ((quickroom.QRflags&QR_PRIVATE)==QR_PRIVATE) 
    {
      printf("Cause users to forget room? ");
      if (yesno()==1) 
	{
	  ++quickroom.QRgen;
	  if (quickroom.QRgen==100) quickroom.QRgen=10; 
	}
    }

  if (person->axlevel >= 6) 
    { 	
      printf("Preferred users only? "); 
      if (yesno()==1) 
	quickroom.QRflags=(quickroom.QRflags+QR_PREFONLY);
    }

  if (person->axlevel == 7) 
    {
      printf("Directory room? ");
      if (yesno()==1) 
	{
	  quickroom.QRflags=(quickroom.QRflags+QR_DIRECTORY);
	  printf("     Directory name? ");
	  getline(quickroom.QRdirname,14);
	  printf("  Uploading allowed? ");
	  if (yesno()==1) 
	    quickroom.QRflags=(quickroom.QRflags+QR_UPLOAD);
	  printf("Downloading allowed? ");
	  if (yesno()==1) 
	    quickroom.QRflags=(quickroom.QRflags+QR_DOWNLOAD);
	  printf("  Visible Directory? ");
	  if (yesno()==1) 
	    quickroom.QRflags=(quickroom.QRflags+QR_VISDIR); 
	}
    }

  if ((person->axlevel >= 6) && (NETWORKED))
      {
	printf("Network Room? ");
	if (yesno()==1) 
	  quickroom.QRflags=(quickroom.QRflags+QR_NETWORK);
      }
  printf("<1>Normal <2>Anon-only <3>Anon-option ? ");
  do 
      a=inkey()-48;
  while((a<1)||(a>3));
  printf("%d\n",a);

  if (a==2) 
    quickroom.QRflags=(quickroom.QRflags+QR_ANONONLY);
  if (a==3) 
    quickroom.QRflags=(quickroom.QRflags+QR_ANON2);


 RANSU:	
  file2=open("usersupp",O_RDONLY);	/* (gee, thanks a lot!) */
  if (quickroom.QRroomaide>=0L) 
    {
      do 
	a=read(file2,&tempUS,sizeof(struct usersupp));
      while((a>0)&&(quickroom.QRroomaide!=tempUS.eternal));
      close(file2);
      if (a>0) 
	printf("Room aide is currently: %s\nNew ", tempUS.fullname);
    }
  else {
    printf("No room aide.\n");
    close (file2);
  }
  printf("Room aide (RETURN to leave unchanged): ");
  getline(aaa,29);
  if (aaa[0]!=0) 
    {
      file2=open("usersupp",O_RDONLY);
      aa=finduser(file2,aaa);
      read(file2,&tempUS,sizeof(struct usersupp));
      close(file2);
      if (aa==(-1L)) 
	{
	  printf("No such user.\n"); 
	  goto RANSU; 
	}
      quickroom.QRroomaide=tempUS.eternal;
    }
  printf("\n\nSave changes (y/n)? ");
  if (yesno()==0) 
    {
      lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
      b=read(file,&quickroom,sizeof(struct quickroom));
      if (b<1) 
	interr(36);
      close(file); 
      return(0);
    }
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  b=write(file,&quickroom,sizeof(struct quickroom));
  close(file);
  if (quickroom.QRflags & QR_DIRECTORY) 
    {
      sprintf(aaa,"mkdir ./files/%s",quickroom.QRdirname);
      system(aaa);
      sprintf(aaa,"./files/%s",quickroom.QRdirname);
      chmod(aaa,0777);
    }
  sprintf(aaa,"%s%c edited by %s",
	  quickroom.QRname,room_prompt(&quickroom),usersupp.fullname);
  aide_message(aaa);
  return(0);
}

ungoto() 
{
  if (ugnum==(-1)) 
    return(0);
  readyerself();
  curr_rm=ugnum;
  gotocurr();
  usersupp.lastseen[curr_rm]=uglsn;
  writeyerself();
  return(0);
}

download(c)
     int c;
{
  int a;
  char aaa[100],bbb[100];

  enter_btmp ("[Download]");
  if ((quickroom.QRflags&QR_DIRECTORY)
      &&(quickroom.QRflags&QR_DOWNLOAD)) 
    {
      printf("Enter filename: ");
      getline(aaa,15);
      for (a=0; a<strlen(aaa); ++a) 
	{
	  if (aaa[a]=='/')
	    aaa[a]='_';
	  if (aaa[a]==';')
	    aaa[a]=0;
	  if (aaa[a]=='&')
	    aaa[a]=0;
	}
      switch(c)
	{
	case 0:
	  formout(bbb);
	  break;
	case 1:	
	  sprintf(bbb,"cd files/%s; sx %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	case 2:	
	  signal(SIGQUIT,SIG_DFL);
	  sttybbs(1);
	  sprintf(bbb,"cd files/%s; cat <%s", quickroom.QRdirname,aaa);
	  system(bbb);
	  sttybbs(0);
	  unlink("core");	/* just in case the core was dumped */
	  break;
	case 3:	
	  sprintf(bbb,"cd files/%s; spew %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	case 4:	
	  sprintf(bbb,"cd files/%s; sz %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	case 5:
	  sprintf(bbb,"cd files/%s; sb %s", quickroom.QRdirname,aaa);
	  system(bbb);
          break;
	}
      putc(7,stdout);
    }
  else
    printf("Not in this room.\n");
  return(0);
}

roomdir() 
{
  char aaa[100];

  if ((quickroom.QRflags&QR_DIRECTORY) &&(quickroom.QRflags&QR_VISDIR)) 
    {
      sprintf(aaa,"./files/%s",quickroom.QRdirname);
      printf("Directory of %s!%s/%s\n",NODENAME,BBSDIR,&aaa[2]);
      directory(aaa);
    }
  else
    printf("Not in this room.\n");
  return(0);
}

invite() 	/* add a user to a private room */
{
  char aaa[31];
  int file;
  long aa;
  struct usersupp USscratch;

  if ((quickroom.QRflags&QR_PRIVATE)==0) 
    {
      printf("Not a private room.\n");
      return(0);
    }
  printf("Name of user? ");
  getline(aaa,30);
  if (aaa[0]==0) 
    return(0);
  file=open("usersupp",O_RDWR);
  if (file<0)
    interr(38);
  aa=finduser(file,aaa);
  if (aa!=(-1L)) 
    {
      read(file,&USscratch,sizeof(struct usersupp));
      lseek(file,aa,0);
      USscratch.generation[curr_rm]=quickroom.QRgen;
      USscratch.forget[curr_rm]=(-1);
      write(file,&USscratch,sizeof(struct usersupp));
    }
  else	
    printf("No such user.\n");
  close(file);
  return(0);
}

kickout() 	/* kick a user out of a private room */
{
  int file;
  char aaa[100];
  long aa;
  struct usersupp USscratch;

  if ((quickroom.QRflags&QR_PRIVATE)==0) 
    {
      printf("Not a private room.\n");
      return(0);
    }

  printf("Name of user? ");
  getline(aaa,30);
  file=open("usersupp",O_RDWR);
  if (file<0) 
    interr(40);
  aa=finduser(file,aaa);
  if (aa!=(-1L)) 
    {
      read(file,&USscratch,sizeof(struct usersupp));
      lseek(file,aa,0);
      USscratch.generation[curr_rm]=(-1);
      write(file,&USscratch,sizeof(struct usersupp));
    }
  else
    printf("No such user.\n");
  close(file);
  return(0);
}

killroom() 	/* aide command: kill the current room */
{
  int file;
  long aa;
  char aaa[100];
  char killrm [50];     /* for removing room desc */
  char temprmname[50];

  if (curr_rm<3) 
    { 
      printf("Can't kill this room.\n"); 
      return(0); 
    }

  printf("Are you sure you want to kill this room? ");
  if (yesno()==0) 
    return(0);
  file=open("quickroom",O_RDWR); 
  if (file<0)
    interr(42);
  aa=(long)curr_rm*sizeof(struct quickroom);
  lseek(file,aa,0);
  quickroom.QRflags=0;
  strcpy (temprmname, quickroom.QRname);
  strcpy (quickroom.QRname, "");
  write(file,&quickroom,sizeof(struct quickroom));
  close(file);
  sprintf(killrm,"/usr1/bbs/descs/rm%d",curr_rm);
  unlink (killrm);
  printf("Room description for this room has been removed.\n");
  sprintf(aaa,"%s%c killed by %s",
	  temprmname,room_prompt(&quickroom),usersupp.fullname);
  aide_message(aaa);
  curr_rm=0;		/* then goto the lobby */
  gotocurr();
  return(0);
}

forget() 	/* forget the current room */
{
  if (curr_rm<3) 
    {
      printf("Cannot forget this room.\n");
      return(0);
    }
  IFAIDE 
    {
      printf("Aides cannot forget rooms.\n"); 
      return(0); 
    }
  printf("Are you sure you want to forget this room? ");
  if (yesno()==0) 
    return(0);
  readyerself();
  usersupp.forget[curr_rm]=quickroom.QRgen;
  usersupp.generation[curr_rm]=(-1);
  writeyerself();
  curr_rm=0;		/* then goto the lobby */
  gotocurr();
  return(0);
}

entroom() 
{
  int a,b,c,d,file;
  char aaa[100],bbb[100];
  long bb,cc;
  struct quickroom QRscratch;

  enter_btmp ("[Create Room]");
  if (usersupp.axlevel < MAKEROOM) 
    {
      printf("You need higher access to create rooms.\n");
      return(0);
    }
  printf("Name for new room? ");
  getline(aaa,19);
  if (strlen(aaa)==0) 
    return(0);
  aaa[19]=0;
  file=open("quickroom",O_RDONLY); if (file<0) interr(62);
  b=0;
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) 
	interr(63);
      if ( (QRscratch.QRflags & QR_INUSE)
	  && (!strucmp(QRscratch.QRname,aaa)) ) 
	b=1; 
    }
  close(file);
  if (b==1) 
    {
      printf("'%s' already exists.\n",aaa);
      return(0); 
    }
  bb=(-1L);	
  file=open("quickroom",O_RDONLY);
  if (file<0)
    interr(64);
  for (a=0; a<MAXROOMS; ++a) 
    {
      cc=lseek(file,0L,1);
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1)
	interr(65);
      if (((QRscratch.QRflags&QR_INUSE)==0)&&(bb==(-1L)))
	bb=cc;
    }
  close(file);
  if (bb==(-1L)) 
    {
      printf("No space for additional rooms.\n");
      return(0);
    }
  IFNEXPERT 
    formout("messages/roomaccess");
  do 
    {
      printf("<?>Help\n<1>Public room\n<2>Guess-name room\n");
      printf("<3>Passworded room\n<4>Invitation-only room\n");
      printf("Enter room type: ");
      do 
	b=inkey();
      while (((b<'1')||(b>'4')) && (b!='?'));
      if (b=='?') 
	{
	  printf("?\n");
	  formout("messages/roomaccess");
	}
    }
  while ((b<'1')||(b>'4'));
  b=b-48;
  if (b==3) 
    {
      printf("Enter a room password: ");
      getline(bbb,9); 
    }
  printf("%d\n\042%s\042, a",b,aaa);
  if (b==1)
    printf(" public room.");
  if (b==2)
    printf(" guess-name room.");
  if (b==3)
    printf(" passworded room, password: %s",bbb);
  if (b==4)
    printf("n invitation-only room.");
  printf("\nInstall it? (y/n) : ");
  a=yesno();
  if (a==0)
    return(0);

  curr_rm=(int)(bb/sizeof(struct quickroom)); 
  file=open("quickroom",O_RDWR);
  if (file<0)
    interr(66);
  lseek(file,bb,0);
  d=read(file,&quickroom,sizeof(struct quickroom));
  if (d<1)
    interr(67);
  strcpy(quickroom.QRname,aaa);
  strcpy(quickroom.QRpasswd,"");
  if (b==3)
    strcpy(quickroom.QRpasswd,bbb);
  quickroom.QRroomaide=(-1L);
  quickroom.QRhighest=0L;
  ++quickroom.QRgen; 
  if (quickroom.QRgen==100)
    quickroom.QRgen=10;
  quickroom.QRflags=QR_INUSE;
  if (b>1)
    quickroom.QRflags=(quickroom.QRflags|QR_PRIVATE);
  if (b==2)
    quickroom.QRflags=(quickroom.QRflags|QR_GUESSNAME);
  if (b==3)
    quickroom.QRflags=(quickroom.QRflags|QR_PASSWORDED);
  if ((b>2)&&(CREATAIDE==1))
    quickroom.QRroomaide=usersupp.eternal;
  lseek(file,bb,0);
  write(file,&quickroom,sizeof(struct quickroom));
  close(file);

/* Initialize a blank fullroom structure */
  for (a=0; a<MSGSPERRM; ++a) 
    {
      fullroom.FRnum[a]=0L;
      fullroom.FRpos[a]=0L;
    }

  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDWR);
  if (file<0)
    interr(70);
  write(file,&fullroom,sizeof(struct fullroom));
  close(file);
  gotocurr();
  strcpy(aaa,quickroom.QRname); 
  strcat(aaa,"> created by ");
  strcat(aaa,usersupp.fullname);
  if (quickroom.QRflags&QR_PRIVATE)
    strcat(aaa," [private]");
  if (quickroom.QRflags&QR_GUESSNAME)
    strcat(aaa,"[guessname] ");
  if (quickroom.QRflags&QR_PASSWORDED) 
    {
      strcat(aaa,"\n Password: ");
      strcat(aaa,quickroom.QRpasswd);
    }
  aide_message(aaa);
  room_desc (curr_rm);
  return(0);
}

gotocurr() /* goto room currently in global variable curr_rm */
{
  int file,d; 
  char aaa[100];

  file=open("quickroom",O_RDONLY);
  if (file<0)
    interr(74);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  d=read(file,&quickroom,sizeof(struct quickroom));
  if (d<1)
    interr(75);
  close(file);
  if (curr_rm==1)
    {
      readmail();
      return(0);
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDONLY);
  if (file<0)
    interr(76);
  d=read(file,&fullroom,sizeof(struct fullroom));
  if (d<1)
    interr(77);
  close(file);
  return(0);
}

whoknows() 
{
  struct usersupp temp;
  int file;
  
  file=open("usersupp",O_RDONLY);
  if (file<0) return(file);
  while(read(file,&temp,sizeof(struct usersupp))>0)
    if ((quickroom.QRflags & QR_INUSE)
	&& ( (curr_rm!=2) || (temp.axlevel>=6) )
	&& (quickroom.QRgen != (temp.forget[curr_rm]) )
	&& (	((quickroom.QRflags&QR_PREFONLY)==0)
	    ||	(temp.axlevel>=5))
	&& (	((quickroom.QRflags&QR_PRIVATE)==0)
	    ||	(temp.axlevel>=6)
	    ||	(quickroom.QRgen==(temp.generation[curr_rm]))	))
      printf("%s\n",temp.fullname);
  close(file);
  return(0);
}


room_desc (currrm)
{
  char de1[78], de2[78], de3[78];
  char rmdesc[50];
  FILE *descf;
  
  enter_btmp("[Enter Roomdesc]");
  printf ("Enter up to three lines of room description, pressing return at the end\nof each line.  Press return on the blank lines to end.\n\n");
  printf ("1> ");
  getline (de1, 78);
  printf ("2> ");
  getline (de2, 78);
  printf ("3> ");
  getline (de3, 78);
  sprintf (rmdesc, "/usr1/bbs/descs/rm%d", currrm);
  descf = fopen(rmdesc,"w");
  fprintf (descf,"%s\n%s\n%s", de1, de2, de3);
  fclose (descf);
  printf ("\nDescription for %s now reads:\n %s\n %s\n %s\n\n",quickroom.QRname,de1, de2, de3);
}


print_desc (currrm, name)
{
  char rmdesc [50];
  int rmtest, file2, a;
  struct usersupp tempUS;

  printf ("Room Description for %s.\n", name);
  sprintf(rmdesc,"/usr1/bbs/descs/rm%d", currrm);
  file2 = open ("usersupp", O_RDONLY);
  if (quickroom.QRroomaide >= 0L) 
    {
      do  
	a = read (file2, &tempUS, sizeof (struct usersupp));
      while ((a > 0) && (quickroom.QRroomaide != tempUS.eternal));
      if (a > 0)
	printf ("Room aide is currently: %s\n\n",tempUS.fullname);
      else
	printf ("No room aide.\n");
    }
  close (file2);
  if ((rmtest = open(rmdesc, O_RDONLY)) > 0) 
    {
      close (rmtest);
      sprintf(rmdesc, "/bin/cat /usr1/bbs/descs/rm%d", currrm);
      system (rmdesc);
      printf ("\n");}
  else 
    printf ("There is no room description for this room.\n");
  return(0);
}

print_type (currrm)
{
   int file, file2, a;
   struct usersupp tempUS;

   file = open ("quickroom", O_RDWR);
   if (file < 0)
     interr (34);
   lseek (file, (long) (curr_rm * sizeof (struct quickroom)), 0);
   a = read (file, &quickroom, sizeof (struct quickroom));
   if (a < 1)
     interr (35);
   printf ("Room number is: %d\n",currrm);
   printf ("Room name is currently: %s\n", quickroom.QRname);
   printf ("This is currently a");
   if ((quickroom.QRflags & QR_PRIVATE) == 0)
      printf (" public");
   if (quickroom.QRflags & QR_PRIVATE)
      printf (" private");
   if (quickroom.QRflags & QR_PASSWORDED)
      printf (", passworded");
   if (quickroom.QRflags & QR_GUESSNAME)
      printf (", guessname");
   printf (" room");
   if ((quickroom.QRflags & QR_PASSWORDED) == QR_PASSWORDED)
      printf (", password: %s", quickroom.QRpasswd);
   printf (".\n");
   if (quickroom.QRflags & QR_PREFONLY)
     printf ("PREFERRED USERS ONLY.\n");
   if (quickroom.QRflags & QR_ANONONLY)
     printf ("Anonymous-only room.\n");
   file2 = open ("usersupp", O_RDONLY);
   if (quickroom.QRroomaide >= 0L)
   {
     do
       a = read (file2, &tempUS, sizeof (struct usersupp));
     while ((a > 0) && (quickroom.QRroomaide != tempUS.eternal));
     if (a > 0)
       printf ("Room aide is currently: %s\n",tempUS.fullname);
     else
       printf ("No room aide.\n");
   }
   close (file2);
   return(0);
 }


