/* registration routines moved out of routines2.c */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#include "citadel.h"


extern long yourpos;
extern char *axdefs[8];


entregis(usersupp)		/* register a user with name and address */
     struct usersupp usersupp;
{
  int file,a,b;
  char pbuf[15];
  struct usersupp tempus;

  enter_btmp ("[Registration]");
  readyerself();

 RGENTER:
  printf("\n     REAL name: ");
  getline(usersupp.RGname,29);
  printf("       Address: ");
  getline(usersupp.RGaddr,24);
  printf("     City/town: ");
  getline(usersupp.RGcity,14);
  printf ("Foreign users enter Internet country code for state.\n");
  printf("         State: ");
  getline(usersupp.RGstate,2);
  printf("      ZIP code: ");
  getline(usersupp.RGzip,10);
  printf ("U.S.A. users enter phone number in form: \"908-555-1212\".\n");
  printf("  Phone number: ");
  getline(pbuf,14);
  usersupp.RGphone[0]=0;
  for (a=0; a<strlen(pbuf); ++a) 
    if ((pbuf[a]>='0')&&(pbuf[a]<='9')) 
      {
	b=strlen(usersupp.RGphone);
	usersupp.RGphone[b]=pbuf[a]; 
	usersupp.RGphone[b+1]=0;
      }
  printf ("Please supply email address in form bbs@quartz.rutgers.edu\n");
  printf ("if you have one.\n");
  printf (" Email address: ");
  getline (usersupp.RGemail, 40);
  printf("\n");

  printf ("*** You have entered the following:\n");
  dis_regis(&usersupp);

  printf ("\nIs this correct (y/n)? ");
  if (!yesno()) 
    goto RGENTER;

  file=open("usersupp",O_RDWR);
  if (file < 0)
    interr (91);
  lseek (file, yourpos, 0);
  read (file, &tempus, sizeof (struct usersupp));
  if (tempus.eternal != usersupp.eternal)
    yourpos = finduser (file, usersupp.fullname);
  lseek (file, yourpos, 0);
  write (file, &usersupp, sizeof (struct usersupp));

  close(file);
  return(0);
}


validate(usersupp) 	/* validate new users */
     struct usersupp usersupp;
{
  struct msgmain MMtemp;
  struct usersupp UStemp;
  int file,a,b;
  int ulim;

  enter_btmp ("[Validate]");
  file=open("structures/MMstructure.0",O_RDONLY);
  if (file < 0)
    interr (94);
  read(file,&MMtemp,sizeof(struct msgmain));
  close(file);
  if ((MMtemp.MMflags&MM_VALID)==0)
    {
      printf("There are no unvalidated users.\n");
      return(0);
    }
  do 
    {
      file=open("structures/MMstructure.0",O_RDONLY);
      if (file < 0)
	interr (94);
      read(file,&MMtemp,sizeof(struct msgmain));
      close(file);
    }
  while(MMtemp.MMflags&MM_BUSY);
  file=open("structures/MMstructure.0",O_WRONLY);
  if (file < 0)
    interr (94);
  MMtemp.MMflags=MMtemp.MMflags&(~MM_VALID);
  write(file,&MMtemp,sizeof(struct msgmain));
  close(file);

  file=open("usersupp",O_RDWR);
  if ( file < 0 )
    interr (93);
  while(read(file,&UStemp,sizeof(struct usersupp))>0) 
    {
      if ((UStemp.flags & US_NEEDVALID) || ((usersupp.axlevel==7) &&
					    (UStemp.axlevel==1)))
	{
	  printf("\n\n\nUser #%-5ld \"%s\", from %-16.16s\n",
		 UStemp.eternal,UStemp.fullname,UStemp.lasthost);
	  dis_regis(&UStemp);
	  {
/* give the aides who do the validating limited choices as to the
   levels they can assign people.  Validate sets people to the value
   of VALIDAX defined in sysconfig.h */

	    printf ("\n(V)alidate, (D)elete, (S)kip? ");
	  NV: 
	    b = inkey ();
	    b = (b & 127); 
	    b = ctolower (b);
	if (b == 'v') 
	  {
	    printf ("Validate\n");
	    a = VALIDAX;
	    ulim = TIMELIM;
	    goto CONT;
	  }
	if (b == 's')
	  {
	    printf ("Skip\n");
	    a = 1;
	    ulim = usersupp.timelimit;
	    goto CONT;
	  }
	if (b == 'd')
	  {
	    printf ("Delete\n");
	    a = 0;
	    ulim = LIM0;
	    goto CONT;
	  }
	    goto NV;
	  }

	CONT:
	  UStemp.axlevel = a;
	  UStemp.timelimit = ulim;
	  UStemp.flags = (UStemp.flags & ~US_NEEDVALID);
	  printf ("Access level is now: %d (%s), Time Limit is: %d\n", 
		  UStemp.axlevel, axdefs[UStemp.axlevel], UStemp.timelimit);
	  lseek (file, (0L - sizeof (struct usersupp)), 1);
	  write (file, &UStemp, sizeof (struct usersupp));
	}
    }
  close (file);

  printf("\n*** End of registration.\n");
  return(0);
}

dis_regis(userdata)
     struct usersupp *userdata;
{
  int a,b;
  char pbuf[20];

  printf("%-29s\n",userdata->RGname);
  printf("%-29s\n",userdata->RGaddr);
  printf("%-14s %2s %6s\n",
	 userdata->RGcity,userdata->RGstate,userdata->RGzip);
  strcpy(pbuf,userdata->RGphone);
  userdata->RGphone[0]=0;
  for (a=0; a<strlen(pbuf); ++a) 
    {
    if ((pbuf[a]>='0')&&(pbuf[a]<='9')) 
      {
	b=strlen(userdata->RGphone);
	userdata->RGphone[b]=pbuf[a];
	userdata->RGphone[b+1]=0;
      }
  }
  while(strlen(userdata->RGphone)<10) 
    {
      strcpy(pbuf,userdata->RGphone);
      strcpy(userdata->RGphone," ");
      strcat(userdata->RGphone,pbuf);
    }
  printf("(%c%c%c) %c%c%c-%c%c%c%c\n",
	 userdata->RGphone[0],userdata->RGphone[1],
	 userdata->RGphone[2],userdata->RGphone[3],
	 userdata->RGphone[4],userdata->RGphone[5],
	 userdata->RGphone[6],userdata->RGphone[7],
	 userdata->RGphone[8],userdata->RGphone[9]);
  printf ("%-41s\n", userdata->RGemail);

  return(0);
}

