/* program to read regis info out of usersupp struct */

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"


main() 
{
	chdir(BBSDIR);
	readregis();
	exit(0);
}


readregis()
{
	struct usersupp regis;
	int file,a,b;
	char pbuf[11];
	
	file=open("usersupp",O_RDONLY);
	if (file<0) {
		fprintf(stderr,"cannot open usersupp file\n");
		return(1);
		}

	while(read(file,&regis,sizeof(struct usersupp))>0) {
		strcpy(pbuf,regis.RGphone);
		regis.RGphone[0]=0;
		for (a=0; a<strlen(pbuf); ++a) {
			if ((pbuf[a]>='0')&&(pbuf[a]<='9')) {
				b=strlen(regis.RGphone);
				regis.RGphone[b]=pbuf[a];
				regis.RGphone[b+1]=0;
				}
			}
		while(strlen(regis.RGphone)<10) {
			strcpy(pbuf,regis.RGphone);
			strcpy(regis.RGphone," ");
			strcat(regis.RGphone,pbuf);
			}
		printf("%5ld %-20.20s %-2s ",
			regis.eternal,regis.RGname,regis.RGstate);
		printf("(%c%c%c) %c%c%c-%c%c%c%c  ",
			regis.RGphone[0],regis.RGphone[1],regis.RGphone[2],
			regis.RGphone[3],regis.RGphone[4],regis.RGphone[5],
			regis.RGphone[6],regis.RGphone[7],regis.RGphone[8],
			regis.RGphone[9]);
		printf("%-30.30s\n", regis.RGemail);
		}
	close(file);
	return(0);
	}

