/* Quickroom Look (qrlook) for Citadel/Quartz
   modified for Sunset, pirmann 10/24/92       */

#include <fcntl.h>
#include <stdio.h>
#include "citadel.h"

main ()
{
   int file, a, b, c;
   struct quickroom quickroom;
   struct usersupp usersupp;

   FILE *fp;
   int flarp,tot,file2;

   chdir (BBSDIR);

   fp = fopen ("quickroom", "r");


printf ("\n## ROOM NAME                #POSTS   TYPE   ANON       ROOMAIDE\n");
printf ("------------------------------------------------------------------------\n");

   for (flarp = 0; flarp<MAXROOMS; flarp++)
     {
       fread (&quickroom, sizeof (struct quickroom), 1, fp);
       if (quickroom.QRhighest != 0)
	 {
	   printf ("%2.2d %-20.20s     %5ld    ", flarp, quickroom.QRname,
		   quickroom.QRhighest);
	   tot = tot+quickroom.QRhighest;

	   if ((quickroom.QRflags&QR_PRIVATE)==0)
	     printf("Pub    ");
	   if ((quickroom.QRflags&QR_PRIVATE) 
	       && !(quickroom.QRflags&QR_PASSWORDED) 
	       && !(quickroom.QRflags&QR_GUESSNAME))
	     printf("Inv    ");
	   if (quickroom.QRflags&QR_PASSWORDED)
	     printf("Pass   ");
	   if (quickroom.QRflags&QR_GUESSNAME)
	     printf("Guess  ");
	   
	   if (quickroom.QRflags&QR_ANONONLY)
	     printf("Anon       ");
	   else 
	     if (quickroom.QRflags & QR_ANON2)
	       printf ("Anon Opt   ");
	   else 
	     printf   ("           ");
	   if (quickroom.QRroomaide >= 0)
	     {
	       file2=open("usersupp",O_RDONLY);
	       do
		 a=read(file2,&usersupp,sizeof(struct usersupp));
	       while((a>0)&&(quickroom.QRroomaide!=usersupp.eternal));
	       close(file2);
	       if (a<1)
		 printf("Room aide number not found in usersupp!!\n");
	       else
		 printf("%s\n",usersupp.fullname);
	     }
	   else
	     printf ("\n");
	 }
     }

   fclose (fp);
   printf ("\n%d messages have been posted to Citadel.\n", tot);
   exit(0);
}


