/* usersupp checkusers utility. */
/* fixed for Sunset, pirmann 10/24/92 */
/* set PURGEDAY in sysconfig.h before compiling this */
/* and make sure the BBSUID/GID is set in front.h */

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include "citadel.h"
#include "cctype.h"
#include "front.h" /* contains UID info */

#define IDLEDAY 14
#define CLN IDLEDAY*24*60*60

#include "hash.h"

main()
{
  chdir (BBSDIR);
  checkusers();
  exit (0);
}

checkusers() 
{	
  int b,file;
  struct usersupp usersupp;
  long now,call,aa;
  char ldate[9];
  
  struct tm *tmstruct;

  time(&now);
  printf("The following users have not called in %d days.\n\n", IDLEDAY);
  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("No usersupp file available.\n");
      return(1);
    }
  while (read(file,&usersupp,sizeof(struct usersupp))>0)
    if (usersupp.eternal > 0)
      {
	call=now-(usersupp.lastcall);
	if (call >= CLN)
	  {
	    aa=usersupp.lastcall;
	    tmstruct = localtime(&aa);
	    sprintf (ldate, "%d/%d/%d", tmstruct->tm_mon+1, 
		     tmstruct->tm_mday, tmstruct->tm_year);
	    printf ("%5ld %-20.20s  %-8.8s  %5.5d  %s\n", 
		    usersupp.eternal, usersupp.fullname, ldate, 
		    usersupp.timescalled, usersupp.RGemail);
	  }
      }
  close(file);
  return(0);
}

