/* Citadel/UX message routines 3.11
 * 
 * contents:
 * 
 * read_message() - called by Read routines to print messages
 * send_message() - read message in temp file & store in msgmain
 * make_message() - assemble temp message file - msg editor
 * msgform()      - msg formatter / called by read_message() and others
 * pull_message() - pull message out of msgmain into temp file
 * readmsgs()     - read messages in a room
 * entmsg()       - enter a message
 * save_message() - file a message into the current room
 */

/* define SEEMID if you wish to see message ID's in header */
/* define DISABLE_MAIL if you wish to disable access to mail */

/* #define SEEMID /* */
/* #define DISABLE_MAIL /* */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <pwd.h>
#include <setjmp.h>
#include "citadel.h"
#include "defs.h"

long atol();
long lseek();
long finduser();

extern char *days[7];
extern char structfile[50], msgfile[50];
extern int curr_rm,hold_rm,twitroom,feedback_flag;
extern struct smreturn smreturn;
extern struct usersupp usersupp;
extern struct quickroom quickroom;
extern struct fullroom fullroom;
extern jmp_buf nextbuf;
extern int (*backnext())();
extern int (*backstop())();
extern char *months[];
extern char temp[];
extern int curr_line;
extern int abort_read;
extern long lastpos;
extern int unseen;
int replying;
char who_from[50];

read_message(pos)	        /* Read a message from the master file */
     long pos;			/* Position in master file */
{
  int a;
  a=setjmp(nextbuf);
  sttybbs(0);
  if ((a==1)||(a==2)) 
    {
      printf("\n\n");
      increment(); increment();
      return(a);
    }
  signal(SIGINT,(*backnext));
  signal(SIGQUIT,(*backstop));
  sttybbs(1);
  sprintf (msgfile,"msgmains/msgmain.%d", curr_rm);
  msgform(usersupp.screenwidth,pos,msgfile);
  sttybbs(0);
  return(0);
}

send_message(filename,retbuf)	/* send a message to the master file */
     char filename[];		/* tempfilename of proper message */
     struct smreturn *retbuf;	/* return information */
{
  int file,a,c,d,file2;
  long bb,cc,templen,hibytes,origpos;
  char sbuf[BUFSIZ];
  char mid[30];
  FILE *fp;
  struct msgmain msgmain;

  sprintf (structfile,"structures/MMstructure.%d",curr_rm);

  file=open(structfile,O_RDWR);
  if (file<0)
    interr(13);

  do
    {
      lseek(file,0L,0);
      a=read(file,&msgmain,sizeof(struct msgmain));
      if (a<1)
	interr(14);
      if (msgmain.MMflags & MM_BUSY) sleep(1);
    }
  while(msgmain.MMflags & MM_BUSY);

  lseek(file,0L,0);
  msgmain.MMflags=(msgmain.MMflags|MM_BUSY);
  a=write(file,&msgmain,sizeof(struct msgmain)); 
  if (a<1)
    interr(16);
  close(file);
  origpos=msgmain.MMcurpos;
  ++msgmain.MMhighest;
  sprintf(mid,"I%ld",msgmain.MMhighest);

       /* measure the message */
  file=open(filename,O_RDONLY); if (file<0) interr(17);
  templen=lseek(file,0L,2);
  close(file);
  templen=templen+(long)strlen(mid);
  ++templen;

       /* check for FF bytes */
  hibytes=0L;
  sprintf (msgfile, "msgmains/msgmain.%d", curr_rm);
  fp=fopen(msgfile,"rb");
  if (fp==NULL)
    interr(18);
  bb=fseek(fp,msgmain.MMcurpos,0);

  cc=ftell(fp);
  for (bb=0L; bb<templen; ++bb) 
    {
      if (curr_rm != 1) 
	if (cc>=MM_FILELEN)
	  cc=fseek(fp,0L,0);
      if (curr_rm == 1)
	if (cc>=MM_MAIL) 
	  cc=fseek(fp, 0L, 0);
      c=getc(fp);
      ++cc;
      if (c>127)
	++hibytes;		/* bump count if hi bit set */
    }

  fclose(fp);
  msgmain.MMlowest=msgmain.MMlowest+hibytes;

  file=open(msgfile,O_RDWR);
  if (file<0)
    interr (91);
  cc=lseek(file,msgmain.MMcurpos,0);
  file2=open(filename,O_RDONLY); if (file2<0) interr(19);
  cc=lseek(file,0L,1);
  d=read(file2,sbuf,3); 
  write(file,sbuf,d);
  write(file,mid,strlen(mid));
  d=0;
  write(file,&d,1);
  do
    {
      d=read(file2,sbuf,BUFSIZ);
      write(file,sbuf,d);
      cc=cc+(long)d;
      if (curr_rm != 1) 
	if (((long)cc)>=((long)MM_FILELEN))
	  cc=lseek(file,0L,0);
      if (curr_rm == 1) 
	 if (((long)cc)>=((long)MM_MAIL))
	   cc=lseek(file,0L,0);
    }
  while(d>0);

  msgmain.MMcurpos=lseek(file,0L,1);
  close(file2);	/* done with temp file */
  close(file);	/* done with master file */

       /* now update the message structure */
  msgmain.MMflags=msgmain.MMflags & ~MM_BUSY;
  file=open(structfile,O_RDWR);
  if (file<0)
    interr(20);
  a=write(file,&msgmain,sizeof(struct msgmain));
  if (a<1)
    interr(21);
  close(file);

  retbuf->smnumber=msgmain.MMhighest;
  retbuf->smpos=origpos;

  return(0);
}

make_message(filename,author,recipient,type,mode)
     char filename[];	       /* temporary file name */
     struct usersupp *author;  /* author's usersupp structure */
     char recipient[];	       /* NULL if it's not mail */
     int type;		       /* see MES_ types in header file */
     int mode;		       /* 0 for normal, 1 for ASCII */
{ 
  FILE *fp;
  int a,b,old;
  long aa,beg,now;
  char aaa[100];

  time(&now);
  fp=fopen(filename,"wb");
  if (fp==NULL)
    interr(22);
  putc(255,fp);
  putc(type,fp);	/* Normal or anonymous, see MES_ flags */
  putc(mode,fp);	/* Formatted or unformatted */
  strcpy(aaa,author->fullname);
  for (a=0; a<strlen(aaa); ++a) 
    {
      aaa[a]=ctolower(aaa[a]);
      if (aaa[a]==32)
	aaa[a]='_';
      if (aaa[a]=='!')
	strcpy(&aaa[a],&aaa[a+1]);
    }
  fprintf(fp,"P%s",aaa);/* path */
  putc(0,fp);		
  fprintf(fp,"T%ld",now);		/* date/time */
  putc(0,fp);
  fprintf(fp,"A%s",author->fullname);/* author */
  putc(0,fp);	
  fprintf(fp,"O%s",quickroom.QRname);/* room */
  putc(0,fp);	
  fprintf(fp,"N%s",NODENAME);	/* nodename */
  putc(0,fp);	
  fprintf(fp,"H%s",HUMANNODE);	/* human nodename */
  putc(0,fp);

  if (recipient[0]!=0)
    {
      fprintf(fp,"R%s",recipient);
      putc(0,fp);
    }
  fflush(fp);
  msgform(usersupp.screenwidth,0L,filename);
  putc('M',fp);
  if (mode==1)
    printf("(Press ctrl-d when finished)\n");
  beg=ftell(fp);
  old=1;
  if (mode==1)
    goto ME2;
 ME1:	
  a=inkey();
  a=(a&127);
  aa=ftell(fp);
  if ((a==8)&&(aa>beg)) 
    {
      back(1);
      fseek(fp,-1L,1);
      goto ME1;
    }
  if ((a<32)&&(a!=13))
    goto ME1;
  putc(a,stdout);
  if ((old==13)&&(a==13))
    goto MECR;
  putc(a,fp);
  if (a==13)
    putc(10,stdout);
  old=a;
  goto ME1;

 ME2:
  do 
    {
      a=inkey();
      if (a==255)
	a=32;
      if (a==13)
	a=10;
      if (a!=4) 
	{
	  putc(a,fp);
	  putc(a,stdout);
	}
      if (a==10)
	putc(13,stdout);
    } 
  while(a!=4);

 MECR:
  putc(0,fp);
  fseek(fp,-1L,1);
  fflush(fp);
  printf("[A]bort, [C]ontinue, [P]rint, [S]ave: ");
 MECR2:
  b=inkey();
  b=(b&127);
  b=ctolower(b);
  if (b=='a') 
    { 
      printf ("Abort Message\n");
      goto MEABT;
    }
  if (b=='c')
    {
      printf ("Continue Message\n");
      if (mode==0)
	goto ME1;
      if (mode==1)
	goto ME2; }
  if (b=='s')
    {
      printf("Save Message\n");
      goto MEFIN;
    } 
  if (b=='p')
    {
      printf("Print formatted\n");
      curr_line=1;
      msgform(usersupp.screenwidth,0L,filename);
      goto MECR;
    }
  goto MECR2;

 MEFIN:
  putc(0,fp);
  fclose(fp);
  return(0);
  
 MEABT:
  printf("Are you sure? ");
  if (yesno()==0)
    goto ME1;
  fseek(fp,0L,0);
  putc(0,fp);
  putc(0,fp);
  fclose(fp);
  return(2);
}

msgform(width,spos,mfile)
     int width;
     long spos;
     char *mfile;
{
  struct tm *tm;
  int a,b,e,mtype,aflag;
  char bbb[100];
	char aaa[100];
  FILE *fp;
  long now;
  char *strchr();

  fp=fopen(mfile,"rb");
  if (fp==NULL)
    return(1);
  fseek(fp,spos,0);
  e=getc(fp);
  if (e!=255) 
    {
      printf("*** CANNOT LOCATE MESSAGE / pos=%ld\n",spos);
      return(1);
    }
  mtype=getc(fp);
  aflag=getc(fp);
  printf("\n   ");
  increment();
  if (mtype==MES_ANON)
    printf("***** "); 
  if (mtype==MES_AN2)
    printf("<anonymous> ");
  do
    {
      b=getc(fp);
      if (b=='M')
	{
	  printf("\n");
	  increment();
	  if (aflag!=1)
	    fmout2(width,fp);
	  else
	    while(a=getc(fp), a>0)
	      {
		putc(a,stdout);
		if (a==13)
		  putc(10,stdout);
	      }
	}
      if ((b!='M')&&(b>0))
	fpgetfield(fp,bbb);

#ifdef SEEMID
      if (b=='I')
	    printf("(#%d-%s) ",curr_rm,bbb);
#endif
      if ( (mtype!=MES_ANON && mtype!=MES_AN2)
	  || (usersupp.axlevel >= 6)
	  || (usersupp.eternal == quickroom.QRroomaide) ) 
	{
	  if (b=='A') 
	    {
	      printf("from %s ",bbb);
	      strcpy (who_from,bbb);
	    }
/*	  if ((b=='N')&&(strucmp(bbb,NODENAME))&&(curr_rm==1))
	    printf("@%s ",bbb);*/
/*	  if ((b=='H')&&(strucmp(bbb,HUMANNODE)))
	    printf("(%s) ",bbb);*/
	  if ((b=='O')&&(strucmp(bbb,quickroom.QRname)))
	    printf("in %s> ",bbb);
	  if ((b=='N')&&(quickroom.QRflags&QR_NETWORK))
	    printf("@%s ",bbb);
	  if (b=='R')
	    printf("to %s ",bbb);
	  if (b=='T') 
	    {
	      now=atol(bbb);
	      tm=(struct tm *)localtime(&now);
	      sprintf(bbb,"%s %s", days[tm->tm_wday], asctime(tm));
	      bbb[strlen(bbb)-1]=0;
	      printf("%s ",&bbb[4]);
	    }
	}
    }
  while ((b!='M')&&(b>0));
  printf("\n");
  increment();
  fclose(fp);
  return(0);
}

pull_message(spos,flnm)		/* Pull a message out of the master file */
     long spos;			/* position in master file */
     char *flnm;		/* file to write to */
{
  int a,b,c;
  FILE *file, *file2;
  long cc;
  char field[512];

  file2=fopen (flnm, "w+");
  sprintf (msgfile, "msgmains/msgmain.%d", curr_rm);
  file=fopen(msgfile, "rb");
  fseek(file,spos,0);

  for (a=0; a<3; ++a) 
    {
      b = getc (file);
      putc (b, file2);
    }
 PI:	
  b=0; 
  b = getc (file);
  if (b=='M') 
    {
      putc (b, file2);
      goto B;
    }
  fpgetfield(file,field);
  if (b!='I') 
    {
      putc (b, file2);
      fprintf (file2, "%s", field);
      putc (0, file2);
    }
  goto PI;

 B:
  cc = fseek(file,0L,1);
 C:
  if (curr_rm != 1)
    if (cc>=MM_FILELEN)
      cc=fseek(file,0L,0);
  if (curr_rm == 1) 
    if (cc>=MM_MAIL)
      cc=fseek(file,0L,0);
  c = getc (file);
  ++cc;
  putc (c, file2);
  if (c!=0)
    goto C;
  fclose(file); 	
  fclose(file2);
  return(0);
}

entmsg(e,c,replying)
     int e,c,replying; 
{
  char buf[300];
  int file,a,b;
  char mtsflag;
  struct usersupp tempUS;
  long aa;

  if ((curr_rm==0) && (usersupp.axlevel < LOBBYPOST)) 
    {
      printf ("You can't clutter the Lobby.\n"); 
      return (0);
}
  curr_line=1;

/* temp hack to disable mail room */
#ifdef DISABLE_MAIL
  if (curr_rm==1)
    {
      printf ("The Mail> system is currently disabled due to its being quite unreliable.\nIt will be rewritten in the near future, so please bear with us.\nMail on Quartz Paradise is working correctly...\n");  
      return(0);
    }
#endif

  if ((usersupp.axlevel<2)&&(curr_rm!=1)) 
    {
      printf("Need to be validated to enter\n");
      printf("(except in Mail> to Sysop)\n");
      return(0);
    }
  if ((usersupp.axlevel<4)&&(quickroom.QRflags&QR_NETWORK)) 
    {
      printf("Need net privileges to enter here\n");
      return(0);
    }
  enter_btmp ("Enter msg"); /* this must always be "Enter msg" ! */
  mtsflag=0;
  hold_rm=curr_rm;
  IFNEXPERT
    formout("messages/entermsg");
  buf[0]=0;
  if ((curr_rm==1)&&(feedback_flag))
    {
      strcpy(buf,"sysop");
      mtsflag=1;
      goto SKFALL;
    }
  if (curr_rm==1)
    {
      if (usersupp.axlevel>=2)
	{
	  if (!replying) 
	    {
	      printf("Enter recipient: ");
	      getline(buf,299);
	    }
	  else 
	    { 
	      strcpy(buf,who_from);  
	      replying = 0;
	    }
	}
      else
	{
	  strcpy(buf,"sysop");
	  mtsflag=0;
	}
      e=M_LOCAL;
      if (buf[0]==0)
	return(0);
      if (!strucmp(buf,"sysop"))
	{
	  mtsflag=1;
	  goto SKFALL;
	}
      if (!strucmp(buf,usersupp.fullname)) 
	{
	  printf("Can't send mail to yourself!\n");
	  return(0);
	}
      file=eopen("usersupp",O_RDONLY);	/* check to make sure the */
      aa=finduser(file,buf);		/* user exists; also get  */
	if (aa==(-1)) 
	  {				/* the right upper/lower  */
	    printf("No such user.\n");	/* casing of the name     */
	    close(file);
	    return(0);
	  }
      read(file,&tempUS,sizeof(struct usersupp));
      strcpy(buf,tempUS.fullname);
      close(file);
    }
	
 SKFALL:
  b=MES_NORMAL;
  if (quickroom.QRflags&QR_ANONONLY)
    b=MES_ANON;
  if (quickroom.QRflags&QR_ANON2)
    {
      printf("Anonymous (Y/N)? ");
      if (yesno()==1)
	b=MES_AN2;
    }
  if (curr_rm!=1)
    buf[0]=0;

        /* mtsflag indicates mail to sysop */
  if (mtsflag==1)
    {
      curr_rm=2;
      hold_rm=curr_rm;
      gotocurr();
    }
  a=make_message(temp,&usersupp,buf,b,c);
  if (a==2) 
    {         /* user aborted message */
      if ((curr_rm==2) && (usersupp.axlevel < 6))
	{
	  curr_rm=1;
	  gotocurr();
	}
      return(0);    /* changed from return(1) */
    }
  if (islocked())
    {
      sleep (3);
      unlock();
    }
  save_message(temp,buf,mtsflag,e);
  if ((curr_rm==2) && (usersupp.axlevel<6))
    {
      curr_rm = 1;
      gotocurr();
    }
  return(1);    /* changed from return(0) */
}

readmsgs(b,c,odir)	/* read contents of a room */
     int b;		/* starting point in room to read */
     int c;		/* 0=Read all  1=Read new  2=Read old */
     int odir;	        /* 1=Forward (-1)=Reverse */
{
  int a, d, e, file, rdir;
  long aa, cc;
  struct msgmain msgmain;
  
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  rdir = odir; /* start us off in the right direction */
  cc=usersupp.lastseen[curr_rm]+1L;
  if ((usersupp.flags & US_LASTOLD) && (curr_rm != 0)) --cc;
  sprintf (structfile, "structures/MMstructure.%d", curr_rm);
  file=eopen(structfile,O_RDONLY);
  a=read(file,&msgmain,sizeof(struct msgmain));
  if (a<1)
    interr(45);
  close(file);
  abort_read = 0;
  curr_line=1;
  for (a=b; ((a<MSGSPERRM)&&(a>=0)); a=a+rdir) 
    {
      while ( (fullroom.FRnum[a]==0L)
	     ||  (fullroom.FRnum[a]<msgmain.MMlowest)
	     || ((c==1)&&(fullroom.FRnum[a]<cc))
	     || ((c==2)&&(fullroom.FRnum[a]>=cc)))
	{
	  a=a+rdir;
	  if ((a==MSGSPERRM)||(a==(-1)))
	    return(0);
	}
      c = 0;

      e=read_message(fullroom.FRpos[a]);
      unseen = a + 1;
      if ((e==2) || abort_read)  
	return(0);
      if (((usersupp.flags&US_NOPROMPT)||(e==1))&&(curr_rm!=1))
	e='n';
      else
	{
	  curr_line=1;
	  if (((usersupp.axlevel >= 6) 
	       || (usersupp.eternal ==quickroom.QRroomaide))
	      && (curr_rm != 1))
	    printf ("[D]elete, [M]ove, ");
	  if (curr_rm==1)
	    printf ("[R]eply, [B]ack, [N]ext, [S]top (%d): ", MSGSPERRM-a-1);
	  else
	    printf ("[B]ack, [N]ext, [S]top (%d): ", MSGSPERRM-a-1);
		    /*msgmain.MMhighest-fullroom.FRnum[a]);*/
	  do
	    {
	      e=(inkey()&127);
	      e=ctolower(e);
	      if((usersupp.axlevel<6)
		 &&(usersupp.eternal!=quickroom.QRroomaide))
		if ((e=='d')||(e=='m'))
		  e=0;
	      if ((e=='r')&&(curr_rm!=1))
		e=0;
	    }
	  while((e!='b')&&(e!='n')&&(e!='s')&&(e!='r')&&(e!='d')&&(e!='m')&&(e!=' '));
	  switch(e)
	    {
	    case 'd':
	      printf("Delete Message\n");
	      break;
	    case 'm':
	      printf("Move Message\n");
	      break;
	    case 'b':
	      printf("Back One Message\n");
	      break;
	    case 'n':
	      printf("Next Message\n");
	      break;
		case ' ':
			printf("Next Message\n");
	     		break;
	    case 's':
	      printf("Stop Reading\n");
	      break;
	    case 'r':
	      printf("Reply To Author\n");
	      break;
	    }
	}
      switch(e)
	{
	case 's':
	  return(0);
	case 'b':
	  rdir = (-odir);
	  break ; /* --a; goto RAGAIN;*/
	case 'n':
	  rdir = odir;
	  break;
	case ' ':
		rdir = odir;
		break;
	case 'd':
	  printf("---> Delete this message? ");
	  if (yesno()==1)
	    delete_message(fullroom.FRnum[a]);
	  break;
	case 'm':
	  if (move_message(fullroom.FRpos[a]))
	    printf ("Move cancelled.\n");
	  else 
	    delete_message(fullroom.FRnum[a]);
	  break;
	case 'r':
          lastpos = fullroom.FRnum[MSGSPERRM-1];
	  aa = fullroom.FRnum[a];
	  d=entmsg(0,0,1);
          if (lastpos != fullroom.FRnum[MSGSPERRM-1-d])
            printf("New mail arrived for you while you were entering.\n\n");
	  if (d)
	    while (aa != fullroom.FRnum[a])
	      a--;
/*          return(0);*/
          break;
	}
    } /* end for loop */
  return(0);
} /* end read routine */

save_message(mtmp,rec,mtsflag,mailtype)
     char mtmp[];		/* file containing proper message */
     char rec[];		/* Recipient (if mail) */
     char mtsflag;		/* 0 for normal, 1 to force Aide> room */
     int mailtype;              /* local or remote type, see citadel.h */
{			
  int a,d,e,file;
  long aa,ee;
  struct usersupp tempUS;
  char aaa[100];
  int atroom=-1;
  
  if (TWITDETECT)
    if (usersupp.axlevel==2)
      {
	if (twitroom<0)
	  loadtroom();
	hold_rm=curr_rm;
	atroom=curr_rm;
	curr_rm=twitroom;
	gotocurr();
      }

  send_message(mtmp,&smreturn);
  hold_rm=(-1);

  if (mtsflag==1)
    {
      hold_rm=curr_rm;
      curr_rm=2;
      gotocurr();
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=eopen(aaa,O_RDWR);
  a=read(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(49);
  if (curr_rm==1)
    readmail();
  for (a=0; a<(MSGSPERRM-1); ++a) 
    {
      fullroom.FRnum[a]=fullroom.FRnum[a+1];
      fullroom.FRpos[a]=fullroom.FRpos[a+1];
    }
  fullroom.FRnum[MSGSPERRM-1]=smreturn.smnumber;
  fullroom.FRpos[MSGSPERRM-1]=smreturn.smpos;
  lseek(file,0L,0);
  a=write(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(50);
  close(file);

  file=eopen("quickroom",O_RDWR);
  aa=(long)(curr_rm * sizeof(struct quickroom));
  lseek(file,aa,0);
  a=read(file,&quickroom,sizeof(struct quickroom));
  if (a<1)
    interr(52);
  quickroom.QRhighest=fullroom.FRnum[MSGSPERRM-1];
  lseek(file,aa,0);
  a=write(file,&quickroom,sizeof(struct quickroom));
  if (a<1)
    interr(53);
  close(file);
  readyerself();
  ++usersupp.posted;
  if (curr_rm==twitroom)
    usersupp.generation[twitroom]=quickroom.QRgen;
  writeyerself();
  if (curr_rm!=1)
    goto ENTFIN;	/* if mail, there's still more to do */
  writemail();			/* keep a copy for yourself */
  if (mtsflag)
    goto ENTFIN;
  if (mailtype!=M_LOCAL) 
    {
      printf("Filing network mail...\n");
      if ((a=fork())==0) 
	{
	  chdir(BBSDIR);
	  execlp("netmailer","netmailer",mtmp,&mailtype,NULL);
	  printf("*** Netmailer not installed.\n");
	  exit(0);
	}
      do 
	d=wait();
      while((d!=a)&&(d!=(-1)));
    }
  if (mailtype==M_LOCAL) 
    {
      file=eopen("usersupp",O_RDWR);
      ee=finduser(file,rec);
      if (ee!=(-1L)) 
	{
	  read(file,&tempUS,sizeof(struct usersupp));
	  for (e=0; e<(MAILSLOTS-1); ++e) 
	    {
	      tempUS.mailnum[e]=tempUS.mailnum[e+1];
	      tempUS.mailpos[e]=tempUS.mailpos[e+1];
	    }
	  tempUS.mailnum[MAILSLOTS-1]=smreturn.smnumber;
	  tempUS.mailpos[MAILSLOTS-1]=smreturn.smpos;
	  lseek(file,ee,0);
	  write(file,&tempUS,sizeof(struct usersupp)); 
	}
      close(file);
    }
  
 ENTFIN:	
  if (TWITDETECT) 
    if (atroom!=(-1)) 
      {
	curr_rm=atroom;
	gotocurr();
      }
  if (mtsflag) 
    { 
      curr_rm=hold_rm;
      gotocurr();
    }
  unlink(mtmp);
  return(0);
}
