/* Citadel/UX 3.01
   commands.c - Command parser for room prompts

   bsd compatibilty added; local command modifcations
*/

/* keys used are *@?#CDEFGHIKLOPRSTUWYZ */
/* dot keys: AEGKRZ */
/* aide keys  ACDEFKMRTUVWZ */
/* aide room  IK */

/* non-dot commands 1-26 */

#include <stdio.h>
#include <ctype.h>
#include "citadel.h"
#include "defs.h"

long            lseek ();
extern struct usersupp usersupp;
extern int      curr_rm;
extern struct quickroom quickroom;
extern int unseen;

int getcmd ()	   /* Parses an input command, also translates synonyms */
{
  int a;

 GCA:
  a = inkey ();
  a = ctolower (a);
  if (a == 'n')   {
      printf ("Read New\n");
      return (13);   }
   if (a == 'e')   {
     printf ("Enter Message\n"); 
     return (4);   }
	if (a == ' ') {
		printf("Goto\n");
	return(5); }
   if (a == 'g')   {
     printf ("Goto\n"); 
     return (5);   }
   if (a == 't')   {
      printf ("Terminate\n");
      return (15);   }
   if (a == '*')   {
     printf ("SubSystem\n"); 
     return (2);}
 if (usersupp.axlevel >= 4) 
   if (a == 'c') {
     printf ("Chat With SysOp\n"); 
     return (3);}
   if ( a=='j')  {
     printf ("Jump to: ");
     return (20);}
   if (a == '?')  {
     printf ("Help\n"); 
     return (1);   }
   if (a == '#')   {
     printf ("Read Last X.\n"); 
     return (14);   }
   if (a == 's')   {
     printf ("Skip %s\n", quickroom.QRname); 
     return (6);}
   if (a == 'a')   {
     printf ("Abandon %s (Leaving %d unread)\n", quickroom.QRname,
              MSGSPERRM-unseen); 
     return (444);}
   if (a == 'z')   {
     printf ("Zap (forget) room\n"); 
     return (7);   }
   if (a == 'k')   {
     printf ("Known Rooms\n"); 
     return (8);   }
   if (a == 'l')   {
     printf ("Read last five messages\n"); 
     return (9);}
   if (a == 'p')   {
     printf ("Read last ten messages\n"); 
     return (26);}
   if (a == 'f')   {
     printf ("Read Forward\n"); 
     return (10);}
   if (a == 'r')   {
      printf ("Read Reverse\n");
      return (11);   }
   if (a == 'o')   {
      printf ("read Old reverse\n");
      return (12);   }
   if (a == 'd')   {
      printf ("Room Description\n");
      return (29);   }
   if (a == 'm')   {
      printf ("Go To Mail\n");
      return (95);   }
   if (a == 'u')   {
      printf ("Ungoto\n");
      return (16);   }
    if (a=='y') {
        printf("A Quote For You...\n");
        return(30); }
    if (a=='@') {
        printf("Date\n");
        return(90); }
    if (a=='i') {
        printf("Information System\n");
        return(21); }
    if (a=='v') {
	printf("Voting Booth\n");
	return(725); }
   if (a == 'w')   {
      printf ("Who is on..\n\n");
      return (17);   }
   if (a == '.')   {
      printf (".");
      goto DOT;   }
   IFAIDE if       (a == '!') 
   {  printf ("! ");
      return (18);   }
                   goto GCA;

DOT:a = inkey ();
   a = ctolower (a);
   if (a == 8)
   {
      back (1);
      goto GCA;
   }
   if (a == 'r')
   {
      printf ("Read ");
      goto GCREAD;
   }
   if (a == 'e')
   {
      printf ("Enter ");
      goto GCENT;
   }
   if (a == 'k')
   {
      printf ("Known rooms\n");
      return (8);
   }
   if (a == 'l')
   {
      printf ("List of users\n");
      return (950);
   }
   if (a == '?')
	{
	printf("Dot Help\n");
	return (417);
	}
   if (a == 'w')
   {
      printf ("Who editor\n");
      return (528);
   }
   if (a == 'z')
   {
      printf ("Zapped list\n");
      return (19);
   }
   if ((usersupp.axlevel >= 6) || (usersupp.eternal == quickroom.QRroomaide))
      if (a == 'a')
      {
	 printf ("Aide cmd: ");
	 goto GCAIDE;
      }
   if (usersupp.axlevel == 7) 
      if (a == 's')
      {
	 printf ("Sysop command: ");
	 goto GCSYSOP;
      }
   if (a == 'g')
   {
      printf ("Goto Room: ");
      return (20);
   }
   goto DOT;

GCAIDE:a = inkey ();
   a = ctolower (a);
   if (a == '?')   {
      if (usersupp.axlevel < 6) {
	  printf ("(Room Aide Options)\n");
          system ("/bin/cat /usr1/bbs/messages/rmaide");}
      else {
          printf ("(aide options)\n");
	  system ("/bin/cat /usr1/bbs/messages/aideopt");}
      printf ("%s> .Aide cmd: ", quickroom.QRname);
      goto GCAIDE;   }
   if (a == 8)   {
      back (10);
      goto DOT;   }
   if (a == 'r')   {
      printf ("Room cmd: ");
      goto ROOMCMD;   }
   if (a == 'k')   {
      printf ("Kill this room\n");
      return (22);   }
   if (a == 'c')   {
      printf ("Create Room\n");
      return (38);   }
   if (a == 't')   { 
      printf ("See Room Type\n");
      return (91);   }
   if (a == 'e')   {
      printf ("Edit Room\n");
      return (23);   }
   if (a == 'f')   {
      printf ("Finger @localhost\n");
      return (32);   }
   if (a == 'w')   {
      printf ("Who knows room\n");
      return (24);   }
   if (a == 'd')   {
      printf ("Enter Room Description\n");
      return (33);   }
   if ((usersupp.axlevel >= 6) && (a == 'u'))   {
      printf ("User edit\n");
      return (25);   }
   if ((usersupp.axlevel >= 6) && (a == 'v'))   {
      printf ("Validate new users\n");
      return (36);   }
   if ((usersupp.axlevel >= 6) && (a == 's'))   {
      printf ("Go to sleep...\n");
      return (98);   }
   goto GCAIDE;

ROOMCMD:
   a = inkey ();
   a = ctolower (a);
   if (a == 8)   {
      back (10);
      goto GCAIDE;   }
   if (a == 'i')   {
      printf ("Invite user\n");
      return (27);   }
   if (a == 'k')   {
      printf ("Kick out user\n");
      return (28);   }
   goto ROOMCMD;

GCREAD:a = inkey ();
   a = ctolower (a);
   if (a == '?')   {
      printf ("(options)\n");
      formout ("messages/readopt");
      printf ("%s> .Read ", quickroom.QRname);
      goto GCREAD;   }
   if (a == 8)   {
      back (5);
      goto DOT;   }
   if (a == 'r')   {
      printf ("Reverse\n");
      return (11);   }
   if (a == 'n')   {
      printf ("New messages\n");
      return (13);   }
   if (a == 'o')   {
      printf ("Old messages reverse\n");
      return (12);   }
   if (a == 'l')   {
      printf ("Last five messages\n");
      return (9);   }
   if (a== 'd') {
      printf ("Directory\n");
      return (92);}
   if (a== 'u') {
      printf ("User\n");
      return (99);}
   if (a== 'z') {
      printf ("File Using Zmodem\n");
      return (45);}
   if (a=='x') {
      printf ("File Using Xmodem\n");
      return (34);}
   if (a=='y') {
      printf ("File Using Ymodem\n");
      return (323); }
   if (a=='t') {
      printf ("Textfile (screen by screen)\n");
      return (43); }
   if (a=='a') {
      printf ("File Using ASCII Download\n");
      return (31);}
   if (a== 's') {
      printf ("System Configuration\n");
      return (89);}

   goto GCREAD;

GCENT:a = inkey ();
   a = ctolower (a);
   if (a == '?')   {
      printf ("(options)\n");
      formout ("messages/entopt");
      printf ("%s> .Enter ", quickroom.QRname);
      goto GCENT;   }
   if (a == 8)   {
      back (6);
      goto DOT;   }
   if (a == 'b') {
	printf("Biography\n");
	return(394); }
   if (a == 'p')   {
      printf ("Password\n");
      return (35);   }
   if (a == 'r')   {
      printf ("Room\n");
	return (38);	}
   if (a == 'm')   {
      printf ("Message\n");
      return (4);   }
   if (a == 'c')   {
      printf ("Configuration\n");
      return (37);   }
   if (a == 'z') {
      printf ("File Using Zmodem\n");
      return (44); }
   if (a=='k') {
      printf ("File Using Kermit\n");
      return (42);}
   if (a == 't') {
      printf ("Textfile\n");
      return (39); }
   if (a == 'g')   {
      printf ("Registration\n");
      return (41);   }
   goto GCENT;


GCSYSOP: a = inkey ();
   a = ctolower (a);
   if (a == 's') {
     printf ("Send Message to a specified tty\n");
	return (46); }
   if (a == 8)   {
      back (15);
      goto DOT;   }
if (a == 'u') {
  printf ("Useradmin \n");
  return (49); }
goto GCENT;


 } /* end main */
