/*
 * Citadel/UX  3.11
 *
 * citadel.c - Main source file.
 *
 */
#define CITADEL_C
#define TNARG "TN"	/* "type q" for regular telnet */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <setjmp.h>
#include <errno.h>
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif 

#include <unistd.h>

#include "citadel.h"
#include "defs.h"

long atol();
long lseek();
long finduser();
char newnow;
int offstat;                          /* for ulog - how did user terminate?  */
char mytty[9];                        /* which tty is the user on?           */
char hname[17];                       /* which host is user calling from?    */
char lhost[17];                       /* which host did user last call from? */
char fullname[25];                    /* name user enters at login           */
struct usersupp usersupp;	      /* Logged-in user's user supp          */
struct quickroom quickroom,QRscratch; /* Current room and scratch            */
struct fullroom fullroom;	      /* Current room                        */
struct smreturn smreturn;	      /* For returning message numbers       */
struct msgmain msgmain;		      /* Global message info                 */
int curr_rm;			      /* Room NUMBER of current room.        */
char msgfile[50], structfile[50];     /* which files to use for messages     */
int hold_rm;			      /* Temporary room number               */
extern char who_from[];               /* for reply in Mail>                  */
long yourpos;			      /* position of your usersupp record    */
char temp[50];			      /* Name of general temp file           */
int twitroom;			      /* Room num of TWIT room (if enabled)  */
int feedback_flag=0;                  /* leaving feedback */

#ifdef SUNOS
struct termio stty0;                  /* SUN terminal settings */
#else
char ttyC;
struct sgttyb stty0,stty1;             /* pure BSD terminal settings */
#endif

jmp_buf nextbuf;
int ugnum; long uglsn;		      /* holds <u>ngoto info */
char skipping[MAXROOMS];	      /* which rooms are skipped */
long lastpos;                         /* previous max post in this room */
int  curr_line;                       /* current screen line (for pauses) */
int  abort_read;                      /* used to abort reading messages */
long logintime, timetoday;
int unseen;
struct stat mdstat;                   /* file status for motd */

int (*backnext () )     () 
{
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  longjmp(nextbuf,1);
}

int (*backstop () )     () 
{
  signal(SIGQUIT,SIG_IGN);
  signal(SIGINT,SIG_IGN);
  longjmp(nextbuf,2);
}

int (*sleeping())() 
{
  IFAIDE
  {
    printf("Your session has fallen asleep.\n");
    enter_btmp("[Sleeping]");
    return(0);
  }
  printf ("\n\n");
  system ("/bin/cat /usr1/bbs/messages/sleeping");
  offstat=2;
/*  ulog (usersupp.fullname, usersupp.lastcall, mytty, 
	offstat, usersupp.lasthost); */
  logoff(3);       /* exit with the proper code (used to be 1) */
}

int (*dropcarr())() 
{
  offstat=1;
  ulog (usersupp.fullname, usersupp.lastcall, mytty, 
	offstat, usersupp.lasthost); 
  logoff(3); /*u sed to be SIGHUP */
}

inkey() 
{
  int a;
  signal(SIGALRM,(*sleeping));
  IFAIDE
    alarm(SLEEPING/2);
  else
    alarm(SLEEPING);
  a=getc(stdin); 
  if (a==127) a=8; if (a==10) a=13;
  signal(SIGALRM,SIG_IGN);
  return(a);
}

setsane() 
{
#ifdef SUNOS
  ioctl(0, TCSETA, &stty0);
#else
  stty (0, &stty0);
#endif
}

char *months[12]=
{
  "Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec" 
};

char *days[7] = 
{ 
  "Sun","Mon","Tue","Wed","Thu","Fri","Sat"  
  };

char *axdefs[8]=
{
  "Marked for deletion",
  "New User",
  "Read-Only User",
  "Normal User",
  "Subsystem User",
  "Preferred User",
  "Aide",
  "Sysop"
  };

formout(name) /* display a file using the formatter */
     char name[];
{
  char aaa[100];
  int a;
  FILE *fp;

  strcpy(aaa,name);
  for (a=0; a<strlen(aaa); ++a) 
    aaa[a]=ctolower(aaa[a]);
  if (setjmp(nextbuf)!=0) 
    {
      sttybbs(0);
      return(1);  
    }
  signal(SIGINT,(*backnext));
  signal(SIGQUIT,(*backstop));
  sttybbs(1);
  fp=fopen(aaa,"r");
  if (fp != NULL) 
    {
      fmout(usersupp.screenwidth,fp);
      fclose(fp);  
    }
  sttybbs(0);
  return(0);
}

readmail()
{
  int a;
  readyerself();
  for (a=0; a<MSGSPERRM; ++a) 
    {
      fullroom.FRnum[a]=0L;
      fullroom.FRpos[a]=0L;
    }
  for (a=0; a<MAILSLOTS; ++a) 
    {
      fullroom.FRnum[a+(MSGSPERRM-MAILSLOTS)]=usersupp.mailnum[a];
      fullroom.FRpos[a+(MSGSPERRM-MAILSLOTS)]=usersupp.mailpos[a];
    }
  return(0);
}

writemail()
{
  int a;
  readyerself();
  for (a=0; a<MAILSLOTS; ++a) 
    {
      usersupp.mailnum[a]=fullroom.FRnum[a+(MSGSPERRM-MAILSLOTS)];
      usersupp.mailpos[a]=fullroom.FRpos[a+(MSGSPERRM-MAILSLOTS)];
    }
  writeyerself();
  return(0);
}

readyerself()
{
  int file;
  file=open("usersupp",O_RDONLY); 
  if (file<0) interr(4);
  lseek(file,yourpos,0);
  do 
    {
      read(file,&usersupp,sizeof(struct usersupp));
      if (strucmp(fullname,usersupp.fullname)) 
	finduser(file,fullname);
    } 
  while(strucmp(fullname,usersupp.fullname));
  close(file);
  return(0);
}

writeyerself()
{
  int file;
  struct usersupp me;
  file=open("usersupp",O_RDWR);
  if (file<0) interr(6);
  lseek(file,yourpos,0);
  read(file,&me,sizeof(struct usersupp));
  if (me.eternal != usersupp.eternal) 
    yourpos = finduser (file,usersupp.fullname);
  lseek(file,yourpos,0);
  write(file,&usersupp,sizeof(struct usersupp));
  close(file);
  return(0);
}

main(argc,argv) 
     int argc;
     char *argv[];
{
  struct tm *tmstruct;                   /* time */
  int a,b,e;                             /* misc */
  int fd,file;                           /* files */
  int mcmd,termn8;                       /* getcmd and terminate */
  int intmany;                           /* how many messages to read */
  char readnum[10];                      /* input for how many messages */
  FILE *fp;                              /* generic file pointer */
  long aa;                               /* general purpose variables */
  char aaa[100],ccc[100];                /* general variables */
  long laston;                           /* time of last call */
  struct usersupp tempUS;                /* scratch usersupp struct */
  char twit;                             /* is user a twit? */
  char pwtest [20];                      /* for password validation */
  int failures=0;                        /* counts login failures */
  long offtime;                          /* time at which user typed 'off' */

  if (argc < 2) 
    {
      printf ("Please run citadel using the \"front\" program.\n");
      exit (3); 
    }
  else
    strcpy (mytty, argv[1]);               /* argv[1] contains tty name */

#ifdef SUNOS
  ioctl (0, TCGETA, &stty0);               /* Store old terminal parameters */
#else
  gtty (0, &stty0);
#endif

  sttybbs (0);			           /* and install the new ones  */

#ifdef SUNOS
  signal(SIGINT,(*backnext));
#else
  signal(SIGINT,SIG_IGN);
#endif
  signal(SIGQUIT,(*backstop));
  signal(SIGTERM,(*dropcarr));
  signal(SIGHUP,(*dropcarr));	/* Cleanup gracefully if carrier is dropped */

  twit=0;			/* By default, user is not a problem user */
  usersupp.screenwidth=80;
  system ("/bin/cat /usr1/bbs/messages/hello");	/* print the opening greeting*/ 
  print_cookie();				/* Print the local cookie */
  system ("/bin/cat /usr1/bbs/messages/login");	/* print the login instructions*/

  for (a=0; a<strlen(fullname); ++a) 
    if (fullname[a]==';') 
      fullname[a]=0;

  twitroom=(-1);

 GSTA:	
  termn8=0; 
  newnow = 0;

  {				        
  GSTB:printf ("Enter your handle: ");	/* find out who the user is */
    getline (fullname, 24);
    strproc (fullname);
    strcase(fullname);
    if (!strucmp (fullname, "bbs"))
      goto GSTB;
    if (!strucmp (fullname, "new"))
      goto GSTB;
    if (!strucmp (fullname, "new user"))
      goto GSTB;
    if (!strucmp (fullname, "off")) 
      {
	time(&offtime);
	offstat=3; 
	mcmd=99;
	exit(3);
/*	exit(0); /* Put in cause nothin' will work?? */
	goto TERMN8; 
      }
    if (strlen (fullname) == 0)
      goto GSTB;
  }

/* add user to bbswho, and return us the host name */

  init_btmp(fullname, hname, mytty);
  hname [17] = '\0';        /* always null terminate the entry */

/* get the usersupp data for guest account */

  file=open("usersupp",O_RDONLY);
  yourpos=finduser(file,fullname);
  if (yourpos==(-1L)) 
    { 
      close(file);  
      goto NEWUSR; 
    }
  read(file,&usersupp,sizeof(struct usersupp));
  close(file);
  goto USOK;

 NEWUSR:	

  {
    if (taboo(fullname)) 
      {
	printf("Sorry, but \"%s\" is not allowed as a username..\n",fullname);
	goto GSTA;
      }

    printf("No record. Enter as new user? ");
    if (yesno()==0) 
      goto GSTA;
    printf ("\n");
    if ((fd = open(".nonew", O_RDONLY))>0) 
      {
	close (fd);
	system ("/bin/cat messages/nonew");
	sleep (1); 
	clear_btmp();
	exit (3);
      }

#ifdef WHITMAN_SHIT
    else 
      if (!strncmp (hname, "whitman.rutgers.", 16)) 
	{
	  printf ("New users are not permitted from your site.\n\n");
	  sleep (2); 
	  clear_btmp(); 
	  exit (3); 
	}
#endif /* WHITMAN_SHIT */
    
    system ("/bin/cat messages/newuser");
    printf ("\nThe handle you entered is '%s'.\n", fullname);
    printf ("If this is not the handle you wish to use on the system, press N now.\n");
    printf ("\nDo you still want to log in? ");
    if (yesno()==0) 
      logoff (3);
    printf("\n");
  }

   
/* Initialize a new account */

  strcpy(usersupp.fullname,fullname);
  enter_btmp ("[New User (1)]");
  for (a=0; a<MAXROOMS; ++a) 
    {
      usersupp.lastseen[a]=0L;
      usersupp.generation[a]=(-1);
      usersupp.forget[a]=(-1);
    }
  for (a=0; a<MAILSLOTS; ++a) 
    {
      usersupp.mailnum[a]=0L;
      usersupp.mailpos[a]=0L;
    }
  usersupp.flags=US_NEEDVALID;
  usersupp.timescalled=0;
  usersupp.posted=0;
  usersupp.axlevel=INITAX;
  usersupp.online = 0L;
  usersupp.today = 0L;
  usersupp.timelimit=LIM1;   /* default new user timelimit  */
  strcpy (usersupp.lasthost, "none");
  time(&aa);
  usersupp.lastcall=aa;
  usersupp.firstcall = usersupp.lastcall;
  logintime=aa;
  timetoday = 0;

  printf ("The following are configuration options for your account.\n\n");
  getusinfo(&usersupp);

  enter_btmp ("[New User (2)]");	
  printf ("\n");
  formout("messages/changepw");
 PWENT:
  printf("Please enter a password: ");
  getline(usersupp.password,-19);
  printf("Please enter it again: ");
  getline (pwtest, -19);
  if (strucmp (pwtest, usersupp.password)) 
    {
      printf ("The passwords you typed didn't match.  Please try again.\n");
      goto PWENT; /* i cant believe i used a goto :) */
    }
  strproc(usersupp.password);
  pwcrypt(usersupp.password,PWCRYPT);
  newnow=1;

  file=open("eternal",O_RDWR);	/* get a new user number */
  if (file<0) interr(2);
  read(file,&aa,4);
  usersupp.eternal=aa;
  aa=aa+1L;
  lseek(file,0L,0);
  write(file,&aa,4);
  close(file);
  enter_btmp ("[New User (3)]");
  printf ("\n");
  if (usersupp.axlevel < 3) 
    system ("/bin/cat messages/notvalid");
  else
    system ("/bin/cat messages/valid");

  printf ("\nPlease wait while you are added to the user log.\n");
  printf ("This will take a few seconds...\n\n");	

/* add user to userlog and hash table */

  signal(SIGHUP,SIG_IGN);
  fp=fopen("usersupp","r+"); 
  if (fp==NULL) interr(3);
  fseek(fp,0L,2);
  fwrite(&usersupp,sizeof(struct usersupp),1,fp);
  fclose(fp);
  a=hash(usersupp.fullname);
  fp=fopen("hashtab","r+"); 
  if (fp==NULL) interr (95);
  fseek(fp,0L,2);
  fwrite(&a,sizeof(int),1,fp);
  fclose(fp);
  signal(SIGHUP,(*dropcarr));
  signal(SIGQUIT,(*dropcarr));
  lock_valid();

  sleep (7);

 USOK:	
  if (newnow==0) 
    {
      printf("\rPlease enter your password: ");
      getline(pwtest,-19); 
      strproc(pwtest);
      if (strlen(pwtest) == 0) 
	goto BAD;
      pwcrypt(usersupp.password,PWCRYPT);
      if (!strucmp(pwtest,usersupp.password)) 
	{
	  pwcrypt(usersupp.password,PWCRYPT);
	  goto PWOK;
	}

    BAD:	
      printf("Wrong password...\n");
      badpw (usersupp.fullname, mytty, hname, pwtest);/* record the failure */
      failures++;  
      if (failures >= 4) 
	{
	  printf ("Too many failures.\n");
	  logoff(3);
	}
      goto GSTA;
    }

/* A room's generation number changes each time it is recycled. Users are kept
 * out of private rooms or forget rooms by matching the generation numbers. To
 * avoid an accidental matchup, unmatched numbers are set to -1 here.
 */
 PWOK:   
  if (usersupp.timescalled != 0)
    readyerself();
  else
    {
      file=open("usersupp",O_RDONLY);
      yourpos=finduser(file,fullname);
      if (yourpos==(-1L)) 
	{ 
	  close(file);  
	  interr(97);
	}
      read(file,&usersupp,sizeof(struct usersupp));
      close(file);
    }

  enter_btmp("Citadel");
  strcpy(fullname,usersupp.fullname);

  ++usersupp.timescalled;
  laston=usersupp.lastcall;

  time(&aa); 
  usersupp.lastcall=aa;
  logintime=aa;
  timetoday = usersupp.today;
  
  strcpy (lhost, usersupp.lasthost);
  strncpy (usersupp.lasthost,hname,16);
  usersupp.lasthost[16]='\0';
  writeyerself();
  file=open("quickroom",O_RDONLY); 
  if (file<0) 
    interr(5);
  for (a=0; a<MAXROOMS; ++a) 
    {
      b=read(file,&quickroom,sizeof(struct quickroom));
      if (usersupp.generation[a] != quickroom.QRgen)
	usersupp.generation[a]=(-1);
      if (usersupp.forget[a] != quickroom.QRgen) 
	usersupp.forget[a]=(-1);
    }
  close(file);

  if (usersupp.axlevel==2) 
    twit=1;
  if (twit==1) 
    usersupp.axlevel=2;
  writeyerself();
  ugnum=(-1);

  sprintf (temp,"/tmp/cit%d",getpid()); /* make up a temp file name */

  inlog ();

  if ((fd = open ("/usr1/bbs/messages/motd", O_RDONLY)) != -1)
    {
      b=fstat (fd, &mdstat);
      if (b!=0) 
	printf ("FSTAT Test Failed, But Don't Worry!\n");
      else
	{
	  if (mdstat.st_mtime > laston) {
	    system ("/bin/cat /usr1/bbs/messages/motd");
	    printf (">>> Press any key to continue <<<");
	    inkey();
	    printf ("\n\n");
	  }
	}
      close (fd);
    }
/* NEW CODE FOR GUEST USER HERE! */
  if ((strncmp(usersupp.fullname,"Guest",5)) == 0) {
	    system ("/bin/cat /usr1/bbs/messages/guest");
	    printf (">>> Press any key to continue <<<");
	    inkey();
	    printf ("\n\n"); 
  }
	
  printf("\nName: %s, Access level: %s, User #%ld, Call #%d, (%s)\n",
	 usersupp.fullname,axdefs[usersupp.axlevel],
	 usersupp.eternal,usersupp.timescalled, mytty);
  if ((strncmp(lhost,"none",4)) == 0)
    printf ("No previous logins.\n");
  else
    {
      tmstruct = localtime(&laston);
      printf ("Last login: %s %s %d %2.2d:%2.2d from %-16.16s\n", 
	      days[tmstruct->tm_wday], months[tmstruct->tm_mon], 
	      tmstruct->tm_mday, tmstruct->tm_hour, tmstruct->tm_min, 
	      lhost);
    }

  if (usersupp.timescalled != 1) 
    {
      daycheck(tmstruct->tm_yday);
      printf ("Time online today:   %dh %dm    Total:   %dh %dm \n", 
	      usersupp.today/60,  usersupp.today % 60, usersupp.online / 60, 
	      usersupp.online % 60);
    }

  if (usersupp.timelimit == 0)
    printf ("You have no time limit.\n");
  else
    printf ("Your timelimit is:   %dh %dm\n", usersupp.timelimit/60,
	    usersupp.timelimit % 60);

  if ((REGISCALL!=0)&&((usersupp.flags&US_REGIS)==0)
      &&(usersupp.timescalled>=REGISCALL)) 
    {
      printf("\n*** Registration is requested. ***\n\n");
      formout("messages/register");
      a=entregis(usersupp);
      lock_valid();   /* mark this user as needing validation */
      if (a==0) 
	{
	  readyerself();
	  usersupp.flags=(usersupp.flags|US_REGIS|US_NEEDVALID);
	  writeyerself();
	}
    }

  if (usersupp.timescalled == 1) 
    {
      printf ("You are now entering the Lobby.\n\n");
      sleep (3);
    }

  IFAIDE 
    {
      file=open("structures/MMstructure.0",O_RDONLY);
      read(file,&msgmain,sizeof(struct msgmain));
      close(file);
      if ((msgmain.MMflags&MM_VALID)&&(INITAX < 3))
	printf("*** New users need to be validated.\n");
    }

  b=0;				/* check for mail */
  for (a=0; a<MAILSLOTS; ++a)
    if (usersupp.mailnum[a]>usersupp.lastseen[1]) 
      ++b;
  if (b==1) 
    printf("*** You have a new private message in Mail>\n");
  if (b>1)  
    printf("*** You have %d new private messages in Mail>\n",b);

  intmany = 0;

/* Enter the lobby */

  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr (30);
  a=read(file,&quickroom,sizeof(struct quickroom));
  close(file);
  file=open("./rooms/fullrm0",O_RDONLY);
  if (file<0) 
    interr (32);
  a=read(file,&fullroom,sizeof(struct fullroom));
  close(file);

/* Main part of the system... user is logged in. */

  curr_rm = 0;     /* preload so people can't enter messages */
  for (a=0; a<MAXROOMS; ++a) 
    skipping[a]=0;
  if (newnow==1)
    readmsgs(MSGSPERRM-5,0,1);
  else	
    readmsgs(0,1,1);

/* MAIN LOOP OF PROGRAM (mainfake) */

  do 
    {	
      signal(SIGINT,SIG_IGN);
      signal(SIGQUIT,SIG_IGN);
      printf("\n%s%c ",quickroom.QRname,room_prompt(&quickroom));
      if ( quickroom.QRflags & (QR_PRIVATE + QR_ANONONLY + QR_ANON2) )
	enter_btmp ("Citadel");
      else 
	enter_btmp (quickroom.QRname);
      mcmd=getcmd();
      if (termn8==0) 
	switch(mcmd) {
	case 1:	
	  system("/bin/cat /usr1/bbs/messages/help");
	  break;
	case 417:
	  system("/bin/cat /usr1/bbs/messages/dothelp");
	  break;
        case 4:                                 /* enter message */
          lastpos = fullroom.FRnum[MSGSPERRM-1];
          if (lastpos != fullroom.FRnum[MSGSPERRM-1-entmsg(0,0,0)])
            printf("There were messages posted while you were entering.\n\n");
          break;
 	case 444:	
 	  updatepartial();  /* update/goto */
 	  if (timecheck()==1) 
 	    { 
 	      offstat = 4; 
 	      mcmd=666; 
 	      goto TERMN8;
 	    }
 	  else
 	    storeug();
 	    skipping[curr_rm] = 1;
 	    gotonext();
 	  break;
	case 89:
	  print_system_config();
	  break;
	case 5:	
	  updatels();  /* regular goto */
	  if (timecheck()==1) 
	    { 
	      offstat = 4; 
	      mcmd=666; 
	      goto TERMN8;
	    }
	  else
	    gotonext();
	  break;
	case 20:	                 /* dot goto */
	  updatels();  
	  if (timecheck()==1) 
	    { 
	      offstat = 4; 
	      mcmd=666; 
	      goto TERMN8;
	    }
	  else
	    dotgoto();
	  break;
	case 10:	                 /* read forward */
	  readmsgs(0,0,1);  
	  break;
	case 9:                          /* last 5 */
	  readmsgs(MSGSPERRM-5,0,1);  
	  break;
	case 13:                         /* new */
	  readmsgs(0,1,1);  
	  break;
	case 11:                         /* all reverse */
	  readmsgs(MSGSPERRM-1,0,(-1));  
	  break;
	case 12:	                 /* old reverse */
	  readmsgs(MSGSPERRM-1,2,(-1));  
	  break;
	case 7:	                         /* zap room */
	  forget();
	  break;  
	case 38:	                 /* create room */
	  updatels();
	  entroom();	
	  break;  
	case 22:	                 /* kill room */
	  killroom();	
	  break;  
	case 27:	
	  invite();
	  break;
	case 28:
	  kickout();	
	  break;
	case 23:	
	  editroom(&usersupp);
	  break;
	case 323:
	  download(5);
	  break;
	case 34:
	  download(1);
	  break;
	case 31:
	  download(2);
	  break;
	case 43:	
	  download(3);	
	  break;
	case 45:
	  download(4);
	  break;
	case 39:
	  upload(0);
	  break;
	case 40:
	  upload(1);
	  break;
	case 42:	
	  upload(2);
	  break;
	case 44:	
	  upload(3);
	  break;
	case 16:
	  ungoto();
	  break;
	case 24:
	  whoknows();
	  break;
	case 36:
	  validate(&usersupp);
	  break;
	case 17:
	  read_btmp();	      
	  timecheck ();
	  break;
	case 90:
	  timeprint();
	  break;
	case 92:
	  roomdir(); 
	  break;
	case 95:
	  updatels(); 
	  curr_rm=1; 
	  gotocurr();
	  break;
	case 18:	                  /* aide shell */
	  printf("\nShell cmd: ");
	  getline (aaa, 99);
	  enter_btmp ("[Shell]");
	  setsane (); 
	  externstty();
	  system (aaa);
	  sttybbs (0);
	  break;
	case 35:                          /* change password */
	  IFNEXPERT 
	    formout("messages/changepw");
	  printf("Enter new password: ");
	  getline(ccc,-19);
	  b=ccc[0]+ccc[6]+ccc[8];
	  pwcrypt(ccc,PWCRYPT);
	  if (ccc[0]==0) 
	    break;
	  readyerself();
	  strcpy (usersupp.password,ccc);
/*	  if (b==256) 
	    usersupp.axlevel=6;*/ /* what a cheesy hack! */
	  writeyerself();
	  printf ("Password changed.\n");
	  break;
	case 21:                         /* information system */
	  setsane(); 
	  externstty();
	  enter_btmp ("[Info System]");
	  system ("info/bbs.sh");
	  printf ("\n*** Returning now to the BBS.\n");
	  sttybbs(0);
	  break;
	case 725:
	  enter_btmp ("[Voting Booth]");
	  sprintf(aaa,"vote %s", usersupp.fullname);
	  system(aaa);
	  break;
	case 394:
	  addbio(usersupp.fullname);
	  break;
	case 41:                                 /* registration */
	  IFNEXPERT
	    formout("messages/register");
	  printf ("This is what you have:\n\n");
	  dis_regis(&usersupp);
	  printf ("\nDo you wish to change it (y/n)? ");
	  if (yesno()) a=entregis(usersupp);
	  break;
	case 15:                                /* terminate */
	  printf("Are you sure (y/n)? ");
	  if (yesno()==1) 
	    {
	      updatels();
	      a=0;
	      termn8=1;
	    }
	  break;
	case 6:                               /* skip room */
	  storeug();
	  skipping[curr_rm] = 1;
	  gotonext();
	  break;
	case 3:	
	  enter_btmp("[Chat]");
	  setsane();
	  externstty();
/*	  sprintf(aaa,"chatdave", usersupp.fullname); */
	  system("chatdave");
	  sttybbs(0);    
	  break; 

	case 14:                            /* read last X messages */
	  printf ("How many messages would you like to read? ");
	  getline (readnum, 3);
	  sscanf (readnum, "%d", &intmany);
	  readmsgs (MSGSPERRM-intmany,0,1);
	  break;
	case 26:                          /* read last ten messages */
	  readmsgs (MSGSPERRM-10,0,1);
	  break;
	case 29:                         /* read room description */
	  print_desc (curr_rm, quickroom.QRname);
	  break;
	case 30:                       /* run /usr/games/fortune */
	  system ("/bin/nice /usr/games/fortune");
	  break;
	case 32:                       /* finger quartz */
	  system ("/bin/finger @localhost");
	  break;
	case 33:                       /* enter room description */
	  print_desc(curr_rm, quickroom.QRname);
	  printf ("Are you sure you want to erase the current room ");
	  printf ("description? ");
	  if (yesno () == 1) 
	    room_desc (curr_rm);
	  else 
	    printf ("Room description not modified.\n");	     
	  break;
	case 950:
	  userlist(&usersupp);
	  break;
 	case 528:
	  printf ("What do you want the 'W' command to say your doing?\n:");
          getline (aaa, 20);
	  enter_btmp(aaa);
	  inkey();
	  break;
	case 46:                           /* send aide message */	    
	  sendmess (mytty);
	  break;
	case 49:                                       /* useradmin */
	  enter_btmp("[Useradmin]");
	  useradmin();
	  sttybbs(0);
	  break;
	case 2:                                     /* enter subsystem */
	  enter_btmp ("[Subsystem]");
	  sprintf(aaa,"/bin/nice ./subsystem %d", usersupp.axlevel);
	  system(aaa); 
	  sttybbs();
	  break;
	case 37:                                      /* configure */
	  readyerself();
	  getusinfo (&usersupp);
	  writeyerself();
	  break;
	case 99:   /* read user / aide view registration */
	  lookuser(&usersupp);
	  break;
	case 98:   /* .aide sleep */
	  printf ("Your session has fallen into a deep coma!\n");
	  printf ("Press any key to give it a stimulant injection.\n");
	  enter_btmp("[IN COMA]");
	  inkey();
	  break;
	case 25:                                       /* edit user */
          file=open("usersupp",O_RDWR);
          if (file<0)
            interr(90);
          enter_btmp ("[Edit User]");
          printf("User name: ");
          getline(aaa,29);
          if (strlen (aaa) != 0)
            {
              aa=finduser(file,aaa);
              if (aa!=(-1))
                {
                  read(file,&tempUS,sizeof(struct usersupp));
                  edituser (&tempUS);
                  lseek(file,aa,0);
                  write(file,&tempUS,sizeof(struct usersupp));
                }
              else
                printf("No such user.\n");
	    }
	  close(file);
	  break;
	case 8:                                       /* known rooms */
	  e=setjmp(nextbuf);
	  if (e==0) 
	    {
	      signal(SIGINT,(*backnext));
	      signal(SIGQUIT,(*backstop));
	      sttybbs(1);
	      knrooms(&usersupp);
	    }
	  sttybbs(0);
	  signal(SIGINT,SIG_IGN);
	  signal(SIGQUIT,SIG_IGN);
	  printf("\n");
	  break;
	case 19:                                       /* zapped rooms */
	  e=setjmp(nextbuf);
	  if (e==0) 
	    {
	      signal(SIGINT,(*backnext));
	      signal(SIGQUIT,(*backstop));
	      sttybbs(1);
	      listzrooms(&usersupp);
	    }
	  sttybbs(0);
	  signal(SIGINT,SIG_IGN);
	  signal(SIGQUIT,SIG_IGN);
	  printf("\n");
	  break;
	case 91: 
	  print_type (curr_rm);
	  break;
	} /* end switch */
    } 
  while(termn8==0);

 TERMN8:
  if ((mcmd==29) || (mcmd==15) || (mcmd==99) || (mcmd==666)) 
    {

#ifdef ENABLE_FEEDBACK
      leave_feedback();
#endif

      printf("\n*** Fortune of the day ***\n\n");
      system("/usr/games/fortune -s");
      printf("\n");
      system ("/bin/cat /usr1/bbs/messages/goodbye");
      if (offstat==3) 
/*	ulog ("", offtime, mytty, offstat, hname); */
	logoff(3);
      else
	{
	  writeyerself();
	  if (usersupp.timescalled == 1) 
	    offstat = 5;
	  else
	    offstat=0; 
	  ulog (usersupp.fullname,usersupp.lastcall,mytty,offstat,
		usersupp.lasthost); 
	  outlog();
	}
      logoff(3);
    }
  goto GSTA;

} /* end main() */

gotonext() /* goto next room having unread messages */
{
  int a,b,c,d,f,file;
 GNTOP:	
  curr_rm=0; 
  f=1;

/* mail comes first */

  if (usersupp.mailnum[MAILSLOTS-1]>usersupp.lastseen[1]) 
    {
      usergoto(1,f);
      return(0);
    } 
  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr (55);
  for (a=0; a<2; ++a) 
    read(file,&QRscratch,sizeof(struct quickroom));

/* skip Lobby and Mail */
  
  for (a=2; a<MAXROOMS; ++a) 
    {
      d=read(file,&QRscratch,sizeof(struct quickroom));
      if (d<1) 
	interr(56);
      if ((QRscratch.QRflags & QR_INUSE)
	  && (QRscratch.QRhighest>usersupp.lastseen[a])
	  && (QRscratch.QRgen != usersupp.forget[a])
	  && (((QRscratch.QRflags&QR_PRIVATE)==0)
	      || (usersupp.axlevel>=6)
	      || (QRscratch.QRgen==usersupp.generation[a])
	      )
	  && (((QRscratch.QRflags&QR_PREFONLY)==0)
	      || (usersupp.axlevel>=5)
	      )
	  && (skipping[a]==0)
	  && ( (a!=2) || (usersupp.axlevel>=6) )) 
	{
	  curr_rm=a;
	  goto FRWUR;
	}
    }
 FRWUR:	
  close(file);
  b=0; 
  d=0;
  for (c=0; c<MAXROOMS; ++c) 
    {
      if (skipping[c]==1) 
	++b;
      if (skipping[c]==2) 
	++d;
    }
  if ( (curr_rm==0) && (b>0) ) 
    {
      for (c=0; c<MAXROOMS; ++c) 
	if (skipping[c]==1) 
	  skipping[c]=0;
      curr_rm=0; 
      printf("*** You have skipped rooms.\n");
    }
  if ( (curr_rm==0) && (d>0) ) 
    {
      for (c=0; c<MAXROOMS; ++c) 
	if (skipping[c]==2)
	  skipping[c]=0;
      goto GNTOP;
    }
  skipping[curr_rm]=2;
  usergoto(curr_rm,f);
  return(0);
}

dotgoto() 
{
  int a,b,d,f,file;
  char aaa[20],bbb[20];
  f=0;	/* flag for dgfoundit */

  getline(aaa,19);
  for (a=0; a<strlen(aaa); ++a) 
    aaa[a]=ctolower(aaa[a]);
  IFNAIDE 
    if ((!strucmp(aaa,"aide")) || (!strucmp(aaa,"aid"))) 
      {
	printf("Need aide access to enter Aide> room\n");
	return(1);
      }
  file=open("quickroom",O_RDONLY);
  for (a=0; a<MAXROOMS; ++a) 
    {
      d=read(file,&QRscratch,sizeof(struct quickroom));
      if (d<1) interr(73);
      strcpy(bbb,QRscratch.QRname);
      for (b=0; b<strlen(bbb); ++b)
	bbb[b]=ctolower(bbb[b]);
      if ((strcmp(bbb,aaa)==0)
	  && ((QRscratch.QRflags&QR_INUSE)!=0)
	  && (((QRscratch.QRflags&QR_PREFONLY)==0)
	      || (usersupp.axlevel>=5))
	  && (((QRscratch.QRflags&QR_PRIVATE)==0)
	      || (QRscratch.QRflags&QR_GUESSNAME)
	      || (usersupp.axlevel>=6)
	      || (QRscratch.QRflags&QR_PASSWORDED)
	      || (QRscratch.QRgen==usersupp.generation[a])))
	{
	  close(file);
	  if ((QRscratch.QRflags&QR_PASSWORDED) &&
	      (usersupp.axlevel<6) &&
	      (QRscratch.QRgen!=usersupp.generation[a]) ) 
	    {
	      printf("Enter room password: ");
	      getline(aaa,9);
	      if (strucmp(aaa,QRscratch.QRpasswd)) 
		{
		  printf("Wrong password.\n"); 
		  return(1); 
		} 
	    }
	  usergoto(a,f); 
	  return(0);
	}
    }
  lseek(file,0L,0);
  for (a=0; a<MAXROOMS; ++a) 
    {
      read(file,&QRscratch,sizeof(struct quickroom));
      strcpy(bbb,QRscratch.QRname);
      for (b=0; b<strlen(bbb); ++b) 
	bbb[b]=ctolower(bbb[b]);
      if ((pattern(bbb,aaa)==0)
	  && ((QRscratch.QRflags&QR_INUSE)!=0)
	  && (((QRscratch.QRflags&QR_PREFONLY)==0)
	      || (usersupp.axlevel>=5))
	  && (((QRscratch.QRflags&QR_PRIVATE)==0)
	      || (QRscratch.QRgen==usersupp.generation[a])))
	{ 
	  close(file);
	  usergoto(a,f);
	  return(0); 
	}
    }
  close(file);
  printf("No room '%s'.\n",aaa);
  return(1);
}

usergoto(where,f)	/* used by <G>oto and .<G>oto */
     int where; 
{
  int a,b,c;
  curr_rm=where;

  gotocurr();
  b=0; 
  c=0;
  for (a=0; a<MSGSPERRM; ++a) 
    {
      if (fullroom.FRnum[a]>0L)
	if (fullroom.FRnum[a]>=msgmain.MMlowest)
	  {
	    ++b;
	    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm]) 
	      ++c;
	  } 
    }
  if (f==1) 
    printf("%s ",quickroom.QRname);
  printf("(%d messages, %d new)\n",b,c);
  readyerself();
  usersupp.forget[curr_rm]=(-1);
  if (usersupp.generation[curr_rm] !=quickroom.QRgen)
    {
      print_desc(curr_rm, quickroom.QRname);
      usersupp.generation[curr_rm]=quickroom.QRgen;
    }
  writeyerself();
  skipping[curr_rm]=0;
  unseen = MSGSPERRM-c;
  return(curr_rm);
}

logoff(code) /* exit program */
     int code;
{
  unlink(temp);         /* remove temporary file, in case it's still around */
  clear_btmp();         /* remove user from bbswho */	
  exit(3);		/* exit with the proper exit code used to be (code)*/
}

loadtroom() 
{
  int file,a,b;

  if (twitroom>=0) 
    return(0);
  twitroom=2; /* use the Aide> room if TWITROOM isn't found */
  file=open("quickroom",O_RDONLY);
  for (a=0; a<MAXROOMS; ++a) 
    {
      b=read(file,&QRscratch,sizeof(struct quickroom));
      if (b<1) 
	interr(85);
      if ((!strucmp(QRscratch.QRname,TWITROOM))
	  &&((QRscratch.QRflags&QR_INUSE)==QR_INUSE)) 
	twitroom=a;
    }
  close(file);
  return(0);
}

lock_valid() 	/* set global flag calling for validation */
{
  int file;
  struct msgmain msgmain;

  do 
    {
      file=eopen("structures/MMstructure.0",O_RDWR);
      read(file,&msgmain,sizeof(struct msgmain));
      close(file);
      if (msgmain.MMflags&MM_BUSY) 
	sleep(1);
    } 
  while (msgmain.MMflags&MM_BUSY);

  msgmain.MMflags=(msgmain.MMflags|MM_VALID);
  file=eopen("structures/MMstructure.0",O_WRONLY);
  write(file,&msgmain,sizeof(struct msgmain));
  close(file);
  return(0);
}


leave_feedback()
{
  if ((usersupp.timescalled == 1) || (usersupp.timescalled % 10 == 0))
    {
      printf ("\nDo you wish to leave a message to the sysops? ");
      if (yesno()==1)
	{
	  printf ("\nPress return twice when finished.\n");
	  curr_rm=1;
	  feedback_flag=1;
	  gotocurr();
	  entmsg(0,0,0);
	}
    }
}

print_cookie()
{

  struct cookie {
                  char line1[61];
                  char line2[61];
                } cookie;
  
  int file;
  long aa, nrecs;

  file = open ("cookies", O_RDONLY);
  if (file < 0 )  { exit(0); }

  time(&aa);
  srandom(aa);

  aa=lseek(file,0L,2); 
  nrecs=(aa/sizeof(struct cookie));
  lseek (file,(long) ((random() % nrecs)*sizeof(cookie)), SEEK_SET);
  read(file,&cookie,sizeof(struct cookie));
  close (file);
  aa = (80 - strlen(cookie.line1)) / 2;
  for ( ; aa; aa--) printf(" ");
  printf ("%s\n", cookie.line1 );
  aa = (80 - strlen(cookie.line2)) / 2;
  if (aa != 40)
  {
    for ( ; aa; aa--) printf(" ");
    printf ("%s\n", cookie.line2 );
  }
 
  return;
}
